/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.encode.tokenize;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.prefixtree.encode.tokenize.Tokenizer;
import org.apache.hadoop.hbase.codec.prefixtree.encode.tokenize.TokenizerRowSearchPosition;
import org.apache.hadoop.hbase.codec.prefixtree.encode.tokenize.TokenizerRowSearchResult;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.ByteRangeUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.apache.hadoop.hbase.util.SimpleByteRange;
import org.apache.hadoop.hbase.util.Strings;

@InterfaceAudience.Private
public class TokenizerNode {
    protected Tokenizer builder;
    protected TokenizerNode parent;
    protected int nodeDepth;
    protected int tokenStartOffset;
    protected ByteRange token = new SimpleByteRange();
    protected int numOccurrences;
    protected ArrayList<TokenizerNode> children;
    protected long id;
    protected int firstInsertionIndex = -1;
    protected int negativeIndex = 0;
    protected int outputArrayOffset = -1;

    public TokenizerNode(Tokenizer builder, TokenizerNode parent, int nodeDepth, int tokenStartOffset, int tokenOffset, int tokenLength) {
        this.reconstruct(builder, parent, nodeDepth, tokenStartOffset, tokenOffset, tokenLength);
        this.children = Lists.newArrayList();
    }

    public void reconstruct(Tokenizer builder, TokenizerNode parent, int nodeDepth, int tokenStartOffset, int tokenOffset, int tokenLength) {
        this.builder = builder;
        this.id = builder.nextNodeId();
        this.parent = parent;
        this.nodeDepth = nodeDepth;
        builder.submitMaxNodeDepthCandidate(nodeDepth);
        this.tokenStartOffset = tokenStartOffset;
        this.token.set(builder.tokens, tokenOffset, tokenLength);
        this.numOccurrences = 1;
    }

    public void reset() {
        this.builder = null;
        this.parent = null;
        this.nodeDepth = 0;
        this.tokenStartOffset = 0;
        this.token.unset();
        this.numOccurrences = 0;
        this.children.clear();
        this.id = 0L;
        this.firstInsertionIndex = -1;
        this.negativeIndex = 0;
        this.outputArrayOffset = -1;
    }

    public void addSorted(ByteRange bytes) {
        TokenizerNode lastChild;
        if (this.matchesToken(bytes) && CollectionUtils.notEmpty(this.children) && (lastChild = (TokenizerNode)CollectionUtils.getLast(this.children)).partiallyMatchesToken(bytes)) {
            lastChild.addSorted(bytes);
            return;
        }
        int numIdenticalTokenBytes = this.numIdenticalBytes(bytes);
        int tailOffset = this.tokenStartOffset + numIdenticalTokenBytes;
        int tailLength = bytes.getLength() - tailOffset;
        if (numIdenticalTokenBytes == this.token.getLength()) {
            if (tailLength == 0) {
                this.incrementNumOccurrences(1);
            } else {
                int childNodeDepth = this.nodeDepth + 1;
                int childTokenStartOffset = this.tokenStartOffset + numIdenticalTokenBytes;
                TokenizerNode newChildNode = this.builder.addNode(this, childNodeDepth, childTokenStartOffset, bytes, tailOffset);
                this.addChild(newChildNode);
            }
        } else {
            this.split(numIdenticalTokenBytes, bytes);
        }
    }

    protected void addChild(TokenizerNode node) {
        node.setParent(this);
        this.children.add(node);
    }

    protected void split(int numTokenBytesToRetain, ByteRange bytes) {
        int childNodeDepth = this.nodeDepth;
        int childTokenStartOffset = this.tokenStartOffset + numTokenBytesToRetain;
        TokenizerNode firstChild = this.builder.addNode(this, childNodeDepth, childTokenStartOffset, this.token, numTokenBytesToRetain);
        firstChild.setNumOccurrences(this.numOccurrences);
        this.token.setLength(numTokenBytesToRetain);
        this.numOccurrences = 0;
        this.moveChildrenToDifferentParent(firstChild);
        this.addChild(firstChild);
        TokenizerNode secondChild = this.builder.addNode(this, childNodeDepth, childTokenStartOffset, bytes, this.tokenStartOffset + numTokenBytesToRetain);
        this.addChild(secondChild);
        firstChild.incrementNodeDepthRecursively();
        secondChild.incrementNodeDepthRecursively();
    }

    protected void incrementNodeDepthRecursively() {
        ++this.nodeDepth;
        this.builder.submitMaxNodeDepthCandidate(this.nodeDepth);
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).incrementNodeDepthRecursively();
        }
    }

    protected void moveChildrenToDifferentParent(TokenizerNode newParent) {
        for (int i = 0; i < this.children.size(); ++i) {
            TokenizerNode child = this.children.get(i);
            child.setParent(newParent);
            newParent.children.add(child);
        }
        this.children.clear();
    }

    protected boolean partiallyMatchesToken(ByteRange bytes) {
        return this.numIdenticalBytes(bytes) > 0;
    }

    protected boolean matchesToken(ByteRange bytes) {
        return this.numIdenticalBytes(bytes) == this.getTokenLength();
    }

    protected int numIdenticalBytes(ByteRange bytes) {
        return ByteRangeUtils.numEqualPrefixBytes((ByteRange)this.token, (ByteRange)bytes, (int)this.tokenStartOffset);
    }

    public void appendNodesToExternalList(List<TokenizerNode> appendTo, boolean includeNonLeaves, boolean includeLeaves) {
        if (includeNonLeaves && !this.isLeaf() || includeLeaves && this.isLeaf()) {
            appendTo.add(this);
        }
        for (int i = 0; i < this.children.size(); ++i) {
            TokenizerNode child = this.children.get(i);
            child.appendNodesToExternalList(appendTo, includeNonLeaves, includeLeaves);
        }
    }

    public int setInsertionIndexes(int nextIndex) {
        int newNextIndex = nextIndex;
        if (this.hasOccurrences()) {
            this.setFirstInsertionIndex(nextIndex);
            newNextIndex += this.numOccurrences;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            TokenizerNode child = this.children.get(i);
            newNextIndex = child.setInsertionIndexes(newNextIndex);
        }
        return newNextIndex;
    }

    public void appendOutputArrayOffsets(List<Integer> offsets) {
        if (this.hasOccurrences()) {
            offsets.add(this.outputArrayOffset);
        }
        for (int i = 0; i < this.children.size(); ++i) {
            TokenizerNode child = this.children.get(i);
            child.appendOutputArrayOffsets(offsets);
        }
    }

    public void getNode(TokenizerRowSearchResult resultHolder, byte[] key, int keyOffset, int keyLength) {
        int i;
        int thisNodeDepthPlusLength = this.tokenStartOffset + this.token.getLength();
        if (CollectionUtils.isEmpty(this.children) && thisNodeDepthPlusLength < keyLength) {
            resultHolder.set(TokenizerRowSearchPosition.NO_MATCH, null);
            return;
        }
        for (i = 0; i < this.token.getLength(); ++i) {
            if (key[this.tokenStartOffset + keyOffset + i] == this.token.get(i)) continue;
            resultHolder.set(TokenizerRowSearchPosition.NO_MATCH, null);
            return;
        }
        if (thisNodeDepthPlusLength == keyLength && this.numOccurrences > 0) {
            resultHolder.set(TokenizerRowSearchPosition.MATCH, this);
            return;
        }
        if (CollectionUtils.notEmpty(this.children)) {
            for (i = 0; i < this.children.size(); ++i) {
                TokenizerNode child = this.children.get(i);
                child.getNode(resultHolder, key, keyOffset, keyLength);
                if (resultHolder.isMatch()) {
                    return;
                }
                if (resultHolder.getDifference() != TokenizerRowSearchPosition.BEFORE) continue;
                resultHolder.set(TokenizerRowSearchPosition.NO_MATCH, null);
                return;
            }
        }
        resultHolder.set(TokenizerRowSearchPosition.NO_MATCH, null);
    }

    public byte[] getNewByteArray() {
        byte[] arrayToFill = new byte[this.tokenStartOffset + this.token.getLength()];
        this.fillInBytes(arrayToFill);
        return arrayToFill;
    }

    public void fillInBytes(byte[] arrayToFill) {
        for (int i = 0; i < this.token.getLength(); ++i) {
            arrayToFill[this.tokenStartOffset + i] = this.token.get(i);
        }
        if (this.parent != null) {
            this.parent.fillInBytes(arrayToFill);
        }
    }

    public String toString() {
        String s = "";
        s = this.parent == null ? s + "R " : s + this.getBnlIndicator(false) + " " + Bytes.toString((byte[])this.parent.getNewByteArray());
        s = s + "[" + Bytes.toString((byte[])this.token.deepCopyToNewArray()) + "]";
        if (this.numOccurrences > 0) {
            s = s + "x" + this.numOccurrences;
        }
        return s;
    }

    public String getPaddedTokenAndOccurrenceString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBnlIndicator(true));
        sb.append(Strings.padFront((String)(this.numOccurrences + ""), (char)' ', (int)3));
        sb.append(Strings.padFront((String)(this.nodeDepth + ""), (char)' ', (int)3));
        if (this.outputArrayOffset >= 0) {
            sb.append(Strings.padFront((String)(this.outputArrayOffset + ""), (char)' ', (int)3));
        }
        sb.append("  ");
        for (int i = 0; i < this.tokenStartOffset; ++i) {
            sb.append(" ");
        }
        sb.append(Bytes.toString((byte[])this.token.deepCopyToNewArray()).replaceAll(" ", "_"));
        return sb.toString();
    }

    public String getBnlIndicator(boolean indent) {
        if (indent) {
            if (this.isNub()) {
                return " N ";
            }
            return this.isBranch() ? "B  " : "  L";
        }
        if (this.isNub()) {
            return "N";
        }
        return this.isBranch() ? "B" : "L";
    }

    public int getNumBranchNodesIncludingThisNode() {
        if (this.isLeaf()) {
            return 0;
        }
        int totalFromThisPlusChildren = this.isBranch() ? 1 : 0;
        for (int i = 0; i < this.children.size(); ++i) {
            TokenizerNode child = this.children.get(i);
            totalFromThisPlusChildren += child.getNumBranchNodesIncludingThisNode();
        }
        return totalFromThisPlusChildren;
    }

    public int getNumNubNodesIncludingThisNode() {
        if (this.isLeaf()) {
            return 0;
        }
        int totalFromThisPlusChildren = this.isNub() ? 1 : 0;
        for (int i = 0; i < this.children.size(); ++i) {
            TokenizerNode child = this.children.get(i);
            totalFromThisPlusChildren += child.getNumNubNodesIncludingThisNode();
        }
        return totalFromThisPlusChildren;
    }

    public int getNumLeafNodesIncludingThisNode() {
        if (this.isLeaf()) {
            return 1;
        }
        int totalFromChildren = 0;
        for (int i = 0; i < this.children.size(); ++i) {
            TokenizerNode child = this.children.get(i);
            totalFromChildren += child.getNumLeafNodesIncludingThisNode();
        }
        return totalFromChildren;
    }

    public int getNodeDepth() {
        return this.nodeDepth;
    }

    public int getTokenLength() {
        return this.token.getLength();
    }

    public boolean hasOccurrences() {
        return this.numOccurrences > 0;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public int getNumChildren() {
        return CollectionUtils.nullSafeSize(this.children);
    }

    public TokenizerNode getLastChild() {
        if (CollectionUtils.isEmpty(this.children)) {
            return null;
        }
        return (TokenizerNode)CollectionUtils.getLast(this.children);
    }

    public boolean isLeaf() {
        return CollectionUtils.isEmpty(this.children) && this.hasOccurrences();
    }

    public boolean isBranch() {
        return CollectionUtils.notEmpty(this.children) && !this.hasOccurrences();
    }

    public boolean isNub() {
        return CollectionUtils.notEmpty(this.children) && this.hasOccurrences();
    }

    public void incrementNumOccurrences(int d) {
        this.numOccurrences += d;
    }

    public int getTokenOffset() {
        return this.tokenStartOffset;
    }

    public TokenizerNode getParent() {
        return this.parent;
    }

    public ByteRange getToken() {
        return this.token;
    }

    public int getNumOccurrences() {
        return this.numOccurrences;
    }

    public void setParent(TokenizerNode parent) {
        this.parent = parent;
    }

    public void setNumOccurrences(int numOccurrences) {
        this.numOccurrences = numOccurrences;
    }

    public ArrayList<TokenizerNode> getChildren() {
        return this.children;
    }

    public long getId() {
        return this.id;
    }

    public int getFirstInsertionIndex() {
        return this.firstInsertionIndex;
    }

    public void setFirstInsertionIndex(int firstInsertionIndex) {
        this.firstInsertionIndex = firstInsertionIndex;
    }

    public int getNegativeIndex() {
        return this.negativeIndex;
    }

    public void setNegativeIndex(int negativeIndex) {
        this.negativeIndex = negativeIndex;
    }

    public int getOutputArrayOffset() {
        return this.outputArrayOffset;
    }

    public void setOutputArrayOffset(int outputArrayOffset) {
        this.outputArrayOffset = outputArrayOffset;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setBuilder(Tokenizer builder) {
        this.builder = builder;
    }

    public void setTokenOffset(int tokenOffset) {
        this.tokenStartOffset = tokenOffset;
    }

    public void setToken(ByteRange token) {
        this.token = token;
    }
}

