/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store;

import javax.naming.spi.InitialContextFactory;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.store.MultiBaseSearch;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.SingleBaseSearch;
import org.apache.directory.server.protocol.shared.ServiceConfiguration;

public class JndiPrincipalStoreImpl
implements PrincipalStore {
    private ServiceConfiguration config;
    private InitialContextFactory factory;
    private PrincipalStore store;

    public JndiPrincipalStoreImpl(ServiceConfiguration config, InitialContextFactory factory) {
        this.config = config;
        this.factory = factory;
        this.store = this.getStore();
    }

    public String addPrincipal(PrincipalStoreEntry entry) throws Exception {
        return this.store.addPrincipal(entry);
    }

    public String deletePrincipal(KerberosPrincipal principal) throws Exception {
        return this.store.deletePrincipal(principal);
    }

    public PrincipalStoreEntry[] getAllPrincipals(String realm) throws Exception {
        return this.store.getAllPrincipals(realm);
    }

    public PrincipalStoreEntry getPrincipal(KerberosPrincipal principal) throws Exception {
        return this.store.getPrincipal(principal);
    }

    public String changePassword(KerberosPrincipal principal, KerberosKey newKey) throws Exception {
        return this.store.changePassword(principal, newKey);
    }

    private PrincipalStore getStore() {
        if (this.config.getCatalogBaseDn() != null) {
            return new MultiBaseSearch(this.config, this.factory);
        }
        return new SingleBaseSearch(this.config, this.factory);
    }
}

