/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.encryption;

import org.apache.directory.server.kerberos.shared.crypto.encryption.Des3CbcMd5Encryption;
import org.apache.directory.server.kerberos.shared.crypto.encryption.Des3CbcSha1Encryption;
import org.apache.directory.server.kerberos.shared.crypto.encryption.DesCbcMd5Encryption;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionEngine;
import org.apache.directory.server.kerberos.shared.crypto.encryption.NullEncryption;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;

public class EncryptionEngineFactory {
    public static EncryptionEngine getEncryptionEngineFor(EncryptionKey key) throws KerberosException {
        int type = key.getKeyType().getOrdinal();
        switch (type) {
            case 0: {
                return new NullEncryption();
            }
            case 3: {
                return new DesCbcMd5Encryption();
            }
            case 5: {
                return new Des3CbcMd5Encryption();
            }
            case 7: {
                return new Des3CbcSha1Encryption();
            }
        }
        throw new KerberosException(ErrorType.KDC_ERR_ETYPE_NOSUPP);
    }
}

