/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.asn1.codec.stateful.EncoderCallback;
import org.apache.directory.shared.asn1.codec.stateful.EncoderMonitor;
import org.apache.directory.shared.ldap.codec.TwixTransformer;
import org.apache.directory.shared.ldap.message.InternalMessage;
import org.apache.directory.shared.ldap.message.MessageException;
import org.apache.directory.shared.ldap.message.spi.Provider;
import org.apache.directory.shared.ldap.message.spi.ProviderEncoder;
import org.apache.directory.shared.ldap.message.spi.ProviderException;

public final class MessageEncoder
implements ProviderEncoder {
    private final Provider provider = Provider.getProvider(Provider.getEnvironment());
    private final ProviderEncoder encoder = this.provider.getEncoder();

    public void encodeBlocking(Object lock, OutputStream out, Object obj) throws ProviderException {
        Object providerEnvelope = TwixTransformer.transform((InternalMessage)obj);
        this.encoder.encodeBlocking(lock, out, providerEnvelope);
    }

    public ByteBuffer encodeBlocking(Object obj) throws ProviderException {
        Object providerEnvelope = TwixTransformer.transform((InternalMessage)obj);
        return this.encoder.encodeBlocking(providerEnvelope);
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void encode(Object obj) throws EncoderException {
        Object providerEnvelope = TwixTransformer.transform((InternalMessage)obj);
        this.encoder.encode(providerEnvelope);
    }

    public void setCallback(EncoderCallback cb) {
        this.encoder.setCallback(cb);
    }

    public void setEncoderMonitor(EncoderMonitor monitor) {
        this.encoder.setEncoderMonitor(monitor);
    }
}

