/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.AsymmetricBinding;
import org.apache.cxf.ws.security.policy.model.InitiatorEncryptionToken;
import org.apache.cxf.ws.security.policy.model.InitiatorSignatureToken;
import org.apache.cxf.ws.security.policy.model.InitiatorToken;
import org.apache.cxf.ws.security.policy.model.Layout;
import org.apache.cxf.ws.security.policy.model.RecipientEncryptionToken;
import org.apache.cxf.ws.security.policy.model.RecipientSignatureToken;
import org.apache.cxf.ws.security.policy.model.RecipientToken;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsymmetricBindingBuilder
implements AssertionBuilder<Element> {
    PolicyBuilder builder;

    public AsymmetricBindingBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.ASYMMETRIC_BINDING, SP12Constants.ASYMMETRIC_BINDING};
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        AsymmetricBinding asymmetricBinding = new AsymmetricBinding(consts, this.builder);
        Policy policy = this.builder.getPolicy((Object)DOMUtils.getFirstElement((Node)element));
        Iterator iterator = (policy = policy.normalize(this.builder.getPolicyRegistry(), false)).getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternative((List)iterator.next(), asymmetricBinding, consts);
        }
        return asymmetricBinding;
    }

    private void processAlternative(List assertions, AsymmetricBinding asymmetricBinding, SPConstants consts) {
        for (Assertion assertion : assertions) {
            QName name = assertion.getName();
            if (!consts.getNamespace().equals(name.getNamespaceURI()) && !SP12Constants.INSTANCE.getNamespace().equals(name.getNamespaceURI())) continue;
            if ("InitiatorToken".equals(name.getLocalPart())) {
                asymmetricBinding.setInitiatorToken((InitiatorToken)assertion);
                continue;
            }
            if ("InitiatorSignatureToken".equals(name.getLocalPart())) {
                asymmetricBinding.setInitiatorSignatureToken((InitiatorSignatureToken)assertion);
                continue;
            }
            if ("InitiatorEncryptionToken".equals(name.getLocalPart())) {
                asymmetricBinding.setInitiatorEncryptionToken((InitiatorEncryptionToken)assertion);
                continue;
            }
            if ("RecipientToken".equals(name.getLocalPart())) {
                asymmetricBinding.setRecipientToken((RecipientToken)assertion);
                continue;
            }
            if ("RecipientSignatureToken".equals(name.getLocalPart())) {
                asymmetricBinding.setRecipientSignatureToken((RecipientSignatureToken)assertion);
                continue;
            }
            if ("RecipientEncryptionToken".equals(name.getLocalPart())) {
                asymmetricBinding.setRecipientEncryptionToken((RecipientEncryptionToken)assertion);
                continue;
            }
            if ("AlgorithmSuite".equals(name.getLocalPart())) {
                asymmetricBinding.setAlgorithmSuite((AlgorithmSuite)assertion);
                continue;
            }
            if ("Layout".equals(name.getLocalPart())) {
                asymmetricBinding.setLayout((Layout)assertion);
                continue;
            }
            if ("IncludeTimestamp".equals(name.getLocalPart())) {
                asymmetricBinding.setIncludeTimestamp(true);
                continue;
            }
            if ("EncryptBeforeSigning".equals(name.getLocalPart())) {
                asymmetricBinding.setProtectionOrder(SPConstants.ProtectionOrder.EncryptBeforeSigning);
                continue;
            }
            if ("SignBeforeEncrypting".equals(name.getLocalPart())) {
                asymmetricBinding.setProtectionOrder(SPConstants.ProtectionOrder.SignBeforeEncrypting);
                continue;
            }
            if ("EncryptSignature".equals(name.getLocalPart())) {
                asymmetricBinding.setSignatureProtection(true);
                continue;
            }
            if ("ProtectTokens".equals(name.getLocalPart())) {
                asymmetricBinding.setTokenProtection(true);
                continue;
            }
            if (!"OnlySignEntireHeadersAndBody".equals(name.getLocalPart())) continue;
            asymmetricBinding.setEntireHeadersAndBodySignatures(true);
        }
    }
}

