/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.messages;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.websocket.MessageHandler;
import org.eclipse.jetty.websocket.common.message.MessageAppender;
import org.eclipse.jetty.websocket.common.util.Utf8PartialBuilder;
import org.eclipse.jetty.websocket.jsr356.MessageHandlerWrapper;

public class TextPartialMessage
implements MessageAppender {
    private final MessageHandlerWrapper msgWrapper;
    private final MessageHandler.Partial<String> partialHandler;
    private final Utf8PartialBuilder utf8Partial;

    public TextPartialMessage(MessageHandlerWrapper wrapper) {
        this.msgWrapper = wrapper;
        this.partialHandler = (MessageHandler.Partial)wrapper.getHandler();
        this.utf8Partial = new Utf8PartialBuilder();
    }

    @Override
    public void appendFrame(ByteBuffer payload, boolean isLast) throws IOException {
        String partialText = this.utf8Partial.toPartialString(payload);
        this.partialHandler.onMessage(partialText, isLast);
    }

    @Override
    public void messageComplete() {
    }
}

