/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.scheduler;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.activemq.store.kahadb.AbstractKahaDBMetaData;
import org.apache.activemq.store.kahadb.disk.index.BTreeIndex;
import org.apache.activemq.store.kahadb.disk.page.Transaction;
import org.apache.activemq.store.kahadb.disk.util.IntegerMarshaller;
import org.apache.activemq.store.kahadb.disk.util.LocationMarshaller;
import org.apache.activemq.store.kahadb.disk.util.StringMarshaller;
import org.apache.activemq.store.kahadb.disk.util.VariableMarshaller;
import org.apache.activemq.store.kahadb.scheduler.JobSchedulerImpl;
import org.apache.activemq.store.kahadb.scheduler.JobSchedulerStoreImpl;
import org.apache.activemq.store.kahadb.scheduler.UnknownStoreVersionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobSchedulerKahaDBMetaData
extends AbstractKahaDBMetaData<JobSchedulerKahaDBMetaData> {
    static final Logger LOG = LoggerFactory.getLogger(JobSchedulerKahaDBMetaData.class);
    private final JobSchedulerStoreImpl store;
    private UUID token = JobSchedulerStoreImpl.SCHEDULER_STORE_TOKEN;
    private int version = 1;
    private BTreeIndex<Integer, List<Integer>> removeLocationTracker;
    private BTreeIndex<Integer, Integer> journalRC;
    private BTreeIndex<String, JobSchedulerImpl> storedSchedulers;

    public JobSchedulerKahaDBMetaData(JobSchedulerStoreImpl store2) {
        this.store = store2;
    }

    public UUID getToken() {
        return this.token;
    }

    public int getVersion() {
        return this.version;
    }

    public BTreeIndex<Integer, List<Integer>> getRemoveLocationTracker() {
        return this.removeLocationTracker;
    }

    public BTreeIndex<Integer, Integer> getJournalRC() {
        return this.journalRC;
    }

    public BTreeIndex<String, JobSchedulerImpl> getJobSchedulers() {
        return this.storedSchedulers;
    }

    @Override
    public void initialize(Transaction tx) throws IOException {
        this.storedSchedulers = new BTreeIndex(this.store.getPageFile(), tx.allocate().getPageId());
        this.journalRC = new BTreeIndex(this.store.getPageFile(), tx.allocate().getPageId());
        this.removeLocationTracker = new BTreeIndex(this.store.getPageFile(), tx.allocate().getPageId());
    }

    @Override
    public void load(Transaction tx) throws IOException {
        this.storedSchedulers.setKeyMarshaller(StringMarshaller.INSTANCE);
        this.storedSchedulers.setValueMarshaller(new JobSchedulerMarshaller(this.store));
        this.storedSchedulers.load(tx);
        this.journalRC.setKeyMarshaller(IntegerMarshaller.INSTANCE);
        this.journalRC.setValueMarshaller(IntegerMarshaller.INSTANCE);
        this.journalRC.load(tx);
        this.removeLocationTracker.setKeyMarshaller(IntegerMarshaller.INSTANCE);
        this.removeLocationTracker.setValueMarshaller(new IntegerListMarshaller());
        this.removeLocationTracker.load(tx);
    }

    public void loadScheduler(Transaction tx, Map<String, JobSchedulerImpl> schedulers) throws IOException {
        Iterator<Map.Entry<String, JobSchedulerImpl>> i = this.storedSchedulers.iterator(tx);
        while (i.hasNext()) {
            Map.Entry<String, JobSchedulerImpl> entry = i.next();
            entry.getValue().load(tx);
            schedulers.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void read(DataInput in) throws IOException {
        try {
            long msb = in.readLong();
            long lsb = in.readLong();
            this.token = new UUID(msb, lsb);
        }
        catch (Exception e) {
            throw new UnknownStoreVersionException(e);
        }
        if (!this.token.equals(JobSchedulerStoreImpl.SCHEDULER_STORE_TOKEN)) {
            throw new UnknownStoreVersionException(this.token.toString());
        }
        this.version = in.readInt();
        if (in.readBoolean()) {
            this.setLastUpdateLocation(LocationMarshaller.INSTANCE.readPayload(in));
        } else {
            this.setLastUpdateLocation(null);
        }
        this.storedSchedulers = new BTreeIndex(this.store.getPageFile(), in.readLong());
        this.storedSchedulers.setKeyMarshaller(StringMarshaller.INSTANCE);
        this.storedSchedulers.setValueMarshaller(new JobSchedulerMarshaller(this.store));
        this.journalRC = new BTreeIndex(this.store.getPageFile(), in.readLong());
        this.journalRC.setKeyMarshaller(IntegerMarshaller.INSTANCE);
        this.journalRC.setValueMarshaller(IntegerMarshaller.INSTANCE);
        this.removeLocationTracker = new BTreeIndex(this.store.getPageFile(), in.readLong());
        this.removeLocationTracker.setKeyMarshaller(IntegerMarshaller.INSTANCE);
        this.removeLocationTracker.setValueMarshaller(new IntegerListMarshaller());
        LOG.info("Scheduler Store version {} loaded", (Object)this.version);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.token.getMostSignificantBits());
        out.writeLong(this.token.getLeastSignificantBits());
        out.writeInt(this.version);
        if (this.getLastUpdateLocation() != null) {
            out.writeBoolean(true);
            LocationMarshaller.INSTANCE.writePayload(this.getLastUpdateLocation(), out);
        } else {
            out.writeBoolean(false);
        }
        out.writeLong(this.storedSchedulers.getPageId());
        out.writeLong(this.journalRC.getPageId());
        out.writeLong(this.removeLocationTracker.getPageId());
    }

    private class IntegerListMarshaller
    extends VariableMarshaller<List<Integer>> {
        private IntegerListMarshaller() {
        }

        @Override
        public List<Integer> readPayload(DataInput dataIn) throws IOException {
            ArrayList<Integer> result = new ArrayList<Integer>();
            int size2 = dataIn.readInt();
            for (int i = 0; i < size2; ++i) {
                result.add(IntegerMarshaller.INSTANCE.readPayload(dataIn));
            }
            return result;
        }

        @Override
        public void writePayload(List<Integer> value, DataOutput dataOut) throws IOException {
            dataOut.writeInt(value.size());
            for (Integer integer : value) {
                IntegerMarshaller.INSTANCE.writePayload(integer, dataOut);
            }
        }
    }

    private class JobSchedulerMarshaller
    extends VariableMarshaller<JobSchedulerImpl> {
        private final JobSchedulerStoreImpl store;

        JobSchedulerMarshaller(JobSchedulerStoreImpl store2) {
            this.store = store2;
        }

        @Override
        public JobSchedulerImpl readPayload(DataInput dataIn) throws IOException {
            JobSchedulerImpl result = new JobSchedulerImpl(this.store);
            result.read(dataIn);
            return result;
        }

        @Override
        public void writePayload(JobSchedulerImpl js, DataOutput dataOut) throws IOException {
            js.write(dataOut);
        }
    }
}

