/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.spring31.xml.encryption;

import org.jasypt.spring31.xml.encryption.AbstractEncryptionBeanDefinitionParser;
import org.jasypt.spring31.xml.encryption.DigesterFactoryBean;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

final class DigesterBeanDefinitionParser
extends AbstractEncryptionBeanDefinitionParser {
    private static final String SCOPE_ATTRIBUTE = "scope";
    private static final String PARAM_ALGORITHM = "algorithm";
    private static final String PARAM_CONFIG_BEAN = "config-bean";
    private static final String PARAM_ITERATIONS = "iterations";
    private static final String PARAM_SALT_SIZE_BYTES = "salt-size-bytes";
    private static final String PARAM_SALT_GENERATOR_BEAN = "salt-generator-bean";
    private static final String PARAM_PROVIDER_BEAN = "provider-bean";
    private static final String PARAM_PROVIDER_NAME = "provider-name";
    private static final String PARAM_INVERT_POSITION_OF_SALT_IN_MESSAGE_BEFORE_DIGESTING = "invert-position-of-salt-in-message-before-digesting";
    private static final String PARAM_INVERT_POSITION_OF_PLAIN_SALT_IN_ENCRYPTION_RESULTS = "invert-position-of-plain-salt-in-encryption-results";
    private static final String PARAM_USE_LENIENT_SALT_SIZE_CHECK = "use-lenient-salt-size-check";
    private static final String PARAM_POOL_SIZE = "pool-size";
    private static final String PARAM_STRING_OUTPUT_TYPE = "string-output-type";
    private static final String PARAM_UNICODE_NORMALIZATION_IGNORED = "unicode-normalization-ignored";
    private static final String PARAM_PREFIX = "prefix";
    private static final String PARAM_SUFFIX = "suffix";
    private final int digesterType;

    DigesterBeanDefinitionParser(int digesterType) {
        this.digesterType = digesterType;
    }

    protected Class<?> getBeanClass(Element element) {
        return DigesterFactoryBean.class;
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        builder.addConstructorArgValue((Object)new Integer(this.digesterType));
        this.processStringAttribute(element, builder, PARAM_ALGORITHM, PARAM_ALGORITHM);
        this.processBeanAttribute(element, builder, PARAM_CONFIG_BEAN, "config");
        this.processIntegerAttribute(element, builder, PARAM_ITERATIONS, PARAM_ITERATIONS);
        this.processIntegerAttribute(element, builder, PARAM_SALT_SIZE_BYTES, "saltSizeBytes");
        this.processBeanAttribute(element, builder, PARAM_SALT_GENERATOR_BEAN, "saltGenerator");
        this.processBeanAttribute(element, builder, PARAM_PROVIDER_BEAN, "provider");
        this.processStringAttribute(element, builder, PARAM_PROVIDER_NAME, "providerName");
        this.processBooleanAttribute(element, builder, PARAM_INVERT_POSITION_OF_SALT_IN_MESSAGE_BEFORE_DIGESTING, "invertPositionOfSaltInMessageBeforeDigesting");
        this.processBooleanAttribute(element, builder, PARAM_INVERT_POSITION_OF_PLAIN_SALT_IN_ENCRYPTION_RESULTS, "invertPositionOfPlainSaltInEncryptionResults");
        this.processBooleanAttribute(element, builder, PARAM_USE_LENIENT_SALT_SIZE_CHECK, "useLenientSaltSizeCheck");
        this.processIntegerAttribute(element, builder, PARAM_POOL_SIZE, "poolSize");
        this.processStringAttribute(element, builder, PARAM_STRING_OUTPUT_TYPE, "stringOutputType");
        this.processBooleanAttribute(element, builder, PARAM_UNICODE_NORMALIZATION_IGNORED, "unicodeNormalizationIgnored");
        this.processStringAttribute(element, builder, PARAM_PREFIX, PARAM_PREFIX);
        this.processStringAttribute(element, builder, PARAM_SUFFIX, PARAM_SUFFIX);
        String scope = element.getAttribute(SCOPE_ATTRIBUTE);
        if (StringUtils.hasLength((String)scope)) {
            builder.setScope(scope);
        }
    }
}

