/*
 * Decompiled with CFR 0.152.
 */
package org.openide.xml;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openide.ErrorManager;
import org.openide.xml.XMLUtilImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class XMLUtil {
    private static boolean useFastSAXParserFactory = true;
    private static final char[] DEC2HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static Class fastParserFactoryClass = null;
    private static final ThreadLocal[] builderTL = new ThreadLocal[4];

    private XMLUtil() {
    }

    public static XMLReader createXMLReader() throws SAXException {
        return XMLUtil.createXMLReader(false, false);
    }

    public static XMLReader createXMLReader(boolean bl) throws SAXException {
        return XMLUtil.createXMLReader(bl, false);
    }

    public static XMLReader createXMLReader(boolean bl, boolean bl2) throws SAXException {
        SAXParserFactory sAXParserFactory;
        if (!bl && useFastSAXParserFactory) {
            try {
                sAXParserFactory = XMLUtil.createFastSAXParserFactory();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                sAXParserFactory = SAXParserFactory.newInstance();
            }
            catch (SAXException sAXException) {
                sAXParserFactory = SAXParserFactory.newInstance();
            }
        } else {
            useFastSAXParserFactory = false;
            sAXParserFactory = SAXParserFactory.newInstance();
        }
        sAXParserFactory.setValidating(bl);
        sAXParserFactory.setNamespaceAware(bl2);
        try {
            return sAXParserFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("Cannot create parser satisfying configuration parameters", parserConfigurationException);
        }
    }

    public static Document createDocument(String string, String string2, String string3, String string4) throws DOMException {
        DOMImplementation dOMImplementation = XMLUtil.getDOMImplementation();
        if (string3 != null && string4 == null) {
            throw new IllegalArgumentException("System ID cannot be null if public ID specified. ");
        }
        DocumentType documentType = null;
        if (string4 != null) {
            documentType = dOMImplementation.createDocumentType(string, string3, string4);
        }
        return dOMImplementation.createDocument(string2, string, documentType);
    }

    private static DOMImplementation getDOMImplementation() throws DOMException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            return documentBuilderFactory.newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DOMException(9, "Cannot create parser satisfying configuration parameters");
        }
        catch (RuntimeException runtimeException) {
            throw (DOMException)new DOMException(9, runtimeException.toString()).initCause(runtimeException);
        }
    }

    public static Document parse(InputSource inputSource, boolean bl, boolean bl2, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException {
        int n = (bl ? 0 : 1) + (bl2 ? 0 : 2);
        DocumentBuilder documentBuilder = (DocumentBuilder)builderTL[n].get();
        if (documentBuilder == null) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(bl);
            documentBuilderFactory.setNamespaceAware(bl2);
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new SAXException("Cannot create parser satisfying configuration parameters", parserConfigurationException);
            }
            builderTL[n].set(documentBuilder);
        }
        if (errorHandler != null) {
            documentBuilder.setErrorHandler(errorHandler);
        }
        if (entityResolver != null) {
            documentBuilder.setEntityResolver(entityResolver);
        }
        return documentBuilder.parse(inputSource);
    }

    public static void write(Document document, OutputStream outputStream, String string) throws IOException {
        XMLUtilImpl.write(document, outputStream, string);
    }

    public static String toAttributeValue(String string) throws CharConversionException {
        if (string == null) {
            throw new CharConversionException("null");
        }
        if (XMLUtil.checkAttributeCharacters(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('<' == c) {
                stringBuffer.append("&lt;");
                continue;
            }
            if ('&' == c) {
                stringBuffer.append("&amp;");
                continue;
            }
            if ('\'' == c) {
                stringBuffer.append("&apos;");
                continue;
            }
            if ('\"' == c) {
                stringBuffer.append("&quot;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String toElementContent(String string) throws CharConversionException {
        if (string == null) {
            throw new CharConversionException("null");
        }
        if (XMLUtil.checkContentCharacters(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('<' == c) {
                stringBuffer.append("&lt;");
                continue;
            }
            if ('&' == c) {
                stringBuffer.append("&amp;");
                continue;
            }
            if ('>' == c && i > 1 && string.charAt(i - 2) == ']' && string.charAt(i - 1) == ']') {
                stringBuffer.append("&gt;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String toHex(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            byte by = byArray[n + i];
            stringBuffer.append(DEC2HEX[(by & 0xF0) >> 4]);
            stringBuffer.append(DEC2HEX[by & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static byte[] fromHex(char[] cArray, int n, int n2) throws IOException {
        if (cArray == null) {
            throw new IOException("null");
        }
        int n3 = cArray.length;
        if (n3 % 2 != 0) {
            throw new IOException("odd length");
        }
        byte[] byArray = new byte[n3 / 2];
        while (n3 > 0) {
            String string = new String(cArray, n3 - 2, 2);
            try {
                byArray[n3 / 2 - 1] = (byte)Integer.parseInt(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getLocalizedMessage());
            }
            n3 -= 2;
        }
        return byArray;
    }

    private static boolean checkAttributeCharacters(String string) throws CharConversionException {
        boolean bl = false;
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > ']') continue;
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block4;
                }
                case '\"': 
                case '&': 
                case '\'': 
                case '<': {
                    bl = true;
                    continue block4;
                }
                default: {
                    if (c >= ' ') continue block4;
                    throw new CharConversionException("Invalid XML character &#" + c + ";.");
                }
            }
        }
        return !bl;
    }

    private static boolean checkContentCharacters(String string) throws CharConversionException {
        boolean bl = false;
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > ']') continue;
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block5;
                }
                case '>': {
                    if (bl) continue block5;
                    bl = i > 0 && string.charAt(i - 1) == ']';
                    continue block5;
                }
                case '&': 
                case '<': {
                    bl = true;
                    continue block5;
                }
                default: {
                    if (c >= ' ') continue block5;
                    throw new CharConversionException("Invalid XML character &#" + c + ";.");
                }
            }
        }
        return !bl;
    }

    private static SAXParserFactory createFastSAXParserFactory() throws ParserConfigurationException, SAXException {
        block6: {
            if (fastParserFactoryClass == null) {
                try {
                    fastParserFactoryClass = Class.forName("org.apache.crimson.jaxp.SAXParserFactoryImpl");
                }
                catch (Exception exception) {
                    useFastSAXParserFactory = false;
                    if (!System.getProperty("java.version").startsWith("1.4")) break block6;
                    ErrorManager.getDefault().notify(1, exception);
                }
            }
        }
        if (fastParserFactoryClass != null) {
            try {
                SAXParserFactory sAXParserFactory = (SAXParserFactory)fastParserFactoryClass.newInstance();
                return sAXParserFactory;
            }
            catch (Exception exception) {
                useFastSAXParserFactory = false;
                throw new ParserConfigurationException(exception.getMessage());
            }
        }
        return SAXParserFactory.newInstance();
    }

    static {
        for (int i = 0; i < 4; ++i) {
            XMLUtil.builderTL[i] = new ThreadLocal();
        }
    }
}

