/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.test.cluster;

import java.io.StringWriter;
import java.net.SocketTimeoutException;
import org.alfresco.jlan.client.CIFSDiskSession;
import org.alfresco.jlan.client.CIFSFile;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.client.OplockAdapter;
import org.alfresco.jlan.client.SMBFile;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.smb.OpLock;
import org.alfresco.jlan.test.cluster.BooleanTestResult;
import org.alfresco.jlan.test.cluster.ExceptionTestResult;
import org.alfresco.jlan.test.cluster.Test;
import org.alfresco.jlan.test.cluster.TestResult;

public class OplockBreakLevelIITest
extends Test {
    public OplockBreakLevelIITest() {
        super("OplockBreakLevelII");
    }

    @Override
    public boolean runInit(int threadId, int curIter, DiskSession sess) {
        boolean initOK = false;
        if (threadId == 1) {
            try {
                String testFileName = this.getPerTestFileName(threadId, curIter);
                if (sess.FileExists(testFileName)) {
                    if (this.isVerbose()) {
                        Debug.println("File " + testFileName + " exists");
                    }
                    initOK = true;
                } else {
                    SMBFile testFile;
                    if (this.isVerbose()) {
                        Debug.println("Creating file " + testFileName + " via " + sess.getServer());
                    }
                    if ((testFile = sess.CreateFile(testFileName)) != null) {
                        testFile.Close();
                    }
                    if (sess.FileExists(testFileName)) {
                        initOK = true;
                    }
                }
            }
            catch (Exception ex) {
                Debug.println(ex);
            }
        } else {
            initOK = true;
        }
        return initOK;
    }

    @Override
    public TestResult runTest(int threadId, int iteration, DiskSession sess, StringWriter log) {
        TestResult result = null;
        try {
            if (threadId > 1) {
                this.testSleep(500L);
            }
            String testFileName = this.getPerTestFileName(threadId, iteration);
            OplockBreakHandler oplockHandler = new OplockBreakHandler(log);
            CIFSDiskSession cifsSess = (CIFSDiskSession)sess;
            CIFSFile oplockFile = null;
            if (threadId == 1) {
                oplockFile = cifsSess.NTCreateWithOplock(testFileName, 6, oplockHandler, 3, 128, 7, 5, 0L, 0);
                this.testLog(log, "Oplock granted, type=" + OpLock.getTypeAsString(oplockFile.getOplockType()) + " on server " + sess.getServer());
                result = new BooleanTestResult(true);
            } else {
                try {
                    oplockFile = cifsSess.NTCreate(testFileName, 3, 128, 7, 5, 0L, 0);
                    this.testLog(log, "Opened oplocked file on server " + sess.getServer());
                }
                catch (SocketTimeoutException ex) {
                    this.testLog(log, "Failed to open file, request not continued by server");
                }
            }
            if (threadId == 1 && oplockFile != null && oplockFile.getOplockType() != 0) {
                this.testLog(log, "Waiting for oplock break ...");
                int idx = 0;
                while (idx++ < 8 && !oplockHandler.hasOplockBreak()) {
                    this.testSleep(250L);
                    sess.pingServer();
                    if (!oplockHandler.hasOplockBreak()) continue;
                    this.testLog(log, "Oplock break received");
                    result = new BooleanTestResult(true);
                }
                if (result == null) {
                    result = new BooleanTestResult(false, "Oplock break not received");
                } else {
                    this.testSleep(500L);
                }
            } else if (threadId > 1) {
                if (oplockFile != null && oplockFile.getOplockType() == 3) {
                    this.testLog(log, "Second open got Level II shared oplock");
                    result = new BooleanTestResult(true);
                } else {
                    result = new BooleanTestResult(false, "Failed to get level II oplock on second open");
                }
            } else {
                result = new BooleanTestResult(false, "Second open did not get a level II shared oplock");
            }
            if (oplockFile != null) {
                oplockFile.Close();
            }
            this.testLog(log, "Test completed");
        }
        catch (Exception ex) {
            Debug.println(ex);
            result = new ExceptionTestResult(ex);
        }
        return result;
    }

    @Override
    public void cleanupTest(int threadId, int iter, DiskSession sess, StringWriter log) throws Exception {
        if (threadId == 1) {
            sess.DeleteFile(this.getPerTestFileName(threadId, iter));
        }
    }

    public class OplockBreakHandler
    extends OplockAdapter {
        private StringWriter m_log;
        private boolean m_oplockBreak;

        public OplockBreakHandler(StringWriter log) {
            this.m_log = log;
        }

        @Override
        public int oplockBreak(CIFSFile cifsFile) {
            OplockBreakLevelIITest.this.testLog(this.m_log, "Oplock break on file " + cifsFile.getFileName() + ", break to Level II shared oplock");
            this.m_oplockBreak = true;
            try {
                cifsFile.Flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 3;
        }

        public boolean hasOplockBreak() {
            return this.m_oplockBreak;
        }
    }
}

