/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client.info;

import java.io.Serializable;
import java.util.Date;

public final class PrintJob
implements Serializable {
    public static final int Queued = 0;
    public static final int Paused = 1;
    public static final int Spooling = 2;
    public static final int Printing = 3;
    public static final int StatusMask = 3;
    public static final int Complete = 4;
    public static final int Intervention = 8;
    public static final int Error = 16;
    public static final int DestOffline = 32;
    public static final int DestPaused = 64;
    public static final int Notify = 128;
    public static final int DestNoPaper = 256;
    public static final int DestFormChg = 512;
    public static final int DestCartChg = 1024;
    public static final int DestPenChg = 2048;
    public static final int PrintDel = 32768;
    private int m_jobid;
    private int m_priority;
    private String m_user;
    private int m_pos;
    private int m_status;
    private Date m_queueTime;
    private int m_spoolsize;
    private String m_comment;
    private String m_document;

    public PrintJob(int id) {
        this.m_jobid = id;
    }

    public final String getComment() {
        return this.m_comment;
    }

    public final int getJobNumber() {
        return this.m_jobid;
    }

    public final int getPrintPosition() {
        return this.m_pos;
    }

    public final int getPrintStatus() {
        return this.m_status;
    }

    public final int getPriority() {
        return this.m_priority;
    }

    public final Date getQueuedDateTime() {
        return this.m_queueTime;
    }

    public final String getSpoolDocument() {
        return this.m_document;
    }

    public final int getSpoolFileSize() {
        return this.m_spoolsize;
    }

    public final String getStatusString() {
        String sts = null;
        switch (this.m_status & 3) {
            case 0: {
                sts = "Queued";
                break;
            }
            case 1: {
                sts = "Paused";
                break;
            }
            case 2: {
                sts = "Spooling";
                break;
            }
            case 3: {
                StringBuffer str = new StringBuffer("Printing");
                if ((this.m_status & 4) != 0) {
                    str.append(" - Complete");
                }
                if ((this.m_status & 0x400) != 0) {
                    str.append(" - DestCartChange");
                }
                if ((this.m_status & 0x200) != 0) {
                    str.append(" - DestFormChange");
                }
                if ((this.m_status & 0x100) != 0) {
                    str.append(" - NoPaper");
                }
                if ((this.m_status & 0x20) != 0) {
                    str.append(" - Offline");
                }
                if ((this.m_status & 0x40) != 0) {
                    str.append(" - Paused");
                }
                if ((this.m_status & 0x800) != 0) {
                    str.append(" - DestPenChange");
                }
                if ((this.m_status & 0x10) != 0) {
                    str.append(" - Error");
                }
                if ((this.m_status & 8) != 0) {
                    str.append(" - Intervention");
                }
                if ((this.m_status & 0x80) != 0) {
                    str.append(" - Notify");
                }
                if ((this.m_status & 0x8000) != 0) {
                    str.append(" - PrintDel");
                }
                sts = str.toString();
            }
        }
        return sts;
    }

    public final String getUserName() {
        return this.m_user;
    }

    public final boolean isPaused() {
        return (this.m_status & 3) == 1;
    }

    public final boolean isPrinting() {
        return (this.m_status & 3) == 3;
    }

    public final boolean isQueued() {
        return (this.m_status & 3) == 0;
    }

    public final boolean isSpooling() {
        return (this.m_status & 3) == 2;
    }

    public final void setComment(String comm) {
        this.m_comment = comm;
    }

    public final void setDocument(String doc) {
        this.m_document = doc;
    }

    public final void setJobNumber(int id) {
        this.m_jobid = id;
    }

    public final void setPrintPosition(int pos) {
        this.m_pos = pos;
    }

    public final void setPriority(int pri) {
        this.m_priority = pri;
    }

    public final void setQueuedDateTime(Date dattim) {
        this.m_queueTime = dattim;
    }

    public final void setSpoolFileSize(int siz) {
        this.m_spoolsize = siz;
    }

    public final void setStatus(int sts) {
        this.m_status = sts;
    }

    public final void setUserName(String usr) {
        this.m_user = usr;
    }

    public final String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getJobNumber());
        str.append(" - ");
        str.append(this.getUserName());
        str.append(" - ");
        str.append(this.getStatusString());
        str.append(" - ");
        str.append(this.getQueuedDateTime());
        str.append(" - ");
        str.append(this.getSpoolDocument());
        str.append(" ");
        str.append(this.getSpoolFileSize());
        str.append("]");
        return str.toString();
    }
}

