/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.captcha;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.acegisecurity.captcha.CaptchaSecurityContext;
import org.acegisecurity.captcha.CaptchaServiceProxy;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class CaptchaValidationProcessingFilter
implements InitializingBean,
Filter {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$captcha$CaptchaValidationProcessingFilter == null ? (class$org$acegisecurity$captcha$CaptchaValidationProcessingFilter = CaptchaValidationProcessingFilter.class$("org.acegisecurity.captcha.CaptchaValidationProcessingFilter")) : class$org$acegisecurity$captcha$CaptchaValidationProcessingFilter));
    private CaptchaServiceProxy captchaService;
    private String captchaValidationParameter = "_captcha_parameter";
    static /* synthetic */ Class class$org$acegisecurity$captcha$CaptchaValidationProcessingFilter;

    public void afterPropertiesSet() throws Exception {
        if (this.captchaService == null) {
            throw new IllegalArgumentException("CaptchaServiceProxy must be defined ");
        }
        if (this.captchaValidationParameter == null || "".equals(this.captchaValidationParameter)) {
            throw new IllegalArgumentException("captchaValidationParameter must not be empty or null");
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String captchaResponse = request.getParameter(this.captchaValidationParameter);
        if (request != null && request instanceof HttpServletRequest && captchaResponse != null) {
            logger.debug((Object)"captcha validation parameter found");
            boolean valid = false;
            logger.debug((Object)"try to validate");
            HttpSession session = ((HttpServletRequest)request).getSession();
            if (session != null) {
                String id = session.getId();
                valid = this.captchaService.validateReponseForId(id, captchaResponse);
                logger.debug((Object)("captchaServiceProxy says : request is valid = " + valid));
                if (valid) {
                    logger.debug((Object)"update the context");
                    ((CaptchaSecurityContext)SecurityContextHolder.getContext()).setHuman();
                } else {
                    logger.debug((Object)"captcha test failed");
                }
            } else {
                logger.debug((Object)"no session found, user don't even ask a captcha challenge");
            }
        } else {
            logger.debug((Object)"captcha validation parameter not found, do nothing");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"chain ...");
        }
        chain.doFilter(request, response);
    }

    public CaptchaServiceProxy getCaptchaService() {
        return this.captchaService;
    }

    public String getCaptchaValidationParameter() {
        return this.captchaValidationParameter;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void setCaptchaService(CaptchaServiceProxy captchaService) {
        this.captchaService = captchaService;
    }

    public void setCaptchaValidationParameter(String captchaValidationParameter) {
        this.captchaValidationParameter = captchaValidationParameter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

