/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimitiveType;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.Dimensionable;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.TypedNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.AbstractNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Scope;
import net.sourceforge.pmd.lang.symboltable.ScopedNode;

public class VariableNameDeclaration
extends AbstractNameDeclaration
implements TypedNameDeclaration {
    public VariableNameDeclaration(ASTVariableDeclaratorId node) {
        super((ScopedNode)node);
    }

    public Scope getScope() {
        return this.node.getScope().getEnclosingScope(ClassScope.class);
    }

    public boolean isArray() {
        ASTVariableDeclaratorId astVariableDeclaratorId = (ASTVariableDeclaratorId)this.node;
        ASTType typeNode = astVariableDeclaratorId.getTypeNode();
        if (typeNode != null) {
            return ((Dimensionable)typeNode.jjtGetParent()).isArray();
        }
        return false;
    }

    public boolean isVarargs() {
        ASTVariableDeclaratorId astVariableDeclaratorId = (ASTVariableDeclaratorId)this.node;
        ASTFormalParameter parameter = (ASTFormalParameter)astVariableDeclaratorId.getFirstParentOfType(ASTFormalParameter.class);
        return parameter != null && parameter.isVarargs();
    }

    public boolean isExceptionBlockParameter() {
        return ((ASTVariableDeclaratorId)this.node).isExceptionBlockParameter();
    }

    public boolean isLambdaTypelessParameter() {
        return this.getAccessNodeParent() instanceof ASTLambdaExpression;
    }

    public boolean isPrimitiveType() {
        return !this.isLambdaTypelessParameter() && ((ASTType)this.getAccessNodeParent().getFirstChildOfType(ASTType.class)).jjtGetChild(0) instanceof ASTPrimitiveType;
    }

    @Override
    public String getTypeImage() {
        TypeNode typeNode = this.getTypeNode();
        if (typeNode != null) {
            return typeNode.getImage();
        }
        return null;
    }

    public boolean isReferenceType() {
        return !this.isLambdaTypelessParameter() && ((ASTType)this.getAccessNodeParent().getFirstChildOfType(ASTType.class)).jjtGetChild(0) instanceof ASTReferenceType;
    }

    public AccessNode getAccessNodeParent() {
        if (this.node.jjtGetParent() instanceof ASTFormalParameter || this.node.jjtGetParent() instanceof ASTLambdaExpression) {
            return (AccessNode)this.node.jjtGetParent();
        }
        return (AccessNode)this.node.jjtGetParent().jjtGetParent();
    }

    public ASTVariableDeclaratorId getDeclaratorId() {
        return (ASTVariableDeclaratorId)this.node;
    }

    private TypeNode getTypeNode() {
        if (this.isPrimitiveType()) {
            return (TypeNode)((ASTType)this.getAccessNodeParent().getFirstChildOfType(ASTType.class)).jjtGetChild(0);
        }
        if (!this.isLambdaTypelessParameter()) {
            return (TypeNode)((ASTType)this.getAccessNodeParent().getFirstChildOfType(ASTType.class)).jjtGetChild(0).jjtGetChild(0);
        }
        return null;
    }

    @Override
    public Class<?> getType() {
        TypeNode typeNode = this.getTypeNode();
        if (typeNode != null) {
            return typeNode.getType();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof VariableNameDeclaration)) {
            return false;
        }
        VariableNameDeclaration n = (VariableNameDeclaration)o;
        return n.node.getImage().equals(this.node.getImage());
    }

    public int hashCode() {
        return this.node.getImage().hashCode();
    }

    public String toString() {
        return "Variable: image = '" + this.node.getImage() + "', line = " + this.node.getBeginLine();
    }
}

