/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import org.coode.owlapi.rdfxml.parser.AbstractClassExpressionTranslator;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class ObjectMaxCardinalityTranslator
extends AbstractClassExpressionTranslator {
    public ObjectMaxCardinalityTranslator(OWLRDFConsumer consumer) {
        super(consumer);
    }

    @Override
    public boolean matchesStrict(IRI mainNode) {
        return this.isRestrictionStrict(mainNode) && this.isNonNegativeIntegerStrict(mainNode, OWLRDFVocabulary.OWL_MAX_CARDINALITY) && this.isObjectPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY);
    }

    @Override
    public boolean matchesLax(IRI mainNode) {
        return this.isNonNegativeIntegerLax(mainNode, OWLRDFVocabulary.OWL_MAX_CARDINALITY) && this.isObjectPropertyLax(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY);
    }

    public OWLObjectMaxCardinality translate(IRI mainNode) {
        this.getConsumer().consumeTriple(mainNode, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        int cardi = this.translateInteger(mainNode, OWLRDFVocabulary.OWL_MAX_CARDINALITY);
        IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
        OWLObjectPropertyExpression property = this.getConsumer().translateObjectPropertyExpression(propertyIRI);
        IRI fillerIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_CLASS, true);
        if (fillerIRI != null && !this.getConsumer().getConfiguration().isStrict()) {
            OWLClassExpression filler = this.getConsumer().translateClassExpression(fillerIRI);
            return this.getDataFactory().getOWLObjectMaxCardinality(cardi, property, filler);
        }
        return this.getDataFactory().getOWLObjectMaxCardinality(cardi, property);
    }
}

