/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import org.coode.owlapi.rdfxml.parser.AbstractClassExpressionTranslator;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class DataHasValueTranslator
extends AbstractClassExpressionTranslator {
    public DataHasValueTranslator(OWLRDFConsumer consumer) {
        super(consumer);
    }

    @Override
    public boolean matchesStrict(IRI mainNode) {
        return this.isRestrictionStrict(mainNode) && this.isDataPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isLiteralPresent(mainNode, OWLRDFVocabulary.OWL_HAS_VALUE);
    }

    @Override
    public boolean matchesLax(IRI mainNode) {
        return this.isLiteralPresent(mainNode, OWLRDFVocabulary.OWL_HAS_VALUE);
    }

    public OWLDataHasValue translate(IRI mainNode) {
        this.getConsumer().consumeTriple(mainNode, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        OWLLiteral lit = this.getConsumer().getLiteralObject(mainNode, OWLRDFVocabulary.OWL_HAS_VALUE, true);
        IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
        OWLDataPropertyExpression property = this.getConsumer().translateDataPropertyExpression(propertyIRI);
        return this.getDataFactory().getOWLDataHasValue(property, lit);
    }
}

