/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdf.model;

import org.coode.owlapi.rdf.model.RDFNode;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLObject;

public class RDFLiteralNode
extends RDFNode
implements Comparable<RDFNode> {
    private String literal;
    private String lang;
    private IRI datatype;
    private int hashCode = 0;

    @Override
    public IRI getIRI() {
        return null;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    public RDFLiteralNode(String literal, IRI datatype) {
        this.literal = literal;
        this.datatype = datatype;
    }

    public RDFLiteralNode(String literal, String lang) {
        this.literal = literal;
        this.lang = lang;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getLang() {
        return this.lang;
    }

    public IRI getDatatype() {
        return this.datatype;
    }

    public boolean isTyped() {
        return this.datatype != null;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        sb.append(this.literal);
        sb.append("\"");
        if (this.datatype != null) {
            sb.append("^^<");
            sb.append((CharSequence)this.datatype);
            sb.append(">");
        } else if (this.lang != null) {
            sb.append("@");
            sb.append(this.lang);
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RDFLiteralNode)) {
            return false;
        }
        RDFLiteralNode other = (RDFLiteralNode)obj;
        if (!other.literal.equals(this.literal)) {
            return false;
        }
        if (this.datatype != null ? !this.datatype.equals((Object)other.datatype) : other.getDatatype() != null) {
            return false;
        }
        if (this.lang != null) {
            return this.lang.equals(other.lang);
        }
        return other.lang == null;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 37;
            this.hashCode = this.hashCode * 37 + this.literal.hashCode();
            if (this.lang != null) {
                this.hashCode = this.hashCode * 37 + this.lang.hashCode();
            }
            if (this.datatype != null) {
                this.hashCode = this.hashCode * 37 + this.datatype.hashCode();
            }
        }
        return this.hashCode;
    }

    @Override
    public int compareTo(RDFNode b) {
        if (!b.isLiteral()) {
            return -1;
        }
        if (this.equals(b)) {
            return 0;
        }
        int diff = 0;
        RDFLiteralNode lit2 = (RDFLiteralNode)b;
        if (this.isTyped()) {
            if (lit2.isTyped()) {
                diff = this.getLiteral().compareTo(lit2.getLiteral());
                if (diff == 0) {
                    diff = this.getDatatype().compareTo((OWLObject)lit2.getDatatype());
                }
            } else {
                diff = -1;
            }
        } else if (lit2.isTyped()) {
            diff = 1;
        } else {
            if (this.getLang() != null) {
                if (lit2.getLang() != null) {
                    diff = this.getLang().compareTo(lit2.getLang());
                }
            } else {
                diff = -1;
            }
            if (diff == 0) {
                diff = this.getLiteral().compareTo(lit2.getLiteral());
            }
        }
        return diff;
    }
}

