/*
 * Decompiled with CFR 0.152.
 */
package de.uulm.ecs.ai.owlapi.krssparser;

import de.uulm.ecs.ai.owlapi.krssparser.KRSS2OWLParserException;
import de.uulm.ecs.ai.owlapi.krssparser.KRSS2OntologyFormat;
import de.uulm.ecs.ai.owlapi.krssparser.KRSS2Parser;
import de.uulm.ecs.ai.owlapi.krssparser.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.UnloadableImportException;

public class KRSS2OWLParser
extends AbstractOWLParser {
    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology) throws OWLParserException, IOException, UnloadableImportException {
        return this.parse(documentSource, ontology, new OWLOntologyLoaderConfiguration());
    }

    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws OWLParserException, IOException, OWLOntologyChangeException, UnloadableImportException {
        Reader reader = null;
        InputStream is = null;
        try {
            KRSS2Parser parser;
            KRSS2OntologyFormat format = new KRSS2OntologyFormat();
            if (documentSource.isReaderAvailable()) {
                reader = documentSource.getReader();
                parser = new KRSS2Parser(reader);
            } else if (documentSource.isInputStreamAvailable()) {
                is = documentSource.getInputStream();
                parser = new KRSS2Parser(is);
            } else {
                is = this.getInputStream(documentSource.getDocumentIRI(), configuration);
                parser = new KRSS2Parser(is);
            }
            parser.setOntology(ontology, ontology.getOWLOntologyManager().getOWLDataFactory());
            parser.parse();
            KRSS2OntologyFormat kRSS2OntologyFormat = format;
            return kRSS2OntologyFormat;
        }
        catch (ParseException e) {
            throw new KRSS2OWLParserException(e);
        }
        finally {
            if (is != null) {
                is.close();
            } else if (reader != null) {
                reader.close();
            }
        }
    }
}

