/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.tcp;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.NotNull;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.tcp.FastJ8SocketChannel;
import net.openhft.chronicle.core.tcp.UnsafeFastJ8SocketChannel;
import net.openhft.chronicle.core.tcp.VanillaSocketChannel;

public interface ISocketChannel
extends Closeable {
    public static final boolean FAST_JAVA8_IO;

    public static boolean isFastJava8IO() {
        boolean fastJava8IO;
        boolean bl = fastJava8IO = Boolean.getBoolean("fastJava8IO") && !Jvm.isJava9Plus() && OS.isLinux();
        if (fastJava8IO) {
            System.out.println("FastJava8IO: " + fastJava8IO);
        }
        return fastJava8IO;
    }

    @NotNull
    public static ISocketChannel wrap(SocketChannel sc) {
        if (!1.$assertionsDisabled && sc == null) {
            throw new AssertionError();
        }
        return FAST_JAVA8_IO ? new FastJ8SocketChannel(sc) : new VanillaSocketChannel(sc);
    }

    @NotNull
    public static ISocketChannel wrapUnsafe(SocketChannel sc) {
        if (!1.$assertionsDisabled && sc == null) {
            throw new AssertionError();
        }
        return FAST_JAVA8_IO ? new UnsafeFastJ8SocketChannel(sc) : new VanillaSocketChannel(sc);
    }

    @NotNull
    public SocketChannel socketChannel();

    public int read(ByteBuffer var1) throws IOException;

    public int write(ByteBuffer var1) throws IOException;

    public long write(ByteBuffer[] var1) throws IOException;

    @NotNull
    public Socket socket();

    public void configureBlocking(boolean var1) throws IOException;

    @NotNull
    public InetSocketAddress getRemoteAddress() throws IORuntimeException;

    @NotNull
    public InetSocketAddress getLocalAddress() throws IORuntimeException;

    public boolean isOpen();

    public boolean isBlocking();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        FAST_JAVA8_IO = ISocketChannel.isFastJava8IO();
    }
}

