/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.db;

import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.hasor.dataql.UdfSourceAssembly;
import net.hasor.dataql.fx.db.SqlPageQuery;
import net.hasor.dataql.fx.db.dialect.SqlPageDialect;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.utils.convert.ConverterUtils;

public class SqlPageObject
implements UdfSourceAssembly {
    private int totalCount = 0;
    private int pageSize = -1;
    private int currentPage = 0;
    private boolean totalCountInited = false;
    private SqlPageQuery sqlPageQuery = null;

    SqlPageObject(SqlPageQuery sqlPageQuery) {
        this.sqlPageQuery = sqlPageQuery;
        this.totalCountInited = false;
    }

    private int pageSize() {
        return this.pageSize;
    }

    private int pageSize(int pageSize) {
        if (pageSize < 1) {
            pageSize = 1;
        }
        this.pageSize = pageSize;
        return this.pageSize();
    }

    private int totalCount() throws SQLException {
        if (!this.totalCountInited) {
            SqlPageDialect.BoundSql countBoundSql = this.sqlPageQuery.getCountBoundSql();
            this.totalCount = (Integer)this.sqlPageQuery.doQuery(con -> {
                String countFxSql = countBoundSql.getSqlString();
                Object[] paramArrays = countBoundSql.getParamMap();
                return new JdbcTemplate(con).queryForInt(countFxSql, paramArrays);
            });
            this.totalCountInited = true;
        }
        return this.totalCount;
    }

    private int totalPage() throws SQLException {
        int pgSize = this.pageSize();
        int result = 1;
        if (pgSize > 0) {
            int totalCount = this.totalCount();
            result = this.totalCount() / pgSize;
            if (totalCount == 0 || totalCount % pgSize != 0) {
                ++result;
            }
        }
        return result;
    }

    private int currentPage() {
        return this.currentPage;
    }

    private int currentPage(int currentPage) {
        if (currentPage < 0) {
            currentPage = 0;
        }
        this.currentPage = currentPage;
        return this.currentPage();
    }

    private int firstRecordPosition() {
        int pgSize = this.pageSize();
        if (pgSize < 0) {
            return 0;
        }
        return pgSize * this.currentPage();
    }

    public int firstPage() {
        return this.currentPage(0);
    }

    public int previousPage() {
        int back = this.currentPage() - 1;
        int previousPage = Math.max(back, 0);
        return this.currentPage(previousPage);
    }

    public int nextPage() throws SQLException {
        int back = this.currentPage() + 1;
        int nextPage = Math.min(back, this.totalPage());
        return this.currentPage(nextPage);
    }

    public int lastPage() throws SQLException {
        return this.currentPage(this.totalPage());
    }

    public Map<String, Object> pageInfo() throws SQLException {
        return new LinkedHashMap<String, Object>(){
            {
                this.put("enable", SqlPageObject.this.pageSize() > 0);
                this.put("pageSize", SqlPageObject.this.pageSize());
                this.put("totalCount", SqlPageObject.this.totalCount());
                this.put("totalPage", SqlPageObject.this.totalPage());
                this.put("currentPage", SqlPageObject.this.currentPage());
                this.put("recordPosition", SqlPageObject.this.firstRecordPosition());
            }
        };
    }

    public boolean setPageInfo(Map<String, Object> pageInfo) {
        if (pageInfo == null || pageInfo.isEmpty()) {
            return false;
        }
        Object currentPage = pageInfo.get("currentPage");
        Object pageSize = pageInfo.get("pageSize");
        if (currentPage == null && pageSize == null) {
            return false;
        }
        this.currentPage((Integer)ConverterUtils.convert(Integer.TYPE, (Object)currentPage));
        this.pageSize((Integer)ConverterUtils.convert(Integer.TYPE, (Object)pageSize));
        return true;
    }

    public List<Map<String, Object>> data() throws SQLException {
        SqlPageDialect.BoundSql countBoundSql = this.sqlPageQuery.getPageBoundSql(this.firstRecordPosition(), this.pageSize());
        return (List)this.sqlPageQuery.doQuery(con -> {
            String countFxSql = countBoundSql.getSqlString();
            Object[] paramArrays = countBoundSql.getParamMap();
            return new JdbcTemplate(con).queryForList(countFxSql, paramArrays);
        });
    }
}

