/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.db;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.hasor.core.AppContext;
import net.hasor.dataql.FragmentProcess;
import net.hasor.dataql.Hints;
import net.hasor.dataql.fx.FxHintNames;
import net.hasor.dataql.fx.db.SqlPageDialectRegister;
import net.hasor.dataql.fx.db.SqlPageObject;
import net.hasor.dataql.fx.db.SqlPageQuery;
import net.hasor.dataql.fx.db.dialect.SqlPageDialect;
import net.hasor.dataql.fx.db.parser.FxSql;
import net.hasor.db.jdbc.BatchPreparedStatementSetter;
import net.hasor.db.jdbc.ConnectionCallback;
import net.hasor.db.jdbc.PreparedStatementSetter;
import net.hasor.db.jdbc.core.ArgPreparedStatementSetter;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.utils.StringUtils;
import net.hasor.utils.io.IOUtils;

public class SqlFragment
implements FragmentProcess {
    @Inject
    protected AppContext appContext;
    @Inject
    protected JdbcTemplate jdbcTemplate;

    public List<Object> batchRunFragment(Hints hint, List<Map<String, Object>> params, String fragmentString) throws Throwable {
        if (params == null || params.size() == 0) {
            return Collections.singletonList(this.runFragment(hint, Collections.emptyMap(), fragmentString));
        }
        if (params.size() == 1) {
            return Collections.singletonList(this.runFragment(hint, params.get(0), fragmentString));
        }
        SqlMode sqlMode = SqlFragment.evalSqlMode(fragmentString);
        FxSql fxSql = FxSql.analysisSQL(fragmentString);
        if (!(SqlMode.Insert != sqlMode && SqlMode.Update != sqlMode && SqlMode.Delete != sqlMode || fxSql.isHavePlaceholder())) {
            fragmentString = fxSql.buildSqlString(params.get(0));
            final PreparedStatementSetter[] parameterArrays = new PreparedStatementSetter[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                parameterArrays[i] = new ArgPreparedStatementSetter(fxSql.buildParameterSource(params.get(i)).toArray());
            }
            int[] executeBatch = this.jdbcTemplate.executeBatch(fragmentString, new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    parameterArrays[i].setValues(ps);
                }

                public int getBatchSize() {
                    return parameterArrays.length;
                }
            });
            return Arrays.stream(executeBatch).boxed().collect(Collectors.toList());
        }
        ArrayList<Object> resultList = new ArrayList<Object>(params.size());
        for (Map<String, Object> paramItem : params) {
            if (this.usePage(hint, sqlMode, fxSql)) {
                resultList.add(this.usePageFragment(fxSql, sqlMode, hint, paramItem));
                continue;
            }
            resultList.add(this.noPageFragment(fxSql, sqlMode, hint, paramItem));
        }
        return resultList;
    }

    public Object runFragment(Hints hint, Map<String, Object> paramMap, String fragmentString) throws Throwable {
        FxSql fxSql;
        SqlMode sqlMode = SqlFragment.evalSqlMode(fragmentString);
        if (this.usePage(hint, sqlMode, fxSql = FxSql.analysisSQL(fragmentString))) {
            return this.usePageFragment(fxSql, sqlMode, hint, paramMap);
        }
        return this.noPageFragment(fxSql, sqlMode, hint, paramMap);
    }

    protected Object usePageFragment(final FxSql fxSql, SqlMode sqlMode, Hints hint, final Map<String, Object> paramMap) {
        String sqlDialect = this.appContext.getEnvironment().getVariable("HASOR_DATAQL_FX_PAGE_DIALECT");
        sqlDialect = hint.getOrDefault(FxHintNames.FRAGMENT_SQL_PAGE_DIALECT.name(), (Object)sqlDialect).toString();
        if (StringUtils.isBlank((String)sqlDialect)) {
            throw new IllegalArgumentException("Query dialect missing.");
        }
        final SqlPageDialect pageDialect = SqlPageDialectRegister.findOrCreate(sqlDialect, this.appContext);
        return new SqlPageObject(new SqlPageQuery(){

            @Override
            public SqlPageDialect.BoundSql getCountBoundSql() {
                return pageDialect.getCountSql(fxSql, paramMap);
            }

            @Override
            public SqlPageDialect.BoundSql getPageBoundSql(int start, int limit) {
                if (limit < 0) {
                    String sqlString = fxSql.buildSqlString(paramMap);
                    Object[] paramArrays = fxSql.buildParameterSource(paramMap).toArray();
                    return new SqlPageDialect.BoundSql(sqlString, paramArrays);
                }
                return pageDialect.getPageSql(fxSql, paramMap, start, limit);
            }

            @Override
            public <T> T doQuery(ConnectionCallback<T> connectionCallback) throws SQLException {
                return (T)SqlFragment.this.jdbcTemplate.execute(connectionCallback);
            }
        });
    }

    protected Object noPageFragment(FxSql fxSql, SqlMode sqlMode, Hints hint, Map<String, Object> paramMap) throws Throwable {
        String fragmentString = fxSql.buildSqlString(paramMap);
        Object[] source = fxSql.buildParameterSource(paramMap).toArray();
        if (SqlMode.Query == sqlMode) {
            List mapList = this.jdbcTemplate.queryForList(fragmentString, source);
            String openPackage = hint.getOrDefault(FxHintNames.FRAGMENT_SQL_OPEN_PACKAGE.name(), (Object)FxHintNames.FRAGMENT_SQL_OPEN_PACKAGE.getDefaultVal()).toString();
            boolean packageOff = "off".equalsIgnoreCase(openPackage);
            if (packageOff || mapList != null && mapList.size() > 1) {
                return mapList;
            }
            if (mapList == null || mapList.isEmpty()) {
                if ("column".equalsIgnoreCase(openPackage)) {
                    return null;
                }
                return Collections.emptyMap();
            }
            Map rowObject = (Map)mapList.get(0);
            if ("column".equalsIgnoreCase(openPackage)) {
                if (rowObject == null) {
                    return null;
                }
                if (rowObject.size() == 1) {
                    Set entrySet = rowObject.entrySet();
                    Map.Entry objectEntry = entrySet.iterator().next();
                    return objectEntry.getValue();
                }
            }
            return rowObject;
        }
        if (SqlMode.Insert == sqlMode || SqlMode.Update == sqlMode || SqlMode.Delete == sqlMode) {
            return this.jdbcTemplate.executeUpdate(fragmentString, source);
        }
        if (SqlMode.Procedure == sqlMode) {
            throw new SQLException("Procedure not support.");
        }
        if (SqlMode.Create == sqlMode || SqlMode.Drop == sqlMode || SqlMode.Alter == sqlMode) {
            return this.jdbcTemplate.executeUpdate(fragmentString, source);
        }
        throw new SQLException("Unknown SqlMode.");
    }

    private boolean usePage(Hints hint, SqlMode sqlMode, FxSql fxSql) {
        if (SqlMode.Query == sqlMode) {
            FxHintNames queryByPage = FxHintNames.FRAGMENT_SQL_QUERY_BY_PAGE;
            Object hintOrDefault = hint.getOrDefault(queryByPage.name(), (Object)queryByPage.getDefaultVal());
            return "true".equalsIgnoreCase(hintOrDefault.toString());
        }
        return false;
    }

    private static SqlMode evalSqlMode(String fragmentString) throws SQLException, IOException {
        List readLines = IOUtils.readLines((Reader)new StringReader(fragmentString));
        SqlMode sqlMode = null;
        boolean multipleLines = false;
        for (String lineStr : readLines) {
            String tempLine = lineStr.trim();
            if (!multipleLines) {
                if (StringUtils.isBlank((String)tempLine) || tempLine.startsWith("--") && tempLine.startsWith("#")) continue;
                if (tempLine.startsWith("/*")) {
                    multipleLines = true;
                }
            }
            if (multipleLines) {
                if (!tempLine.contains("*/")) continue;
                tempLine = tempLine.substring(tempLine.indexOf("*/")).trim();
                multipleLines = false;
            }
            sqlMode = (tempLine = tempLine.toLowerCase()).startsWith("insert") || tempLine.startsWith("replace") ? SqlMode.Insert : (tempLine.startsWith("update") ? SqlMode.Update : (tempLine.startsWith("delete") ? SqlMode.Delete : (tempLine.startsWith("exec") ? SqlMode.Procedure : (tempLine.startsWith("select") ? SqlMode.Query : (tempLine.startsWith("create") ? SqlMode.Create : (tempLine.startsWith("drop") ? SqlMode.Drop : (tempLine.startsWith("alter") ? SqlMode.Alter : SqlMode.Unknown)))))));
            break;
        }
        if (sqlMode == null) {
            throw new SQLException("Unknown query statement. -> " + fragmentString);
        }
        return sqlMode;
    }

    protected static enum SqlMode {
        Insert,
        Update,
        Delete,
        Procedure,
        Query,
        Create,
        Drop,
        Alter,
        Unknown;

    }
}

