/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.tasks.io;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.coobird.thumbnailator.ThumbnailParameter;
import net.coobird.thumbnailator.tasks.UnsupportedFormatException;
import net.coobird.thumbnailator.tasks.io.AbstractImageSource;
import net.coobird.thumbnailator.tasks.io.ImageSource;
import net.coobird.thumbnailator.tasks.io.InputStreamImageSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileImageSource
implements ImageSource<File> {
    private final File sourceFile;
    private ImageSource<?> imageSource = new UninitializedImageSource();
    private ThumbnailParameter param;

    public FileImageSource(File file) {
        if (file == null) {
            throw new NullPointerException("File cannot be null.");
        }
        this.sourceFile = file;
    }

    public FileImageSource(String string) {
        if (string == null) {
            throw new NullPointerException("File cannot be null.");
        }
        this.sourceFile = new File(string);
    }

    @Override
    public BufferedImage read() throws IOException {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.sourceFile);
            this.imageSource = new InputStreamImageSource(fileInputStream);
            this.imageSource.setThumbnailParameter(this.param);
            BufferedImage bufferedImage = this.imageSource.read();
            fileInputStream.close();
            return bufferedImage;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("Could not find file: " + this.sourceFile.getAbsolutePath());
        }
        catch (UnsupportedFormatException unsupportedFormatException) {
            String string = this.sourceFile.getAbsolutePath();
            throw new UnsupportedFormatException("<unknown>", "No suitable ImageReader found for " + string + ".");
        }
    }

    @Override
    public File getSource() {
        return this.sourceFile;
    }

    @Override
    public String getInputFormatName() {
        return this.imageSource.getInputFormatName();
    }

    @Override
    public void setThumbnailParameter(ThumbnailParameter thumbnailParameter) {
        this.param = thumbnailParameter;
        this.imageSource.setThumbnailParameter(thumbnailParameter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UninitializedImageSource
    extends AbstractImageSource<Void> {
        private UninitializedImageSource() {
        }

        @Override
        public BufferedImage read() throws IOException {
            throw new IllegalStateException("This should not happen.");
        }

        @Override
        public Void getSource() {
            throw new IllegalStateException("This should not happen.");
        }
    }
}

