/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.tasks.io;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import net.coobird.thumbnailator.ThumbnailParameter;
import net.coobird.thumbnailator.tasks.UnsupportedFormatException;
import net.coobird.thumbnailator.tasks.io.AbstractImageSink;
import net.coobird.thumbnailator.tasks.io.ImageSink;
import net.coobird.thumbnailator.tasks.io.OutputStreamImageSink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileImageSink
implements ImageSink<File> {
    private File destinationFile;
    private final boolean allowOverwrite;
    private String outputFormat;
    private ThumbnailParameter param;
    private ImageSink<?> imageSink = new UninitializedImageSink();

    public FileImageSink(File file) {
        this(file, true);
    }

    public FileImageSink(File file, boolean bl) {
        if (file == null) {
            throw new NullPointerException("File cannot be null.");
        }
        this.destinationFile = file;
        this.outputFormat = FileImageSink.getExtension(file);
        this.allowOverwrite = bl;
    }

    public FileImageSink(String string) {
        this(string, true);
    }

    public FileImageSink(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("File cannot be null.");
        }
        this.destinationFile = new File(string);
        this.outputFormat = FileImageSink.getExtension(this.destinationFile);
        this.allowOverwrite = bl;
    }

    private static boolean isMatchingFormat(String string, String string2) throws UnsupportedFormatException {
        String[] stringArray;
        ImageWriter imageWriter;
        if (string == null || string2 == null) {
            return false;
        }
        try {
            imageWriter = ImageIO.getImageWritersByFormatName(string).next();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new UnsupportedFormatException(string, "No suitable ImageWriter found for " + string + ".");
        }
        for (String string3 : stringArray = imageWriter.getOriginatingProvider().getFileSuffixes()) {
            if (!string2.equalsIgnoreCase(string3)) continue;
            return true;
        }
        return false;
    }

    private static String getExtension(File file) {
        String string = file.getName();
        if (string.indexOf(46) != -1 && string.lastIndexOf(46) != string.length() - 1) {
            int n = string.lastIndexOf(46);
            return string.substring(n + 1);
        }
        return null;
    }

    @Override
    public String preferredOutputFormatName() {
        Iterator<ImageReader> iterator;
        String string = FileImageSink.getExtension(this.destinationFile);
        if (string != null && (iterator = ImageIO.getImageReadersBySuffix(string)).hasNext()) {
            try {
                return iterator.next().getFormatName();
            }
            catch (IOException iOException) {
                return ThumbnailParameter.ORIGINAL_FORMAT;
            }
        }
        return this.outputFormat;
    }

    @Override
    public void write(BufferedImage bufferedImage) throws IOException {
        Object object;
        String string = FileImageSink.getExtension(this.destinationFile);
        String string2 = this.outputFormat;
        if (!(string2 == null || string != null && FileImageSink.isMatchingFormat(string2, string))) {
            this.destinationFile = new File(this.destinationFile.getAbsolutePath() + "." + string2);
        }
        if (!this.allowOverwrite && this.destinationFile.exists()) {
            throw new IllegalArgumentException("The destination file exists.");
        }
        if (string2 == null && string != null && (object = ImageIO.getImageReadersBySuffix(string)).hasNext()) {
            string2 = ((ImageReader)object.next()).getFormatName();
        }
        if (string2 == null) {
            throw new UnsupportedFormatException(string2, "Could not determine output format.");
        }
        object = new FileOutputStream(this.destinationFile);
        this.imageSink = new OutputStreamImageSink((OutputStream)object);
        this.imageSink.setThumbnailParameter(this.param);
        this.imageSink.setOutputFormatName(string2);
        this.imageSink.write(bufferedImage);
        ((FileOutputStream)object).close();
    }

    @Override
    public File getSink() {
        return this.destinationFile;
    }

    @Override
    public void setOutputFormatName(String string) {
        this.outputFormat = string;
        this.imageSink.setOutputFormatName(string);
    }

    @Override
    public void setThumbnailParameter(ThumbnailParameter thumbnailParameter) {
        this.param = thumbnailParameter;
        this.imageSink.setThumbnailParameter(thumbnailParameter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UninitializedImageSink
    extends AbstractImageSink<Void> {
        private UninitializedImageSink() {
        }

        @Override
        public Void getSink() {
            throw new IllegalStateException("This should not happen.");
        }
    }
}

