/*
 * Decompiled with CFR 0.152.
 */
package brave.rpc;

import brave.rpc.RpcRequest;
import brave.sampler.Matcher;

public final class RpcRequestMatchers {
    public static <Req extends RpcRequest> Matcher<Req> methodEquals(String method) {
        if (method == null) {
            throw new NullPointerException("method == null");
        }
        if (method.isEmpty()) {
            throw new NullPointerException("method is empty");
        }
        return new RpcMethodEquals(method);
    }

    public static <Req extends RpcRequest> Matcher<Req> serviceEquals(String service) {
        if (service == null) {
            throw new NullPointerException("service == null");
        }
        if (service.isEmpty()) {
            throw new NullPointerException("service is empty");
        }
        return new RpcServiceEquals(service);
    }

    static final class RpcServiceEquals<Req extends RpcRequest>
    implements Matcher<Req> {
        final String service;

        RpcServiceEquals(String service) {
            this.service = service;
        }

        public boolean matches(Req request) {
            return this.service.equals(((RpcRequest)((Object)request)).service());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RpcServiceEquals)) {
                return false;
            }
            RpcServiceEquals that = (RpcServiceEquals)o;
            return this.service.equals(that.service);
        }

        public int hashCode() {
            return this.service.hashCode();
        }

        public String toString() {
            return "RpcServiceEquals(" + this.service + ")";
        }
    }

    static final class RpcMethodEquals<Req extends RpcRequest>
    implements Matcher<Req> {
        final String method;

        RpcMethodEquals(String method) {
            this.method = method;
        }

        public boolean matches(Req request) {
            return this.method.equals(((RpcRequest)((Object)request)).method());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RpcMethodEquals)) {
                return false;
            }
            RpcMethodEquals that = (RpcMethodEquals)o;
            return this.method.equals(that.method);
        }

        public int hashCode() {
            return this.method.hashCode();
        }

        public String toString() {
            return "RpcMethodEquals(" + this.method + ")";
        }
    }
}

