/*
 * Decompiled with CFR 0.152.
 */
package brave.httpasyncclient;

import brave.Span;
import brave.Tracing;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.Future;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;

public final class TracingHttpAsyncClientBuilder
extends HttpAsyncClientBuilder {
    static final Propagation.Setter<HttpMessage, String> SETTER = new Propagation.Setter<HttpMessage, String>(){

        public void put(HttpMessage carrier, String key, String value) {
            carrier.setHeader(key, value);
        }

        public String toString() {
            return "HttpMessage::setHeader";
        }
    };
    final CurrentTraceContext currentTraceContext;
    final TraceContext.Injector<HttpMessage> injector;
    final HttpClientHandler<HttpRequest, HttpResponse> handler;

    public static HttpAsyncClientBuilder create(Tracing tracing) {
        return new TracingHttpAsyncClientBuilder(HttpTracing.create((Tracing)tracing));
    }

    public static HttpAsyncClientBuilder create(HttpTracing httpTracing) {
        return new TracingHttpAsyncClientBuilder(httpTracing);
    }

    TracingHttpAsyncClientBuilder(HttpTracing httpTracing) {
        if (httpTracing == null) {
            throw new NullPointerException("httpTracing == null");
        }
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing, (HttpClientAdapter)new HttpAdapter());
        this.injector = httpTracing.tracing().propagation().injector(SETTER);
    }

    public CloseableHttpAsyncClient build() {
        super.addInterceptorFirst((HttpRequestInterceptor)new HandleSend());
        super.addInterceptorLast((HttpRequestInterceptor)new RemoveScope());
        super.addInterceptorLast((HttpResponseInterceptor)new HandleReceive());
        return new TracingHttpAsyncClient(super.build());
    }

    static void parseTargetAddress(HttpRequestWrapper httpRequest, Span span) {
        if (span.isNoop()) {
            return;
        }
        HttpHost target = httpRequest.getTarget();
        if (target == null) {
            return;
        }
        InetAddress address = target.getAddress();
        if (address != null && span.remoteIpAndPort(address.getHostAddress(), target.getPort())) {
            return;
        }
        span.remoteIpAndPort(target.getHostName(), target.getPort());
    }

    final class TracingAsyncResponseConsumer<T>
    implements HttpAsyncResponseConsumer<T> {
        final HttpAsyncResponseConsumer<T> responseConsumer;
        final HttpContext context;

        TracingAsyncResponseConsumer(HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context) {
            this.responseConsumer = responseConsumer;
            this.context = context;
        }

        public void responseReceived(HttpResponse response) throws IOException, HttpException {
            this.responseConsumer.responseReceived(response);
        }

        public void consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
            this.responseConsumer.consumeContent(decoder, ioctrl);
        }

        public void responseCompleted(HttpContext context) {
            this.responseConsumer.responseCompleted(context);
        }

        public void failed(Exception ex) {
            Span currentSpan = (Span)this.context.getAttribute(Span.class.getName());
            if (currentSpan != null) {
                this.context.removeAttribute(Span.class.getName());
                TracingHttpAsyncClientBuilder.this.handler.handleReceive(null, (Throwable)ex, currentSpan);
            }
            this.responseConsumer.failed(ex);
        }

        public Exception getException() {
            return this.responseConsumer.getException();
        }

        public T getResult() {
            return (T)this.responseConsumer.getResult();
        }

        public boolean isDone() {
            return this.responseConsumer.isDone();
        }

        public void close() throws IOException {
            this.responseConsumer.close();
        }

        public boolean cancel() {
            return this.responseConsumer.cancel();
        }
    }

    final class TracingAsyncRequestProducer
    implements HttpAsyncRequestProducer {
        final HttpAsyncRequestProducer requestProducer;
        final HttpContext context;

        TracingAsyncRequestProducer(HttpAsyncRequestProducer requestProducer, HttpContext context) {
            this.requestProducer = requestProducer;
            this.context = context;
        }

        public void close() throws IOException {
            this.requestProducer.close();
        }

        public HttpHost getTarget() {
            return this.requestProducer.getTarget();
        }

        public HttpRequest generateRequest() throws IOException, HttpException {
            return this.requestProducer.generateRequest();
        }

        public void produceContent(ContentEncoder encoder, IOControl io) throws IOException {
            this.requestProducer.produceContent(encoder, io);
        }

        public void requestCompleted(HttpContext context) {
            this.requestProducer.requestCompleted(context);
        }

        public void failed(Exception ex) {
            Span currentSpan = (Span)this.context.getAttribute(Span.class.getName());
            if (currentSpan != null) {
                this.context.removeAttribute(Span.class.getName());
                TracingHttpAsyncClientBuilder.this.handler.handleReceive(null, (Throwable)ex, currentSpan);
            }
            this.requestProducer.failed(ex);
        }

        public boolean isRepeatable() {
            return this.requestProducer.isRepeatable();
        }

        public void resetRequest() throws IOException {
            this.requestProducer.resetRequest();
        }
    }

    final class TracingHttpAsyncClient
    extends CloseableHttpAsyncClient {
        private final CloseableHttpAsyncClient delegate;

        TracingHttpAsyncClient(CloseableHttpAsyncClient delegate) {
            this.delegate = delegate;
        }

        public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
            context.setAttribute(TraceContext.class.getName(), (Object)TracingHttpAsyncClientBuilder.this.currentTraceContext.get());
            return this.delegate.execute((HttpAsyncRequestProducer)new TracingAsyncRequestProducer(requestProducer, context), new TracingAsyncResponseConsumer<T>(responseConsumer, context), context, callback);
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public boolean isRunning() {
            return this.delegate.isRunning();
        }

        public void start() {
            this.delegate.start();
        }
    }

    static final class HttpAdapter
    extends HttpClientAdapter<HttpRequest, HttpResponse> {
        HttpAdapter() {
        }

        public String method(HttpRequest request) {
            return request.getRequestLine().getMethod();
        }

        public String path(HttpRequest request) {
            String result = request.getRequestLine().getUri();
            int queryIndex = result.indexOf(63);
            return queryIndex == -1 ? result : result.substring(0, queryIndex);
        }

        public String url(HttpRequest request) {
            HttpRequestWrapper wrapper;
            HttpHost target;
            if (request instanceof HttpRequestWrapper && (target = (wrapper = (HttpRequestWrapper)request).getTarget()) != null) {
                return target.toURI() + wrapper.getURI();
            }
            return request.getRequestLine().getUri();
        }

        public String requestHeader(HttpRequest request, String name) {
            Header result = request.getFirstHeader(name);
            return result != null ? result.getValue() : null;
        }

        public Integer statusCode(HttpResponse response) {
            return this.statusCodeAsInt(response);
        }

        public int statusCodeAsInt(HttpResponse response) {
            return response.getStatusLine().getStatusCode();
        }
    }

    final class HandleReceive
    implements HttpResponseInterceptor {
        HandleReceive() {
        }

        public void process(HttpResponse response, HttpContext context) {
            Span span = (Span)context.getAttribute(Span.class.getName());
            if (span == null) {
                return;
            }
            TracingHttpAsyncClientBuilder.this.handler.handleReceive((Object)response, null, span);
        }
    }

    static final class RemoveScope
    implements HttpRequestInterceptor {
        RemoveScope() {
        }

        public void process(HttpRequest request, HttpContext context) {
            CurrentTraceContext.Scope scope = (CurrentTraceContext.Scope)context.getAttribute(CurrentTraceContext.Scope.class.getName());
            if (scope == null) {
                return;
            }
            context.removeAttribute(CurrentTraceContext.Scope.class.getName());
            scope.close();
        }
    }

    final class HandleSend
    implements HttpRequestInterceptor {
        HandleSend() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void process(HttpRequest request, HttpContext context) {
            Span span;
            HttpHost host;
            block4: {
                host = HttpClientContext.adapt((HttpContext)context).getTargetHost();
                TraceContext parent = (TraceContext)context.getAttribute(TraceContext.class.getName());
                CurrentTraceContext.Scope scope = TracingHttpAsyncClientBuilder.this.currentTraceContext.maybeScope(parent);
                try {
                    span = TracingHttpAsyncClientBuilder.this.handler.nextSpan((Object)request);
                    if (scope == null) break block4;
                }
                catch (Throwable throwable) {
                    if (scope == null) throw throwable;
                    try {
                        scope.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                    }
                    throw throwable;
                }
                scope.close();
            }
            HttpRequestWrapper requestWrapper = HttpRequestWrapper.wrap((HttpRequest)request, (HttpHost)host);
            TracingHttpAsyncClientBuilder.parseTargetAddress(requestWrapper, span);
            TracingHttpAsyncClientBuilder.this.handler.handleSend(TracingHttpAsyncClientBuilder.this.injector, (Object)request, (Object)requestWrapper, span);
            context.setAttribute(Span.class.getName(), (Object)span);
            context.setAttribute(CurrentTraceContext.Scope.class.getName(), (Object)TracingHttpAsyncClientBuilder.this.currentTraceContext.newScope(span.context()));
        }
    }
}

