/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.yaml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.maven.polyglot.yaml.ConstructDependency;
import org.sonatype.maven.polyglot.yaml.ConstructExtension;
import org.sonatype.maven.polyglot.yaml.ConstructParent;
import org.sonatype.maven.polyglot.yaml.ConstructPlugin;
import org.sonatype.maven.polyglot.yaml.ConstructReportPlugin;
import org.sonatype.maven.polyglot.yaml.Coordinate;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public final class ModelConstructor
extends Constructor {
    private final Map<Class<?>, Construct> pomConstructors = new HashMap();

    public ModelConstructor() {
        super(Model.class);
        this.yamlConstructors.put(Tag.MAP, new ConstructXpp3Dom());
        this.yamlClassConstructors.put(NodeId.mapping, new MavenObjectConstruct());
        this.pomConstructors.put(Dependency.class, (Construct)new ConstructDependency());
        this.pomConstructors.put(Parent.class, (Construct)new ConstructParent());
        this.pomConstructors.put(Extension.class, (Construct)new ConstructExtension());
        this.pomConstructors.put(Plugin.class, (Construct)new ConstructPlugin());
        this.pomConstructors.put(ReportPlugin.class, (Construct)new ConstructReportPlugin());
        TypeDescription desc = new TypeDescription(Model.class);
        desc.putListPropertyType("licenses", License.class);
        desc.putListPropertyType("mailingLists", MailingList.class);
        desc.putListPropertyType("dependencies", Dependency.class);
        desc.putListPropertyType("modules", String.class);
        desc.putListPropertyType("profiles", Profile.class);
        desc.putListPropertyType("repositories", Repository.class);
        desc.putListPropertyType("pluginRepositories", Repository.class);
        desc.putListPropertyType("developers", Developer.class);
        desc.putListPropertyType("contributors", Contributor.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(Dependency.class);
        desc.putListPropertyType("exclusions", Exclusion.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(DependencyManagement.class);
        desc.putListPropertyType("dependencies", Dependency.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(Build.class);
        desc.putListPropertyType("extensions", Extension.class);
        desc.putListPropertyType("resources", Resource.class);
        desc.putListPropertyType("testResources", Resource.class);
        desc.putListPropertyType("filters", String.class);
        desc.putListPropertyType("plugins", Plugin.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(BuildBase.class);
        desc.putListPropertyType("resources", Resource.class);
        desc.putListPropertyType("testResources", Resource.class);
        desc.putListPropertyType("filters", String.class);
        desc.putListPropertyType("plugins", Plugin.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(PluginManagement.class);
        desc.putListPropertyType("plugins", Plugin.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(Plugin.class);
        desc.putListPropertyType("executions", PluginExecution.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(PluginExecution.class);
        desc.putListPropertyType("goals", String.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(Reporting.class);
        desc.putListPropertyType("plugins", ReportPlugin.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(ReportPlugin.class);
        desc.putListPropertyType("reportSets", ReportSet.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(ReportSet.class);
        desc.putListPropertyType("reports", String.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(CiManagement.class);
        desc.putListPropertyType("notifiers", Notifier.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(Developer.class);
        desc.putListPropertyType("roles", String.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(Contributor.class);
        desc.putListPropertyType("roles", String.class);
        this.addTypeDescription(desc);
        desc = new TypeDescription(MailingList.class);
        desc.putListPropertyType("otherArchives", String.class);
        this.addTypeDescription(desc);
        this.addTypeDescription(new TypeDescription(DistributionManagement.class));
        this.addTypeDescription(new TypeDescription(Scm.class));
        this.addTypeDescription(new TypeDescription(IssueManagement.class));
        this.addTypeDescription(new TypeDescription(Parent.class));
        this.addTypeDescription(new TypeDescription(Organization.class));
    }

    protected Construct getConstructor(Node node) {
        if (this.pomConstructors.containsKey(node.getType()) && node instanceof ScalarNode) {
            return this.pomConstructors.get(node.getType());
        }
        return super.getConstructor(node);
    }

    private String removeId(MappingNode node) {
        NodeTuple id = null;
        String scalar = null;
        for (NodeTuple tuple : node.getValue()) {
            ScalarNode keyNode = (ScalarNode)tuple.getKeyNode();
            String key = keyNode.getValue();
            if (!"id".equals(key)) continue;
            id = tuple;
            ScalarNode valueNode = (ScalarNode)tuple.getValueNode();
            scalar = valueNode.getValue();
        }
        if (id != null) {
            node.getValue().remove(id);
        }
        return scalar;
    }

    class MavenObjectConstruct
    extends Constructor.ConstructMapping {
        MavenObjectConstruct() {
            super((Constructor)ModelConstructor.this);
        }

        protected Object constructJavaBean2ndStep(MappingNode node, Object object) {
            Class type = node.getType();
            ArrayList<Class> specialCases = new ArrayList<Class>();
            specialCases.add(Dependency.class);
            specialCases.add(Model.class);
            specialCases.add(Plugin.class);
            specialCases.add(ReportPlugin.class);
            if (specialCases.contains(type)) {
                String coordinate = ModelConstructor.this.removeId(node);
                if (coordinate == null) {
                    return super.constructJavaBean2ndStep(node, object);
                }
                if (type.equals(Dependency.class)) {
                    Dependency dep = (Dependency)super.constructJavaBean2ndStep(node, object);
                    return ConstructDependency.createDependency(coordinate, dep);
                }
                if (type.equals(Model.class)) {
                    Coordinate coord = Coordinate.createCoordinate(coordinate);
                    Model model = (Model)super.constructJavaBean2ndStep(node, object);
                    return coord.mergeModel(model);
                }
                if (type.equals(Plugin.class)) {
                    Coordinate coord = Coordinate.createCoordinate(coordinate);
                    Plugin plugin = (Plugin)super.constructJavaBean2ndStep(node, object);
                    return coord.mergePlugin(plugin);
                }
                if (type.equals(ReportPlugin.class)) {
                    Coordinate coord = Coordinate.createCoordinate(coordinate);
                    ReportPlugin plugin = (ReportPlugin)super.constructJavaBean2ndStep(node, object);
                    return coord.mergeReportPlugin(plugin);
                }
            }
            return super.constructJavaBean2ndStep(node, object);
        }
    }

    private class ConstructXpp3Dom
    implements Construct {
        private ConstructXpp3Dom() {
        }

        private Xpp3Dom toDom(Map<Object, Object> map) {
            Xpp3Dom dom = new Xpp3Dom("configuration");
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                Xpp3Dom child;
                if (entry.getValue() instanceof Xpp3Dom) {
                    child = new Xpp3Dom((Xpp3Dom)entry.getValue(), entry.getKey().toString());
                    dom.addChild(child);
                    continue;
                }
                child = new Xpp3Dom(entry.getKey().toString());
                child.setValue(entry.getValue().toString());
                dom.addChild(child);
            }
            return dom;
        }

        public Object construct(Node node) {
            return this.toDom(ModelConstructor.this.constructMapping((MappingNode)node));
        }

        public void construct2ndStep(Node node, Object object) {
            throw new YAMLException("Unexpected recursive mapping structure. Node: " + node);
        }
    }
}

