/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3;

import io.swagger.codegen.v3.CodegenConfig;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGenerator.class);

    public File writeToFile(String filename, String contents) throws IOException {
        LOGGER.info("writing file " + filename);
        File output = new File(filename);
        if (output.getParent() != null && !new File(output.getParent()).exists()) {
            File parent = new File(output.getParent());
            parent.mkdirs();
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), "UTF-8"));
        out.write(contents);
        ((Writer)out).close();
        return output;
    }

    public String readTemplate(String name) {
        try {
            Reader reader = this.getTemplateReader(name);
            if (reader == null) {
                throw new RuntimeException("no file found");
            }
            Scanner s = new Scanner(reader).useDelimiter("\\A");
            return s.hasNext() ? s.next() : "";
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new RuntimeException("can't load template " + name);
        }
    }

    public Reader getTemplateReader(String name) {
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.getCPResourcePath(name));
            if (is == null) {
                is = new FileInputStream(new File(name));
            }
            return new InputStreamReader(is, "UTF-8");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new RuntimeException("can't load template " + name);
        }
    }

    private String buildLibraryFilePath(String dir, String library, String file) {
        return dir + File.separator + "libraries" + File.separator + library + File.separator + file;
    }

    public String getFullTemplateFile(CodegenConfig config, String templateFile) {
        String embeddedLibTemplateFile;
        String libTemplateFile;
        String library = config.getLibrary();
        if (StringUtils.isNotEmpty((CharSequence)library) && new File(libTemplateFile = this.buildLibraryFilePath(config.templateDir(), library, templateFile)).exists()) {
            return libTemplateFile;
        }
        String template = config.templateDir() + File.separator + templateFile;
        if (new File(template).exists()) {
            return template;
        }
        if (StringUtils.isNotEmpty((CharSequence)library) && this.embeddedTemplateExists(embeddedLibTemplateFile = this.buildLibraryFilePath(config.embeddedTemplateDir(), library, templateFile))) {
            return embeddedLibTemplateFile;
        }
        return config.embeddedTemplateDir() + File.separator + templateFile;
    }

    public String readResourceContents(String resourceFilePath) {
        StringBuilder sb = new StringBuilder();
        Scanner scanner = new Scanner(this.getClass().getResourceAsStream(this.getCPResourcePath(resourceFilePath)), "UTF-8");
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            sb.append(line).append('\n');
        }
        return sb.toString();
    }

    public boolean embeddedTemplateExists(String name) {
        return this.getClass().getClassLoader().getResource(this.getCPResourcePath(name)) != null;
    }

    public String getCPResourcePath(String name) {
        if (!"/".equals(File.separator)) {
            return name.replaceAll(Pattern.quote(File.separator), "/");
        }
        return name;
    }
}

