/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.instruction;

import io.smallrye.classfile.Instruction;
import io.smallrye.classfile.Opcode;
import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.impl.AbstractInstruction;
import io.smallrye.classfile.impl.TemporaryConstantPool;
import io.smallrye.classfile.impl.Util;
import java.lang.constant.ClassDesc;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface TypeCheckInstruction
extends Instruction {
    public ClassEntry type();

    public static TypeCheckInstruction of(Opcode op, ClassEntry type) {
        Util.checkKind(op, Opcode.Kind.TYPE_CHECK);
        return new AbstractInstruction.UnboundTypeCheckInstruction(op, type);
    }

    public static TypeCheckInstruction of(Opcode op, ClassDesc type) {
        return TypeCheckInstruction.of(op, TemporaryConstantPool.INSTANCE.classEntry(type));
    }
}

