/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.instruction;

import io.smallrye.classfile.Instruction;
import io.smallrye.classfile.Label;
import io.smallrye.classfile.Opcode;
import io.smallrye.classfile.impl.AbstractInstruction;
import io.smallrye.classfile.impl.BytecodeHelpers;
import io.smallrye.classfile.impl.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface DiscontinuedInstruction
extends Instruction {

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface RetInstruction
    extends DiscontinuedInstruction {
        public int slot();

        public static RetInstruction of(Opcode op, int slot) {
            BytecodeHelpers.validateRet(op, slot);
            return new AbstractInstruction.UnboundRetInstruction(op, slot);
        }

        public static RetInstruction of(int slot) {
            return RetInstruction.of(slot < 256 ? Opcode.RET : Opcode.RET_W, slot);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface JsrInstruction
    extends DiscontinuedInstruction {
        public Label target();

        public static JsrInstruction of(Opcode op, Label target) {
            Util.checkKind(op, Opcode.Kind.DISCONTINUED_JSR);
            return new AbstractInstruction.UnboundJsrInstruction(op, target);
        }

        public static JsrInstruction of(Label target) {
            return JsrInstruction.of(Opcode.JSR, target);
        }
    }
}

