/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.Annotation;
import io.smallrye.classfile.AnnotationValue;
import io.smallrye.classfile.Attribute;
import io.smallrye.classfile.AttributeMapper;
import io.smallrye.classfile.Attributes;
import io.smallrye.classfile.BootstrapMethodEntry;
import io.smallrye.classfile.TypeAnnotation;
import io.smallrye.classfile.attribute.AnnotationDefaultAttribute;
import io.smallrye.classfile.attribute.BootstrapMethodsAttribute;
import io.smallrye.classfile.attribute.CharacterRangeInfo;
import io.smallrye.classfile.attribute.CharacterRangeTableAttribute;
import io.smallrye.classfile.attribute.CompilationIDAttribute;
import io.smallrye.classfile.attribute.ConstantValueAttribute;
import io.smallrye.classfile.attribute.DeprecatedAttribute;
import io.smallrye.classfile.attribute.EnclosingMethodAttribute;
import io.smallrye.classfile.attribute.ExceptionsAttribute;
import io.smallrye.classfile.attribute.InnerClassInfo;
import io.smallrye.classfile.attribute.InnerClassesAttribute;
import io.smallrye.classfile.attribute.LineNumberInfo;
import io.smallrye.classfile.attribute.LineNumberTableAttribute;
import io.smallrye.classfile.attribute.LocalVariableInfo;
import io.smallrye.classfile.attribute.LocalVariableTableAttribute;
import io.smallrye.classfile.attribute.LocalVariableTypeInfo;
import io.smallrye.classfile.attribute.LocalVariableTypeTableAttribute;
import io.smallrye.classfile.attribute.MethodParameterInfo;
import io.smallrye.classfile.attribute.MethodParametersAttribute;
import io.smallrye.classfile.attribute.ModuleAttribute;
import io.smallrye.classfile.attribute.ModuleExportInfo;
import io.smallrye.classfile.attribute.ModuleHashInfo;
import io.smallrye.classfile.attribute.ModuleHashesAttribute;
import io.smallrye.classfile.attribute.ModuleMainClassAttribute;
import io.smallrye.classfile.attribute.ModuleOpenInfo;
import io.smallrye.classfile.attribute.ModulePackagesAttribute;
import io.smallrye.classfile.attribute.ModuleProvideInfo;
import io.smallrye.classfile.attribute.ModuleRequireInfo;
import io.smallrye.classfile.attribute.ModuleResolutionAttribute;
import io.smallrye.classfile.attribute.ModuleTargetAttribute;
import io.smallrye.classfile.attribute.NestHostAttribute;
import io.smallrye.classfile.attribute.NestMembersAttribute;
import io.smallrye.classfile.attribute.PermittedSubclassesAttribute;
import io.smallrye.classfile.attribute.RecordAttribute;
import io.smallrye.classfile.attribute.RecordComponentInfo;
import io.smallrye.classfile.attribute.RuntimeInvisibleAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeInvisibleParameterAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeInvisibleTypeAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeVisibleParameterAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeVisibleTypeAnnotationsAttribute;
import io.smallrye.classfile.attribute.SignatureAttribute;
import io.smallrye.classfile.attribute.SourceDebugExtensionAttribute;
import io.smallrye.classfile.attribute.SourceFileAttribute;
import io.smallrye.classfile.attribute.SourceIDAttribute;
import io.smallrye.classfile.attribute.StackMapFrameInfo;
import io.smallrye.classfile.attribute.StackMapTableAttribute;
import io.smallrye.classfile.attribute.SyntheticAttribute;
import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.constantpool.ConstantValueEntry;
import io.smallrye.classfile.constantpool.ModuleEntry;
import io.smallrye.classfile.constantpool.NameAndTypeEntry;
import io.smallrye.classfile.constantpool.PackageEntry;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.impl.AbstractElement;
import io.smallrye.classfile.impl.BufWriterImpl;
import io.smallrye.classfile.impl.DirectClassBuilder;
import io.smallrye.classfile.impl.DirectCodeBuilder;
import io.smallrye.classfile.impl.DirectFieldBuilder;
import io.smallrye.classfile.impl.DirectMethodBuilder;
import io.smallrye.classfile.impl.TemporaryConstantPool;
import io.smallrye.classfile.impl.Util;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class UnboundAttribute<T extends Attribute<T>>
extends AbstractElement
implements Attribute<T>,
Util.Writable {
    protected final AttributeMapper<T> mapper;

    public UnboundAttribute(AttributeMapper<T> mapper) {
        this.mapper = mapper;
    }

    @Override
    public AttributeMapper<T> attributeMapper() {
        return this.mapper;
    }

    @Override
    public void writeTo(BufWriterImpl buf) {
        this.mapper.writeAttribute(buf, this);
    }

    @Override
    public void writeTo(DirectClassBuilder builder) {
        builder.writeAttribute(this);
    }

    @Override
    public void writeTo(DirectCodeBuilder builder) {
        builder.writeAttribute(this);
    }

    @Override
    public void writeTo(DirectMethodBuilder builder) {
        builder.writeAttribute(this);
    }

    @Override
    public void writeTo(DirectFieldBuilder builder) {
        builder.writeAttribute(this);
    }

    public String toString() {
        return String.format("Attribute[name=%s]", this.mapper.name());
    }

    public static final class EmptyBootstrapAttribute
    extends UnboundAttribute<BootstrapMethodsAttribute>
    implements BootstrapMethodsAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("BootstrapMethods");

        public EmptyBootstrapAttribute() {
            super(Attributes.bootstrapMethods());
        }

        @Override
        public int bootstrapMethodsSize() {
            return 0;
        }

        @Override
        public List<BootstrapMethodEntry> bootstrapMethods() {
            return List.of();
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static abstract class AdHocAttribute<T extends Attribute<T>>
    extends UnboundAttribute<T> {
        public AdHocAttribute(AttributeMapper<T> mapper) {
            super(mapper);
        }

        public abstract void writeBody(BufWriterImpl var1);

        @Override
        public void writeTo(BufWriterImpl b) {
            b.writeIndex(b.constantPool().utf8Entry(this.mapper.name()));
            int lengthIndex = b.skip(4);
            this.writeBody(b);
            int written = b.size() - lengthIndex - 4;
            b.patchInt(lengthIndex, written);
        }
    }

    public static final class UnboundModuleAttribute
    extends UnboundAttribute<ModuleAttribute>
    implements ModuleAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("Module");
        private final ModuleEntry moduleName;
        private final int moduleFlags;
        private final Utf8Entry moduleVersion;
        private final List<ModuleRequireInfo> requires;
        private final List<ModuleExportInfo> exports;
        private final List<ModuleOpenInfo> opens;
        private final List<ClassEntry> uses;
        private final List<ModuleProvideInfo> provides;

        public UnboundModuleAttribute(ModuleEntry moduleName, int moduleFlags, Utf8Entry moduleVersion, Collection<ModuleRequireInfo> requires, Collection<ModuleExportInfo> exports, Collection<ModuleOpenInfo> opens, Collection<ClassEntry> uses, Collection<ModuleProvideInfo> provides) {
            super(Attributes.module());
            this.moduleName = Objects.requireNonNull(moduleName);
            this.moduleFlags = Util.checkFlags(moduleFlags);
            this.moduleVersion = moduleVersion;
            this.requires = Util.sanitizeU2List(requires);
            this.exports = Util.sanitizeU2List(exports);
            this.opens = Util.sanitizeU2List(opens);
            this.uses = Util.sanitizeU2List(uses);
            this.provides = Util.sanitizeU2List(provides);
        }

        @Override
        public ModuleEntry moduleName() {
            return this.moduleName;
        }

        @Override
        public int moduleFlagsMask() {
            return this.moduleFlags;
        }

        @Override
        public Optional<Utf8Entry> moduleVersion() {
            return Optional.ofNullable(this.moduleVersion);
        }

        @Override
        public List<ModuleRequireInfo> requires() {
            return this.requires;
        }

        @Override
        public List<ModuleExportInfo> exports() {
            return this.exports;
        }

        @Override
        public List<ModuleOpenInfo> opens() {
            return this.opens;
        }

        @Override
        public List<ClassEntry> uses() {
            return this.uses;
        }

        @Override
        public List<ModuleProvideInfo> provides() {
            return this.provides;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public record TypePathComponentImpl(TypeAnnotation.TypePathComponent.Kind typePathKind, int typeArgumentIndex) implements TypeAnnotation.TypePathComponent
    {
    }

    public record UnboundTypeAnnotation(TypeAnnotation.TargetInfo targetInfo, List<TypeAnnotation.TypePathComponent> targetPath, Annotation annotation) implements TypeAnnotation
    {
        public UnboundTypeAnnotation {
            Objects.requireNonNull(targetInfo);
            targetPath = Util.sanitizeU1List(targetPath);
            Objects.requireNonNull(annotation);
        }
    }

    public record UnboundRecordComponentInfo(Utf8Entry name, Utf8Entry descriptor, List<Attribute<?>> attributes) implements RecordComponentInfo
    {
        public UnboundRecordComponentInfo {
            Objects.requireNonNull(name);
            Objects.requireNonNull(descriptor);
            attributes = Util.sanitizeU2List(attributes);
        }
    }

    public record UnboundModuleRequiresInfo(ModuleEntry requires, int requiresFlagsMask, Optional<Utf8Entry> requiresVersion) implements ModuleRequireInfo
    {
        public UnboundModuleRequiresInfo {
            Objects.requireNonNull(requires);
            Util.checkFlags(requiresFlagsMask);
            Objects.requireNonNull(requiresVersion);
        }
    }

    public record UnboundModuleProvideInfo(ClassEntry provides, List<ClassEntry> providesWith) implements ModuleProvideInfo
    {
        public UnboundModuleProvideInfo {
            Objects.requireNonNull(provides);
            providesWith = Util.sanitizeU2List(providesWith);
        }
    }

    public record UnboundModuleOpenInfo(PackageEntry openedPackage, int opensFlagsMask, List<ModuleEntry> opensTo) implements ModuleOpenInfo
    {
        public UnboundModuleOpenInfo {
            Objects.requireNonNull(openedPackage);
            Util.checkFlags(opensFlagsMask);
            opensTo = Util.sanitizeU2List(opensTo);
        }
    }

    public record UnboundModuleHashInfo(ModuleEntry moduleName, byte[] hash) implements ModuleHashInfo
    {
        public UnboundModuleHashInfo {
            Objects.requireNonNull(moduleName);
            Objects.requireNonNull(hash);
        }
    }

    public record UnboundModuleExportInfo(PackageEntry exportedPackage, int exportsFlagsMask, List<ModuleEntry> exportsTo) implements ModuleExportInfo
    {
        public UnboundModuleExportInfo {
            Objects.requireNonNull(exportedPackage);
            Util.checkFlags(exportsFlagsMask);
            exportsTo = Util.sanitizeU2List(exportsTo);
        }
    }

    public record UnboundMethodParameterInfo(Optional<Utf8Entry> name, int flagsMask) implements MethodParameterInfo
    {
        public UnboundMethodParameterInfo {
            Objects.requireNonNull(name);
            Util.checkFlags(flagsMask);
        }
    }

    public record UnboundLocalVariableTypeInfo(int startPc, int length, Utf8Entry name, Utf8Entry signature, int slot) implements LocalVariableTypeInfo
    {
        public UnboundLocalVariableTypeInfo {
            Objects.requireNonNull(name);
            Objects.requireNonNull(signature);
        }
    }

    public record UnboundLocalVariableInfo(int startPc, int length, Utf8Entry name, Utf8Entry type, int slot) implements LocalVariableInfo
    {
        public UnboundLocalVariableInfo {
            Objects.requireNonNull(name);
            Objects.requireNonNull(type);
        }
    }

    public record UnboundLineNumberInfo(int startPc, int lineNumber) implements LineNumberInfo
    {
        public UnboundLineNumberInfo {
            Util.checkU2(startPc, "start pc");
            Util.checkU2(lineNumber, "line number");
        }
    }

    public record UnboundInnerClassInfo(ClassEntry innerClass, Optional<ClassEntry> outerClass, Optional<Utf8Entry> innerName, int flagsMask) implements InnerClassInfo
    {
        public UnboundInnerClassInfo {
            Objects.requireNonNull(innerClass);
            Objects.requireNonNull(outerClass);
            Objects.requireNonNull(innerName);
            Util.checkFlags(flagsMask);
        }
    }

    public record UnboundCharacterRangeInfo(int startPc, int endPc, int characterRangeStart, int characterRangeEnd, int flags) implements CharacterRangeInfo
    {
        public UnboundCharacterRangeInfo {
            Util.checkU2(startPc, "start pc");
            Util.checkU2(endPc, "end pc");
            Util.checkU2(flags, "flags");
        }
    }

    public static final class UnboundRuntimeInvisibleTypeAnnotationsAttribute
    extends UnboundAttribute<RuntimeInvisibleTypeAnnotationsAttribute>
    implements RuntimeInvisibleTypeAnnotationsAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("RuntimeInvisibleTypeAnnotations");
        private final List<TypeAnnotation> elements;

        public UnboundRuntimeInvisibleTypeAnnotationsAttribute(List<TypeAnnotation> elements) {
            super(Attributes.runtimeInvisibleTypeAnnotations());
            this.elements = Util.sanitizeU2List(elements);
        }

        @Override
        public List<TypeAnnotation> annotations() {
            return this.elements;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundRuntimeVisibleTypeAnnotationsAttribute
    extends UnboundAttribute<RuntimeVisibleTypeAnnotationsAttribute>
    implements RuntimeVisibleTypeAnnotationsAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("RuntimeVisibleTypeAnnotations");
        private final List<TypeAnnotation> elements;

        public UnboundRuntimeVisibleTypeAnnotationsAttribute(List<TypeAnnotation> elements) {
            super(Attributes.runtimeVisibleTypeAnnotations());
            this.elements = Util.sanitizeU2List(elements);
        }

        @Override
        public List<TypeAnnotation> annotations() {
            return this.elements;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundRuntimeInvisibleParameterAnnotationsAttribute
    extends UnboundAttribute<RuntimeInvisibleParameterAnnotationsAttribute>
    implements RuntimeInvisibleParameterAnnotationsAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("RuntimeInvisibleParameterAnnotations");
        private final List<List<Annotation>> elements;

        public UnboundRuntimeInvisibleParameterAnnotationsAttribute(List<List<Annotation>> elements) {
            super(Attributes.runtimeInvisibleParameterAnnotations());
            this.elements = Util.sanitizeParameterAnnotations(elements);
        }

        @Override
        public List<List<Annotation>> parameterAnnotations() {
            return this.elements;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundRuntimeVisibleParameterAnnotationsAttribute
    extends UnboundAttribute<RuntimeVisibleParameterAnnotationsAttribute>
    implements RuntimeVisibleParameterAnnotationsAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("RuntimeVisibleParameterAnnotations");
        private final List<List<Annotation>> elements;

        public UnboundRuntimeVisibleParameterAnnotationsAttribute(List<List<Annotation>> elements) {
            super(Attributes.runtimeVisibleParameterAnnotations());
            this.elements = Util.sanitizeParameterAnnotations(elements);
        }

        @Override
        public List<List<Annotation>> parameterAnnotations() {
            return this.elements;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundRuntimeInvisibleAnnotationsAttribute
    extends UnboundAttribute<RuntimeInvisibleAnnotationsAttribute>
    implements RuntimeInvisibleAnnotationsAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("RuntimeInvisibleAnnotations");
        private final List<Annotation> elements;

        public UnboundRuntimeInvisibleAnnotationsAttribute(List<Annotation> elements) {
            super(Attributes.runtimeInvisibleAnnotations());
            this.elements = Util.sanitizeU2List(elements);
        }

        @Override
        public List<Annotation> annotations() {
            return this.elements;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundRuntimeVisibleAnnotationsAttribute
    extends UnboundAttribute<RuntimeVisibleAnnotationsAttribute>
    implements RuntimeVisibleAnnotationsAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("RuntimeVisibleAnnotations");
        private final List<Annotation> elements;

        public UnboundRuntimeVisibleAnnotationsAttribute(List<Annotation> elements) {
            super(Attributes.runtimeVisibleAnnotations());
            this.elements = Util.sanitizeU2List(elements);
        }

        @Override
        public List<Annotation> annotations() {
            return this.elements;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundLocalVariableTypeTableAttribute
    extends UnboundAttribute<LocalVariableTypeTableAttribute>
    implements LocalVariableTypeTableAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("LocalVariableTypeTable");
        private final List<LocalVariableTypeInfo> locals;

        public UnboundLocalVariableTypeTableAttribute(List<LocalVariableTypeInfo> locals) {
            super(Attributes.localVariableTypeTable());
            this.locals = Util.sanitizeU2List(locals);
        }

        @Override
        public List<LocalVariableTypeInfo> localVariableTypes() {
            return this.locals;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundLocalVariableTableAttribute
    extends UnboundAttribute<LocalVariableTableAttribute>
    implements LocalVariableTableAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("LocalVariableTable");
        private final List<LocalVariableInfo> locals;

        public UnboundLocalVariableTableAttribute(List<LocalVariableInfo> locals) {
            super(Attributes.localVariableTable());
            this.locals = Util.sanitizeU2List(locals);
        }

        @Override
        public List<LocalVariableInfo> localVariables() {
            return this.locals;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundLineNumberTableAttribute
    extends UnboundAttribute<LineNumberTableAttribute>
    implements LineNumberTableAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("LineNumberTable");
        private final List<LineNumberInfo> lines;

        public UnboundLineNumberTableAttribute(List<LineNumberInfo> lines) {
            super(Attributes.lineNumberTable());
            this.lines = Util.sanitizeU2List(lines);
        }

        @Override
        public List<LineNumberInfo> lineNumbers() {
            return this.lines;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundCharacterRangeTableAttribute
    extends UnboundAttribute<CharacterRangeTableAttribute>
    implements CharacterRangeTableAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("CharacterRangeTable");
        private final List<CharacterRangeInfo> ranges;

        public UnboundCharacterRangeTableAttribute(List<CharacterRangeInfo> ranges) {
            super(Attributes.characterRangeTable());
            this.ranges = Util.sanitizeU2List(ranges);
        }

        @Override
        public List<CharacterRangeInfo> characterRangeTable() {
            return this.ranges;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundSourceDebugExtensionAttribute
    extends UnboundAttribute<SourceDebugExtensionAttribute>
    implements SourceDebugExtensionAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("SourceDebugExtension");
        private final byte[] contents;

        public UnboundSourceDebugExtensionAttribute(byte[] contents) {
            super(Attributes.sourceDebugExtension());
            this.contents = Objects.requireNonNull(contents);
        }

        @Override
        public byte[] contents() {
            return this.contents;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundSourceIDAttribute
    extends UnboundAttribute<SourceIDAttribute>
    implements SourceIDAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("SourceID");
        private final Utf8Entry idEntry;

        public UnboundSourceIDAttribute(Utf8Entry idEntry) {
            super(Attributes.sourceId());
            this.idEntry = Objects.requireNonNull(idEntry);
        }

        @Override
        public Utf8Entry sourceId() {
            return this.idEntry;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundCompilationIDAttribute
    extends UnboundAttribute<CompilationIDAttribute>
    implements CompilationIDAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("CompilationID");
        private final Utf8Entry idEntry;

        public UnboundCompilationIDAttribute(Utf8Entry idEntry) {
            super(Attributes.compilationId());
            this.idEntry = Objects.requireNonNull(idEntry);
        }

        @Override
        public Utf8Entry compilationId() {
            return this.idEntry;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundNestHostAttribute
    extends UnboundAttribute<NestHostAttribute>
    implements NestHostAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("NestHost");
        private final ClassEntry hostEntry;

        public UnboundNestHostAttribute(ClassEntry hostEntry) {
            super(Attributes.nestHost());
            this.hostEntry = Objects.requireNonNull(hostEntry);
        }

        @Override
        public ClassEntry nestHost() {
            return this.hostEntry;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundNestMembersAttribute
    extends UnboundAttribute<NestMembersAttribute>
    implements NestMembersAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("NestMembers");
        private final List<ClassEntry> memberEntries;

        public UnboundNestMembersAttribute(List<ClassEntry> memberEntries) {
            super(Attributes.nestMembers());
            this.memberEntries = Util.sanitizeU2List(memberEntries);
        }

        @Override
        public List<ClassEntry> nestMembers() {
            return this.memberEntries;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundPermittedSubclassesAttribute
    extends UnboundAttribute<PermittedSubclassesAttribute>
    implements PermittedSubclassesAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("PermittedSubclasses");
        private final List<ClassEntry> permittedSubclasses;

        public UnboundPermittedSubclassesAttribute(List<ClassEntry> permittedSubclasses) {
            super(Attributes.permittedSubclasses());
            this.permittedSubclasses = Util.sanitizeU2List(permittedSubclasses);
        }

        @Override
        public List<ClassEntry> permittedSubclasses() {
            return this.permittedSubclasses;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundModuleResolutionAttribute
    extends UnboundAttribute<ModuleResolutionAttribute>
    implements ModuleResolutionAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("ModuleResolution");
        private final int resolutionFlags;

        public UnboundModuleResolutionAttribute(int flags) {
            super(Attributes.moduleResolution());
            this.resolutionFlags = Util.checkU2(flags, "resolution flags");
        }

        @Override
        public int resolutionFlags() {
            return this.resolutionFlags;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundModulePackagesAttribute
    extends UnboundAttribute<ModulePackagesAttribute>
    implements ModulePackagesAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("ModulePackages");
        private final List<PackageEntry> packages;

        public UnboundModulePackagesAttribute(Collection<PackageEntry> packages) {
            super(Attributes.modulePackages());
            this.packages = Util.sanitizeU2List(packages);
        }

        @Override
        public List<PackageEntry> packages() {
            return this.packages;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundModuleHashesAttribute
    extends UnboundAttribute<ModuleHashesAttribute>
    implements ModuleHashesAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("ModuleHashes");
        private final Utf8Entry algorithm;
        private final List<ModuleHashInfo> hashes;

        public UnboundModuleHashesAttribute(Utf8Entry algorithm, List<ModuleHashInfo> hashes) {
            super(Attributes.moduleHashes());
            this.algorithm = Objects.requireNonNull(algorithm);
            this.hashes = Util.sanitizeU2List(hashes);
        }

        @Override
        public Utf8Entry algorithm() {
            return this.algorithm;
        }

        @Override
        public List<ModuleHashInfo> hashes() {
            return this.hashes;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundModuleMainClassAttribute
    extends UnboundAttribute<ModuleMainClassAttribute>
    implements ModuleMainClassAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("ModuleMainClass");
        final ClassEntry mainClass;

        public UnboundModuleMainClassAttribute(ClassEntry mainClass) {
            super(Attributes.moduleMainClass());
            this.mainClass = Objects.requireNonNull(mainClass);
        }

        @Override
        public ClassEntry mainClass() {
            return this.mainClass;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundModuleTargetAttribute
    extends UnboundAttribute<ModuleTargetAttribute>
    implements ModuleTargetAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("ModuleTarget");
        final Utf8Entry moduleTarget;

        public UnboundModuleTargetAttribute(Utf8Entry moduleTarget) {
            super(Attributes.moduleTarget());
            this.moduleTarget = Objects.requireNonNull(moduleTarget);
        }

        @Override
        public Utf8Entry targetPlatform() {
            return this.moduleTarget;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundMethodParametersAttribute
    extends UnboundAttribute<MethodParametersAttribute>
    implements MethodParametersAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("MethodParameters");
        private final List<MethodParameterInfo> parameters;

        public UnboundMethodParametersAttribute(List<MethodParameterInfo> parameters) {
            super(Attributes.methodParameters());
            this.parameters = Util.sanitizeU1List(parameters);
        }

        @Override
        public List<MethodParameterInfo> parameters() {
            return this.parameters;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundEnclosingMethodAttribute
    extends UnboundAttribute<EnclosingMethodAttribute>
    implements EnclosingMethodAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("EnclosingMethod");
        private final ClassEntry classEntry;
        private final NameAndTypeEntry method;

        public UnboundEnclosingMethodAttribute(ClassEntry classEntry, NameAndTypeEntry method) {
            super(Attributes.enclosingMethod());
            this.classEntry = Objects.requireNonNull(classEntry);
            this.method = method;
        }

        @Override
        public ClassEntry enclosingClass() {
            return this.classEntry;
        }

        @Override
        public Optional<NameAndTypeEntry> enclosingMethod() {
            return Optional.ofNullable(this.method);
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundRecordAttribute
    extends UnboundAttribute<RecordAttribute>
    implements RecordAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("Record");
        private final List<RecordComponentInfo> components;

        public UnboundRecordAttribute(List<RecordComponentInfo> components) {
            super(Attributes.record());
            this.components = Util.sanitizeU2List(components);
        }

        @Override
        public List<RecordComponentInfo> components() {
            return this.components;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundInnerClassesAttribute
    extends UnboundAttribute<InnerClassesAttribute>
    implements InnerClassesAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("InnerClasses");
        private final List<InnerClassInfo> innerClasses;

        public UnboundInnerClassesAttribute(List<InnerClassInfo> innerClasses) {
            super(Attributes.innerClasses());
            this.innerClasses = Util.sanitizeU2List(innerClasses);
        }

        @Override
        public List<InnerClassInfo> classes() {
            return this.innerClasses;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundStackMapTableAttribute
    extends UnboundAttribute<StackMapTableAttribute>
    implements StackMapTableAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("StackMapTable");
        private final List<StackMapFrameInfo> entries;

        public UnboundStackMapTableAttribute(List<StackMapFrameInfo> entries) {
            super(Attributes.stackMapTable());
            this.entries = Util.sanitizeU2List(entries);
        }

        @Override
        public List<StackMapFrameInfo> entries() {
            return this.entries;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundSourceFileAttribute
    extends UnboundAttribute<SourceFileAttribute>
    implements SourceFileAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("SourceFile");
        private final Utf8Entry sourceFile;

        public UnboundSourceFileAttribute(Utf8Entry sourceFile) {
            super(Attributes.sourceFile());
            this.sourceFile = Objects.requireNonNull(sourceFile);
        }

        @Override
        public Utf8Entry sourceFile() {
            return this.sourceFile;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundAnnotationDefaultAttribute
    extends UnboundAttribute<AnnotationDefaultAttribute>
    implements AnnotationDefaultAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("AnnotationDefault");
        private final AnnotationValue annotationDefault;

        public UnboundAnnotationDefaultAttribute(AnnotationValue annotationDefault) {
            super(Attributes.annotationDefault());
            this.annotationDefault = Objects.requireNonNull(annotationDefault);
        }

        @Override
        public AnnotationValue defaultValue() {
            return this.annotationDefault;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundExceptionsAttribute
    extends UnboundAttribute<ExceptionsAttribute>
    implements ExceptionsAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("Exceptions");
        private final List<ClassEntry> exceptions;

        public UnboundExceptionsAttribute(List<ClassEntry> exceptions) {
            super(Attributes.exceptions());
            this.exceptions = Util.sanitizeU2List(exceptions);
        }

        @Override
        public List<ClassEntry> exceptions() {
            return this.exceptions;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundSignatureAttribute
    extends UnboundAttribute<SignatureAttribute>
    implements SignatureAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("Signature");
        private final Utf8Entry signature;

        public UnboundSignatureAttribute(Utf8Entry signature) {
            super(Attributes.signature());
            this.signature = Objects.requireNonNull(signature);
        }

        @Override
        public Utf8Entry signature() {
            return this.signature;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundSyntheticAttribute
    extends UnboundAttribute<SyntheticAttribute>
    implements SyntheticAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("Synthetic");

        public UnboundSyntheticAttribute() {
            super(Attributes.synthetic());
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundDeprecatedAttribute
    extends UnboundAttribute<DeprecatedAttribute>
    implements DeprecatedAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("Deprecated");

        public UnboundDeprecatedAttribute() {
            super(Attributes.deprecated());
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }

    public static final class UnboundConstantValueAttribute
    extends UnboundAttribute<ConstantValueAttribute>
    implements ConstantValueAttribute {
        private static final Utf8Entry NAME = TemporaryConstantPool.INSTANCE.utf8Entry("ConstantValue");
        private final ConstantValueEntry entry;

        public UnboundConstantValueAttribute(ConstantValueEntry entry) {
            super(Attributes.constantValue());
            this.entry = Objects.requireNonNull(entry);
        }

        @Override
        public ConstantValueEntry constant() {
            return this.entry;
        }

        @Override
        public Utf8Entry attributeName() {
            return NAME;
        }
    }
}

