/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.Interfaces;
import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.impl.AbstractElement;
import io.smallrye.classfile.impl.DirectClassBuilder;
import io.smallrye.classfile.impl.Util;
import java.util.List;
import java.util.stream.Collectors;

public final class InterfacesImpl
extends AbstractElement
implements Interfaces {
    private final List<ClassEntry> interfaces;

    public InterfacesImpl(List<ClassEntry> interfaces) {
        this.interfaces = Util.sanitizeU2List(interfaces);
    }

    @Override
    public List<ClassEntry> interfaces() {
        return this.interfaces;
    }

    @Override
    public void writeTo(DirectClassBuilder builder) {
        builder.setInterfaces(this.interfaces);
    }

    public String toString() {
        return String.format("Interfaces[interfaces=%s]", this.interfaces.stream().map(iface -> iface.name().stringValue()).collect(Collectors.joining(", ")));
    }
}

