/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.attribute;

import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.impl.TemporaryConstantPool;
import io.smallrye.classfile.impl.UnboundAttribute;
import io.smallrye.classfile.impl.Util;
import java.lang.constant.ClassDesc;
import java.util.Arrays;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ModuleProvideInfo {
    public ClassEntry provides();

    public List<ClassEntry> providesWith();

    public static ModuleProvideInfo of(ClassEntry provides, List<ClassEntry> providesWith) {
        return new UnboundAttribute.UnboundModuleProvideInfo(provides, providesWith);
    }

    public static ModuleProvideInfo of(ClassEntry provides, ClassEntry ... providesWith) {
        return ModuleProvideInfo.of(provides, List.of(providesWith));
    }

    public static ModuleProvideInfo of(ClassDesc provides, List<ClassDesc> providesWith) {
        return ModuleProvideInfo.of(TemporaryConstantPool.INSTANCE.classEntry(provides), Util.entryList(providesWith));
    }

    public static ModuleProvideInfo of(ClassDesc provides, ClassDesc ... providesWith) {
        return ModuleProvideInfo.of(provides, Arrays.asList(providesWith));
    }
}

