/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBuf;
import io.rsocket.Availability;
import io.rsocket.core.LeasePermitHandler;
import io.rsocket.frame.LeaseFrameCodec;
import io.rsocket.lease.Lease;
import io.rsocket.lease.MissingLeaseException;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Queue;

final class RequesterLeaseTracker
implements Availability {
    final String tag;
    final int maximumAllowedAwaitingPermitHandlersNumber;
    final Queue<LeasePermitHandler> awaitingPermitHandlersQueue;
    Lease currentLease = null;
    int availableRequests;
    boolean isDisposed;
    Throwable t;

    RequesterLeaseTracker(String tag, int maximumAllowedAwaitingPermitHandlersNumber) {
        this.tag = tag;
        this.maximumAllowedAwaitingPermitHandlersNumber = maximumAllowedAwaitingPermitHandlersNumber;
        this.awaitingPermitHandlersQueue = new ArrayDeque<LeasePermitHandler>();
    }

    synchronized void issue(LeasePermitHandler leasePermitHandler) {
        boolean isExpired;
        if (this.isDisposed) {
            leasePermitHandler.handlePermitError(this.t);
            return;
        }
        int availableRequests = this.availableRequests;
        Lease l = this.currentLease;
        boolean leaseReceived = l != null;
        boolean bl = isExpired = leaseReceived && RequesterLeaseTracker.isExpired(l);
        if (leaseReceived && availableRequests > 0 && !isExpired) {
            if (leasePermitHandler.handlePermit()) {
                this.availableRequests = availableRequests - 1;
            }
        } else {
            Queue<LeasePermitHandler> queue = this.awaitingPermitHandlersQueue;
            if (this.maximumAllowedAwaitingPermitHandlersNumber > queue.size()) {
                queue.offer(leasePermitHandler);
            } else {
                String tag = this.tag;
                String message = !leaseReceived ? String.format("[%s] Lease was not received yet", tag) : (isExpired ? String.format("[%s] Missing leases. Lease is expired", tag) : String.format("[%s] Missing leases. Issued [%s] request allowance is used", tag, availableRequests));
                MissingLeaseException t = new MissingLeaseException(message);
                leasePermitHandler.handlePermitError(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleLeaseFrame(ByteBuf leaseFrame) {
        int numberOfRequests = LeaseFrameCodec.numRequests(leaseFrame);
        int timeToLiveMillis = LeaseFrameCodec.ttl(leaseFrame);
        ByteBuf metadata = LeaseFrameCodec.metadata(leaseFrame);
        RequesterLeaseTracker requesterLeaseTracker = this;
        synchronized (requesterLeaseTracker) {
            Lease lease = Lease.create(Duration.ofMillis(timeToLiveMillis), numberOfRequests, metadata);
            Queue<LeasePermitHandler> queue = this.awaitingPermitHandlersQueue;
            int availableRequests = lease.numberOfRequests();
            this.currentLease = lease;
            if (queue.size() > 0) {
                do {
                    LeasePermitHandler handler;
                    if (!(handler = queue.poll()).handlePermit()) continue;
                    --availableRequests;
                } while (availableRequests > 0 && queue.size() > 0);
            }
            this.availableRequests = availableRequests;
        }
    }

    public synchronized void dispose(Throwable t) {
        this.isDisposed = true;
        this.t = t;
        Queue<LeasePermitHandler> queue = this.awaitingPermitHandlersQueue;
        int size = queue.size();
        for (int i = 0; i < size; ++i) {
            LeasePermitHandler leasePermitHandler = queue.poll();
            leasePermitHandler.handlePermitError(t);
        }
    }

    @Override
    public synchronized double availability() {
        Lease lease = this.currentLease;
        return lease != null ? (double)this.availableRequests / (double)lease.numberOfRequests() : 0.0;
    }

    static boolean isExpired(Lease currentLease) {
        return System.currentTimeMillis() >= currentLease.expirationTime();
    }
}

