/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.ClientProxy;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.UsernamePasswordAuthenticationRequest;
import io.quarkus.vertx.http.runtime.AuthRuntimeConfig;
import io.quarkus.vertx.http.runtime.PolicyMappingConfig;
import io.quarkus.vertx.http.runtime.VertxHttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.VertxHttpConfig;
import io.quarkus.vertx.http.runtime.cors.CORSConfig;
import io.quarkus.vertx.http.runtime.options.HttpServerTlsConfig;
import io.quarkus.vertx.http.runtime.security.BasicAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.FormAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.HttpSecurityImpl;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.MtlsAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.RolesMapping;
import io.quarkus.vertx.http.security.CSRF;
import io.quarkus.vertx.http.security.HttpSecurity;
import io.smallrye.config.SmallRyeConfig;
import io.vertx.core.http.ClientAuth;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Instance;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public final class HttpSecurityConfiguration {
    private static final Logger LOG = Logger.getLogger(HttpSecurityConfiguration.class);
    private static volatile HttpSecurityConfiguration instance = null;
    private final RolesMapping rolesMapping;
    private final List<HttpPermissionCarrier> httpPermissions;
    private final Optional<Boolean> basicAuthEnabled;
    private final boolean formAuthEnabled;
    private final String formPostLocation;
    private final List<HttpAuthenticationMechanism> additionalMechanisms;
    private final VertxHttpConfig httpConfig;
    private final VertxHttpBuildTimeConfig httpBuildTimeConfig;
    private final CORSConfig corsConfig;
    private final CSRF csrf;

    private HttpSecurityConfiguration(RolesMapping rolesMapping, List<HttpPermissionCarrier> httpPermissions, Optional<Boolean> basicAuthEnabled, boolean formAuthEnabled, String formPostLocation, List<HttpAuthenticationMechanism> additionalMechanisms, VertxHttpConfig httpConfig, VertxHttpBuildTimeConfig httpBuildTimeConfig, CORSConfig corsConfig, CSRF csrf) {
        this.rolesMapping = rolesMapping;
        this.httpPermissions = httpPermissions;
        this.basicAuthEnabled = basicAuthEnabled;
        this.formAuthEnabled = formAuthEnabled;
        this.formPostLocation = formPostLocation;
        this.additionalMechanisms = additionalMechanisms;
        this.httpConfig = httpConfig;
        this.httpBuildTimeConfig = httpBuildTimeConfig;
        this.corsConfig = corsConfig;
        this.csrf = csrf;
    }

    BasicAuthenticationMechanism getBasicAuthenticationMechanism() {
        for (HttpAuthenticationMechanism additionalMechanism : this.additionalMechanisms) {
            if (additionalMechanism.getClass() != BasicAuthenticationMechanism.class) continue;
            return (BasicAuthenticationMechanism)additionalMechanism;
        }
        return new BasicAuthenticationMechanism(this.httpConfig.auth().realm().orElse(null), this.formAuthEnabled);
    }

    FormAuthenticationMechanism getFormAuthenticationMechanism() {
        for (HttpAuthenticationMechanism additionalMechanism : this.additionalMechanisms) {
            if (additionalMechanism.getClass() != FormAuthenticationMechanism.class) continue;
            return (FormAuthenticationMechanism)additionalMechanism;
        }
        return new FormAuthenticationMechanism(this.httpConfig.auth().form(), this.httpConfig.encryptionKey());
    }

    MtlsAuthenticationMechanism getMtlsAuthenticationMechanism() {
        if (ClientAuth.NONE.equals((Object)HttpServerTlsConfig.getTlsClientAuth(this.httpConfig, this.httpBuildTimeConfig, LaunchMode.current()))) {
            return null;
        }
        for (HttpAuthenticationMechanism additionalMechanism : this.additionalMechanisms) {
            if (additionalMechanism.getClass() != MtlsAuthenticationMechanism.class) continue;
            return (MtlsAuthenticationMechanism)additionalMechanism;
        }
        MtlsAuthenticationMechanism mTLS = (MtlsAuthenticationMechanism)Arc.container().select(MtlsAuthenticationMechanism.class, new Annotation[0]).orNull();
        if (mTLS == null) {
            throw new IllegalStateException("TLS client authentication mechanism is required but no HttpAuthenticationMechanism which supports it was found");
        }
        return mTLS;
    }

    HttpAuthenticationMechanism[] getMechanisms(Instance<IdentityProvider<?>> providers, boolean inclusiveAuth) {
        HttpAuthenticationMechanism[] result;
        InjectableInstance mechanismsFromCdi = Arc.container().select(HttpAuthenticationMechanism.class, new Annotation[0]);
        ArrayList<HttpAuthenticationMechanism> mechanisms = new ArrayList<HttpAuthenticationMechanism>();
        for (HttpAuthenticationMechanism mechanism : mechanismsFromCdi) {
            this.addAuthenticationMechanism(providers, mechanism, mechanisms);
        }
        for (HttpAuthenticationMechanism mechanism : this.additionalMechanisms) {
            this.addAuthenticationMechanism(providers, mechanism, mechanisms);
        }
        this.addBasicAuthMechanismIfImplicitlyRequired((Instance<HttpAuthenticationMechanism>)mechanismsFromCdi, mechanisms, providers);
        if (mechanisms.isEmpty()) {
            result = new HttpAuthenticationMechanism[]{new HttpAuthenticator.NoAuthenticationMechanism()};
        } else {
            HttpAuthenticationMechanism topMechanism;
            boolean isMutualTls;
            mechanisms.sort(new Comparator<HttpAuthenticationMechanism>(){

                @Override
                public int compare(HttpAuthenticationMechanism mech1, HttpAuthenticationMechanism mech2) {
                    return Integer.compare(mech2.getPriority(), mech1.getPriority());
                }
            });
            result = mechanisms.toArray(new HttpAuthenticationMechanism[mechanisms.size()]);
            if (inclusiveAuth && this.getMtlsAuthenticationMechanism() != null && !(isMutualTls = (topMechanism = (HttpAuthenticationMechanism)ClientProxy.unwrap((Object)result[0])) instanceof MtlsAuthenticationMechanism)) {
                throw new IllegalStateException("Inclusive authentication is enabled and '%s' does not have\nthe highest priority. Please lower priority of the '%s' authentication mechanism under '%s'.\n".formatted(MtlsAuthenticationMechanism.class.getName(), topMechanism.getClass().getName(), 3000));
            }
        }
        return result;
    }

    static HttpSecurityConfiguration get() {
        return HttpSecurityConfiguration.get(null, null);
    }

    static HttpSecurityConfiguration get(VertxHttpConfig httpConfig, VertxHttpBuildTimeConfig httpBuildTimeConfig) {
        HttpSecurityConfiguration configInstance = instance;
        if (configInstance == null) {
            return HttpSecurityConfiguration.initializeHttpSecurityConfiguration(httpConfig, httpBuildTimeConfig);
        }
        return configInstance;
    }

    static void clear() {
        instance = null;
        HttpServerTlsConfig.setConfiguration(new ProgrammaticTlsConfig(null, Optional.empty()));
    }

    private static synchronized HttpSecurityConfiguration initializeHttpSecurityConfiguration(VertxHttpConfig httpConfig, VertxHttpBuildTimeConfig httpBuildTimeConfig) {
        if (instance == null) {
            VertxHttpBuildTimeConfig vertxHttpBuildTimeConfig;
            VertxHttpConfig vertxHttpConfig;
            if (httpConfig == null) {
                SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
                vertxHttpConfig = (VertxHttpConfig)config.getConfigMapping(VertxHttpConfig.class);
                vertxHttpBuildTimeConfig = (VertxHttpBuildTimeConfig)config.getConfigMapping(VertxHttpBuildTimeConfig.class);
            } else {
                vertxHttpConfig = httpConfig;
                vertxHttpBuildTimeConfig = Objects.requireNonNull(httpBuildTimeConfig);
            }
            HttpSecurityImpl httpSecurity = HttpSecurityConfiguration.prepareHttpSecurity(vertxHttpConfig, vertxHttpBuildTimeConfig.tlsClientAuth());
            List<HttpAuthenticationMechanism> mechanisms = httpSecurity.getMechanisms();
            Optional<Boolean> basicAuthEnabled = vertxHttpBuildTimeConfig.auth().basic();
            if (basicAuthEnabled.isEmpty() || !basicAuthEnabled.get().booleanValue()) {
                for (HttpAuthenticationMechanism mechanism : mechanisms) {
                    if (mechanism.getClass() != BasicAuthenticationMechanism.class) continue;
                    basicAuthEnabled = Optional.of(Boolean.TRUE);
                    break;
                }
            }
            boolean formAuthEnabled = vertxHttpBuildTimeConfig.auth().form();
            String formPostLocation = vertxHttpConfig.auth().form().postLocation();
            if (!formAuthEnabled) {
                for (HttpAuthenticationMechanism mechanism : mechanisms) {
                    if (mechanism.getClass() != FormAuthenticationMechanism.class) continue;
                    formAuthEnabled = true;
                    formPostLocation = ((FormAuthenticationMechanism)mechanism).getPostLocation();
                    break;
                }
            }
            instance = new HttpSecurityConfiguration(httpSecurity.getRolesMapping(), httpSecurity.getHttpPermissions(), basicAuthEnabled, formAuthEnabled, formPostLocation, mechanisms, vertxHttpConfig, vertxHttpBuildTimeConfig, httpSecurity.getCorsConfig(), httpSecurity.getCsrf());
            HttpServerTlsConfig.setConfiguration(new ProgrammaticTlsConfig(httpSecurity.getClientAuth(), httpSecurity.getHttpServerTlsConfigName()));
        }
        return instance;
    }

    private static HttpSecurityImpl prepareHttpSecurity(VertxHttpConfig httpConfig, ClientAuth clientAuth) {
        HttpSecurityImpl httpSecurity = new HttpSecurityImpl(clientAuth, httpConfig, httpConfig.tlsConfigurationName());
        HttpSecurityConfiguration.addAuthRuntimeConfigToHttpSecurity(httpConfig.auth(), httpSecurity);
        Event httpSecurityEvent = Arc.container().beanManager().getEvent().select(HttpSecurity.class, new Annotation[0]);
        httpSecurityEvent.fire((Object)httpSecurity);
        return httpSecurity;
    }

    private static void addAuthRuntimeConfigToHttpSecurity(AuthRuntimeConfig authConfig, HttpSecurityImpl httpSecurity) {
        if (!authConfig.rolesMapping().isEmpty()) {
            httpSecurity.rolesMapping(authConfig.rolesMapping());
        }
        List<HttpPermissionCarrier> httpPermissions = HttpSecurityConfiguration.adaptToHttpPermissionCarriers(authConfig.permissions());
        httpSecurity.addHttpPermissions(httpPermissions);
    }

    static List<HttpPermissionCarrier> adaptToHttpPermissionCarriers(Map<String, PolicyMappingConfig> mappings) {
        ArrayList<HttpPermissionCarrier> httpPermissions = new ArrayList<HttpPermissionCarrier>();
        for (PolicyMappingConfig mappingConfig : mappings.values()) {
            HttpPermissionCarrier httpPermissionCarrier = HttpSecurityConfiguration.adaptToHttpPermissionCarrier(mappingConfig);
            if (httpPermissionCarrier == null) continue;
            httpPermissions.add(httpPermissionCarrier);
        }
        return httpPermissions;
    }

    private static HttpPermissionCarrier adaptToHttpPermissionCarrier(final PolicyMappingConfig mapping) {
        if (!mapping.enabled().orElse(true).booleanValue()) {
            return null;
        }
        if (mapping.paths().isEmpty() || mapping.paths().get().isEmpty()) {
            return null;
        }
        return new HttpPermissionCarrier(){

            @Override
            public Set<String> getPaths() {
                return Set.copyOf((Collection)mapping.paths().get());
            }

            @Override
            public boolean isShared() {
                return mapping.shared();
            }

            @Override
            public boolean shouldApplyToJaxRs() {
                return mapping.appliesTo() == PolicyMappingConfig.AppliesTo.JAXRS;
            }

            @Override
            public Set<String> getMethods() {
                if (mapping.methods().isEmpty()) {
                    return Set.of();
                }
                return Set.copyOf((Collection)mapping.methods().get());
            }

            @Override
            public AuthenticationMechanism getAuthMechanism() {
                String authMech;
                if (mapping.authMechanism().isPresent() && !(authMech = mapping.authMechanism().get()).isEmpty()) {
                    return new AuthenticationMechanism(authMech, null);
                }
                return null;
            }

            @Override
            public Policy getPolicy() {
                return new Policy(mapping.policy(), null);
            }

            @Override
            public PolicyMappingConfig.AppliesTo getAppliesTo() {
                return mapping.appliesTo();
            }
        };
    }

    private void addAuthenticationMechanism(Instance<IdentityProvider<?>> providers, HttpAuthenticationMechanism mechanism, List<HttpAuthenticationMechanism> mechanisms) {
        if (mechanism.getCredentialTypes().isEmpty()) {
            LOG.debugf("HttpAuthenticationMechanism '%s' provided no required credential types, therefore it needs to be able to perform authentication without any IdentityProvider", (Object)mechanism.getClass().getName());
            mechanisms.add(mechanism);
            return;
        }
        boolean found = false;
        for (Class<? extends AuthenticationRequest> mechType : mechanism.getCredentialTypes()) {
            for (IdentityProvider i : providers) {
                if (!i.getRequestType().equals(mechType)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            break;
        }
        if (found) {
            mechanisms.add(mechanism);
        } else if (BasicAuthenticationMechanism.class.equals(mechanism.getClass()) && this.basicAuthEnabled.isEmpty()) {
            LOG.debug((Object)"BasicAuthenticationMechanism has been enabled because no other authentication mechanism has been\ndetected, but there is no IdentityProvider based on username and password. Please use\none of supported extensions if you plan to use the mechanism.\nFor more information go to the https://quarkus.io/guides/security-basic-authentication-howto.\n");
        } else {
            throw new RuntimeException("HttpAuthenticationMechanism '%s' requires one or more IdentityProviders supporting at least one\nof the following credentials types: %s.\nPlease refer to the https://quarkus.io/guides/security-identity-providers for more information.\n".formatted(mechanism.getClass().getName(), mechanism.getCredentialTypes()));
        }
    }

    private void addBasicAuthMechanismIfImplicitlyRequired(Instance<HttpAuthenticationMechanism> httpAuthenticationMechanism, List<HttpAuthenticationMechanism> mechanisms, Instance<IdentityProvider<?>> providers) {
        if (this.basicAuthEnabled.orElse(Boolean.FALSE).booleanValue()) {
            return;
        }
        if (!Boolean.getBoolean("io.quarkus.security.http.test-if-basic-auth-implicitly-required") || this.isBasicAuthNotRequired()) {
            return;
        }
        Instance basicAuthMechInstance = httpAuthenticationMechanism.select(BasicAuthenticationMechanism.class, new Annotation[0]);
        if (basicAuthMechInstance.isResolvable() && !mechanisms.contains(basicAuthMechInstance.get())) {
            for (IdentityProvider i : providers) {
                if (!UsernamePasswordAuthenticationRequest.class.equals((Object)i.getRequestType())) continue;
                mechanisms.add((HttpAuthenticationMechanism)basicAuthMechInstance.get());
                return;
            }
            LOG.debug((Object)"BasicAuthenticationMechanism has been enabled because no custom authentication mechanism has been detected\nand basic authentication is required either by the HTTP Security Policy or '@BasicAuthentication', but\nthere is no IdentityProvider based on username and password. Please use one of supported extensions.\nFor more information, go to the https://quarkus.io/guides/security-basic-authentication-howto.\n");
        }
    }

    private boolean isBasicAuthNotRequired() {
        if (Boolean.getBoolean("io.quarkus.security.http.basic-authentication-annotation-detected")) {
            return false;
        }
        for (HttpPermissionCarrier permission : this.httpPermissions) {
            if (permission.getAuthMechanism() == null || !"basic".equals(permission.getAuthMechanism().name())) continue;
            return false;
        }
        return true;
    }

    RolesMapping rolesMapping() {
        return this.rolesMapping;
    }

    List<HttpPermissionCarrier> httpPermissions() {
        return this.httpPermissions;
    }

    boolean formAuthEnabled() {
        return this.formAuthEnabled;
    }

    String formPostLocation() {
        return this.formPostLocation;
    }

    CORSConfig getCorsConfig() {
        return this.corsConfig;
    }

    public static boolean isNotReady(VertxHttpConfig httpConfig, VertxHttpBuildTimeConfig httpBuildTimeConfig, LaunchMode launchMode) {
        if (instance != null) {
            return false;
        }
        ArcContainer container = Arc.container();
        if (container == null) {
            if (launchMode == LaunchMode.DEVELOPMENT) {
                return true;
            }
            throw new IllegalStateException("CDI container is not available, cannot initialize HTTP Security configuration");
        }
        if (HttpSecurityConfiguration.isHttpSecurityEventNotObserved(container)) {
            return false;
        }
        HttpSecurityConfiguration.get(httpConfig, httpBuildTimeConfig);
        return false;
    }

    public static CSRF getProgrammaticCsrfConfig(VertxHttpConfig httpConfig, VertxHttpBuildTimeConfig httpBuildTimeConfig) {
        ArcContainer container = Arc.container();
        if (container == null || HttpSecurityConfiguration.isHttpSecurityEventNotObserved(container)) {
            return null;
        }
        return HttpSecurityConfiguration.get((VertxHttpConfig)httpConfig, (VertxHttpBuildTimeConfig)httpBuildTimeConfig).csrf;
    }

    private static boolean isHttpSecurityEventNotObserved(ArcContainer container) {
        return container.beanManager().resolveObserverMethods((Object)new HttpSecurityImpl(null, null, Optional.empty()), new Annotation[0]).isEmpty();
    }

    public static final class ProgrammaticTlsConfig {
        public final ClientAuth tlsClientAuth;
        public final Optional<String> tlsConfigName;

        private ProgrammaticTlsConfig(ClientAuth tlsClientAuth, Optional<String> tlsConfigName) {
            this.tlsClientAuth = tlsClientAuth;
            this.tlsConfigName = Objects.requireNonNull(tlsConfigName);
        }
    }

    static interface HttpPermissionCarrier {
        public Set<String> getPaths();

        public boolean isShared();

        public boolean shouldApplyToJaxRs();

        public Set<String> getMethods();

        public AuthenticationMechanism getAuthMechanism();

        public Policy getPolicy();

        default public PolicyMappingConfig.AppliesTo getAppliesTo() {
            return this.shouldApplyToJaxRs() ? PolicyMappingConfig.AppliesTo.JAXRS : PolicyMappingConfig.AppliesTo.ALL;
        }
    }

    record AuthenticationMechanism(String name, HttpAuthenticationMechanism instance) {
    }

    record Policy(String name, HttpSecurityPolicy instance) {
    }
}

