/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.undertow.deployment.MPConfigPropertyResolver;
import io.quarkus.undertow.deployment.WebMetadataBuildItem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.merge.web.spec.WebCommonMetaDataMerger;
import org.jboss.metadata.parser.servlet.WebFragmentMetaDataParser;
import org.jboss.metadata.parser.servlet.WebMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.parser.util.NoopXMLResolver;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.property.PropertyReplacers;
import org.jboss.metadata.property.PropertyResolver;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.metadata.web.spec.WebCommonMetaData;
import org.jboss.metadata.web.spec.WebFragmentMetaData;
import org.jboss.metadata.web.spec.WebMetaData;

public class WebXmlParsingBuildStep {
    public static final String WEB_XML = "META-INF/web.xml";
    private static final String WEB_FRAGMENT_XML = "META-INF/web-fragment.xml";

    @BuildStep
    List<HotDeploymentWatchedFileBuildItem> configFile() {
        return Arrays.asList(new HotDeploymentWatchedFileBuildItem(WEB_XML), new HotDeploymentWatchedFileBuildItem(WEB_FRAGMENT_XML));
    }

    @BuildStep
    AdditionalApplicationArchiveMarkerBuildItem marker() {
        return new AdditionalApplicationArchiveMarkerBuildItem(WEB_FRAGMENT_XML);
    }

    @BuildStep
    WebMetadataBuildItem createWebMetadata(ApplicationArchivesBuildItem applicationArchivesBuildItem, Consumer<AdditionalBeanBuildItem> additionalBeanBuildItemConsumer) throws Exception {
        WebMetaData result;
        Path webXml = applicationArchivesBuildItem.getRootArchive().getChildPath(WEB_XML);
        if (webXml != null) {
            HashSet<String> additionalBeans = new HashSet<String>();
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            MetaDataElementParser.DTDInfo dtdInfo = new MetaDataElementParser.DTDInfo();
            inputFactory.setXMLResolver((XMLResolver)dtdInfo);
            try (InputStream in = Files.newInputStream(webXml, new OpenOption[0]);){
                XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(in);
                result = WebMetaDataParser.parse((XMLStreamReader)xmlReader, (MetaDataElementParser.DTDInfo)dtdInfo, (PropertyReplacer)PropertyReplacers.resolvingReplacer((PropertyResolver)new MPConfigPropertyResolver()));
            }
            if (result.getServlets() != null) {
                for (ServletMetaData i : result.getServlets()) {
                    additionalBeans.add(i.getServletClass());
                }
            }
            if (result.getFilters() != null) {
                for (ServletMetaData i : result.getFilters()) {
                    additionalBeans.add(i.getFilterClass());
                }
            }
            if (result.getListeners() != null) {
                for (ServletMetaData i : result.getListeners()) {
                    additionalBeans.add(i.getListenerClass());
                }
            }
            additionalBeanBuildItemConsumer.accept(AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(additionalBeans).build());
        } else {
            result = new WebMetaData();
        }
        Set<WebFragmentMetaData> webFragments = this.parseWebFragments(applicationArchivesBuildItem);
        for (WebFragmentMetaData webFragment : webFragments) {
            WebCommonMetaDataMerger.augment((WebCommonMetaData)result, (WebCommonMetaData)webFragment, null, (boolean)false);
        }
        return new WebMetadataBuildItem(result);
    }

    private Set<WebFragmentMetaData> parseWebFragments(ApplicationArchivesBuildItem applicationArchivesBuildItem) {
        LinkedHashSet<WebFragmentMetaData> webFragments = new LinkedHashSet<WebFragmentMetaData>();
        for (ApplicationArchive archive : applicationArchivesBuildItem.getAllApplicationArchives()) {
            Path webFragment = archive.getChildPath(WEB_FRAGMENT_XML);
            if (webFragment == null || !Files.isRegularFile(webFragment, new LinkOption[0])) continue;
            try {
                InputStream is = Files.newInputStream(webFragment, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                    inputFactory.setXMLResolver(NoopXMLResolver.create());
                    XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
                    WebFragmentMetaData webFragmentMetaData = WebFragmentMetaDataParser.parse((XMLStreamReader)xmlReader, (PropertyReplacer)PropertyReplacers.resolvingReplacer((PropertyResolver)new MPConfigPropertyResolver()));
                    webFragments.add(webFragmentMetaData);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Failed to parse " + webFragment + " " + e.getLocation(), e);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to parse " + webFragment, e);
            }
        }
        return webFragments;
    }
}

