/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.util.Map;
import org.jboss.logging.Logger;
import org.junit.platform.commons.util.AnnotationUtils;

public class ClearCache {
    private static final Logger log = Logger.getLogger(ClearCache.class);

    public static void clearCaches() {
        ClearCache.clearAnnotationCache();
        ClearCache.clearResourceManagerPropertiesCache();
        ClearCache.clearBeansIntrospectorCache();
    }

    private static void clearAnnotationCache() {
        ClearCache.clearMap(AnnotationUtils.class, "repeatableAnnotationContainerCache");
    }

    private static void clearResourceManagerPropertiesCache() {
        try {
            ClearCache.clearMap(Class.forName("com.sun.naming.internal.ResourceManager"), "propertiesCache");
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)"Unable to load com.sun.naming.internal.ResourceManager", (Throwable)e);
        }
    }

    private static void clearBeansIntrospectorCache() {
        try {
            Introspector.flushCaches();
        }
        catch (Exception e) {
            log.debug((Object)"Failed to clear java.beans.Introspector cache", (Throwable)e);
        }
    }

    private static void clearMap(Class<?> clazz, String mapField) {
        try {
            Field f = clazz.getDeclaredField(mapField);
            f.setAccessible(true);
            ((Map)f.get(null)).clear();
        }
        catch (Exception e) {
            log.debugf((Throwable)e, "Failed to clear cache for %s#%s cache", (Object)clazz.getName(), (Object)mapField);
        }
    }
}

