/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway;

import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.agroal.spi.JdbcDataSourceSchemaReadyBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.flyway.FlywayDataSource;
import io.quarkus.flyway.runtime.FlywayBuildTimeConfig;
import io.quarkus.flyway.runtime.FlywayContainerProducer;
import io.quarkus.flyway.runtime.FlywayRecorder;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.migration.JavaMigration;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

class FlywayProcessor {
    private static final String CLASSPATH_APPLICATION_MIGRATIONS_PROTOCOL = "classpath";
    private static final String JAR_APPLICATION_MIGRATIONS_PROTOCOL = "jar";
    private static final String FILE_APPLICATION_MIGRATIONS_PROTOCOL = "file";
    private static final String FLYWAY_BEAN_NAME_PREFIX = "flyway_";
    private static final DotName JAVA_MIGRATION = DotName.createSimple((String)JavaMigration.class.getName());
    private static final Logger LOGGER = Logger.getLogger(FlywayProcessor.class);
    FlywayBuildTimeConfig flywayBuildConfig;

    FlywayProcessor() {
    }

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem(Capability.FLYWAY);
    }

    @BuildStep
    IndexDependencyBuildItem indexFlyway() {
        return new IndexDependencyBuildItem("org.flywaydb", "flyway-core");
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void build(BuildProducer<FeatureBuildItem> featureProducer, BuildProducer<NativeImageResourceBuildItem> resourceProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, FlywayRecorder recorder, RecorderContext context, CombinedIndexBuildItem combinedIndexBuildItem, List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems) throws IOException, URISyntaxException {
        featureProducer.produce((BuildItem)new FeatureBuildItem(Feature.FLYWAY));
        Set<String> dataSourceNames = this.getDataSourceNames(jdbcDataSourceBuildItems);
        Collection<String> applicationMigrations = this.discoverApplicationMigrations(this.getMigrationLocations(dataSourceNames));
        recorder.setApplicationMigrationFiles(applicationMigrations);
        HashSet<Class<? extends JavaMigration>> javaMigrationClasses = new HashSet<Class<? extends JavaMigration>>();
        this.addJavaMigrations(combinedIndexBuildItem.getIndex().getAllKnownImplementors(JAVA_MIGRATION), context, reflectiveClassProducer, javaMigrationClasses);
        recorder.setApplicationMigrationClasses(javaMigrationClasses);
        resourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(applicationMigrations.toArray(new String[0])));
    }

    private void addJavaMigrations(Collection<ClassInfo> candidates, RecorderContext context, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, Set<Class<? extends JavaMigration>> javaMigrationClasses) {
        for (ClassInfo javaMigration : candidates) {
            if (Modifier.isAbstract(javaMigration.flags())) continue;
            javaMigrationClasses.add(context.classProxy(javaMigration.name().toString()));
            reflectiveClassProducer.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{javaMigration.name().toString()}));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ServiceStartBuildItem createBeansAndStartActions(FlywayRecorder recorder, List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, BuildProducer<JdbcDataSourceSchemaReadyBuildItem> schemaReadyBuildItem) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{FlywayContainerProducer.class}).setUnremovable().setDefaultScope(DotNames.SINGLETON).build());
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(FlywayDataSource.class).build());
        Set<String> dataSourceNames = this.getDataSourceNames(jdbcDataSourceBuildItems);
        for (String dataSourceName : dataSourceNames) {
            SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(Flyway.class).scope(Dependent.class)).setRuntimeInit().unremovable()).supplier(recorder.flywaySupplier(dataSourceName));
            if (DataSourceUtil.isDefault((String)dataSourceName)) {
                configurator.addQualifier(Default.class);
            } else {
                String beanName = FLYWAY_BEAN_NAME_PREFIX + dataSourceName;
                configurator.name(beanName);
                configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)beanName).done();
                configurator.addQualifier().annotation(FlywayDataSource.class).addValue("value", (Object)dataSourceName).done();
            }
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)configurator.done());
        }
        recorder.doStartActions();
        schemaReadyBuildItem.produce((BuildItem)new JdbcDataSourceSchemaReadyBuildItem(dataSourceNames));
        return new ServiceStartBuildItem("flyway");
    }

    private Set<String> getDataSourceNames(List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems) {
        HashSet<String> result = new HashSet<String>(jdbcDataSourceBuildItems.size());
        for (JdbcDataSourceBuildItem item : jdbcDataSourceBuildItems) {
            result.add(item.getName());
        }
        return result;
    }

    private Collection<String> getMigrationLocations(Collection<String> dataSourceNames) {
        Collection migrationLocations = dataSourceNames.stream().map(arg_0 -> ((FlywayBuildTimeConfig)this.flywayBuildConfig).getConfigForDataSourceName(arg_0)).flatMap(config -> config.locations.stream()).collect(Collectors.toCollection(LinkedHashSet::new));
        if (DataSourceUtil.hasDefault(dataSourceNames)) {
            migrationLocations.addAll(this.flywayBuildConfig.defaultDataSource.locations);
        }
        return migrationLocations;
    }

    private Collection<String> discoverApplicationMigrations(Collection<String> locations) throws IOException, URISyntaxException {
        LinkedHashSet<String> applicationMigrationResources = new LinkedHashSet<String>();
        for (String location : locations) {
            location = this.normalizeLocation(location);
            Enumeration<URL> migrations = Thread.currentThread().getContextClassLoader().getResources(location);
            while (migrations.hasMoreElements()) {
                Set<String> applicationMigrations;
                URL path = migrations.nextElement();
                LOGGER.infov("Adding application migrations in path ''{0}'' using protocol ''{1}''", (Object)path.getPath(), (Object)path.getProtocol());
                if (JAR_APPLICATION_MIGRATIONS_PROTOCOL.equals(path.getProtocol())) {
                    try (FileSystem fileSystem = this.initFileSystem(path.toURI());){
                        applicationMigrations = this.getApplicationMigrationsFromPath(location, path);
                    }
                } else if (FILE_APPLICATION_MIGRATIONS_PROTOCOL.equals(path.getProtocol())) {
                    applicationMigrations = this.getApplicationMigrationsFromPath(location, path);
                } else {
                    LOGGER.warnv("Unsupported URL protocol ''{0}'' for path ''{1}''. Migration files will not be discovered.", (Object)path.getProtocol(), (Object)path.getPath());
                    applicationMigrations = null;
                }
                if (applicationMigrations == null) continue;
                applicationMigrationResources.addAll(applicationMigrations);
            }
        }
        return applicationMigrationResources;
    }

    private String normalizeLocation(String location) {
        if (location == null) {
            throw new IllegalStateException("Flyway migration location may not be null.");
        }
        if (location.startsWith("classpath:") && (location = location.substring(CLASSPATH_APPLICATION_MIGRATIONS_PROTOCOL.length() + 1)).startsWith("/")) {
            location = location.substring(1);
        }
        if (!location.endsWith("/")) {
            location = location + "/";
        }
        return location;
    }

    private Set<String> getApplicationMigrationsFromPath(String location, URL path) throws IOException, URISyntaxException {
        Path rootPath = Paths.get(path.toURI());
        try (Stream<Path> pathStream = Files.walk(rootPath, new FileVisitOption[0]);){
            Set<String> set = pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(it -> Paths.get(location, rootPath.relativize((Path)it).toString()).normalize().toString()).map(it -> it.replace('\\', '/')).peek(it -> LOGGER.debugf("Discovered path: %s", it)).collect(Collectors.toSet());
            return set;
        }
    }

    private FileSystem initFileSystem(URI uri) throws IOException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        return FileSystems.newFileSystem(uri, env);
    }
}

