/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.jar;

import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedNativeImageClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageSourceJarBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.jar.AbstractLegacyThinJarBuilder;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class NativeImageSourceJarBuilder
extends AbstractLegacyThinJarBuilder<NativeImageSourceJarBuildItem> {
    private static final Logger LOG = Logger.getLogger(NativeImageSourceJarBuilder.class);

    public NativeImageSourceJarBuilder(CurateOutcomeBuildItem curateOutcome, OutputTargetBuildItem outputTarget, ApplicationInfoBuildItem applicationInfo, PackageConfig packageConfig, MainClassBuildItem mainClass, ApplicationArchivesBuildItem applicationArchives, TransformedClassesBuildItem transformedClasses, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, List<GeneratedNativeImageClassBuildItem> nativeImageResources, Set<ArtifactKey> removedArtifactKeys, ExecutorService executorService) {
        super(curateOutcome, outputTarget, applicationInfo, packageConfig, mainClass, applicationArchives, transformedClasses, NativeImageSourceJarBuilder.augmentGeneratedClasses(generatedClasses, nativeImageResources), generatedResources, NativeImageSourceJarBuilder.augmentRemovedArtifactKeys(removedArtifactKeys), executorService);
    }

    @Override
    public NativeImageSourceJarBuildItem build() throws IOException {
        Path targetDirectory = this.outputTarget.getOutputDirectory().resolve(this.outputTarget.getBaseName() + "-native-image-source-jar");
        IoUtils.createOrEmptyDir((Path)targetDirectory);
        Path runnerJar = targetDirectory.resolve(this.outputTarget.getBaseName() + this.packageConfig.computedRunnerSuffix() + ".jar");
        Path libDir = targetDirectory.resolve("lib");
        Files.createDirectories(libDir, new FileAttribute[0]);
        NativeImageSourceJarBuilder.copyJsonConfigFiles(this.applicationArchives, targetDirectory);
        if (this.curateOutcome.getApplicationModel().getDependencies().stream().anyMatch(d -> d.getGroupId().equals("org.graalvm.sdk") && d.getArtifactId().equals("graal-sdk"))) {
            LOG.warn((Object)"org.graalvm.sdk:graal-sdk is present in the classpath. From Quarkus 3.8 and onwards, org.graalvm.sdk:nativeimage should be preferred. Make sure you report the issue to the maintainers of the extensions that bring it.");
        }
        LOG.info((Object)("Building native image source jar: " + String.valueOf(runnerJar)));
        this.doBuild(runnerJar, libDir);
        return new NativeImageSourceJarBuildItem(runnerJar, libDir);
    }

    private static List<GeneratedClassBuildItem> augmentGeneratedClasses(List<GeneratedClassBuildItem> generatedClasses, List<GeneratedNativeImageClassBuildItem> nativeImageResources) {
        ArrayList<GeneratedClassBuildItem> allGeneratedClasses = new ArrayList<GeneratedClassBuildItem>(generatedClasses);
        allGeneratedClasses.addAll(nativeImageResources.stream().map(s -> new GeneratedClassBuildItem(true, s.getName(), s.getClassData())).toList());
        return allGeneratedClasses;
    }

    private static Set<ArtifactKey> augmentRemovedArtifactKeys(Set<ArtifactKey> removedArtifactKeys) {
        HashSet<ArtifactKey> allRemovedArtifactKeys = new HashSet<ArtifactKey>(removedArtifactKeys);
        allRemovedArtifactKeys.add((ArtifactKey)GACT.fromString((String)"org.graalvm.nativeimage:svm"));
        allRemovedArtifactKeys.add((ArtifactKey)GACT.fromString((String)"org.graalvm.sdk:graal-sdk"));
        allRemovedArtifactKeys.add((ArtifactKey)GACT.fromString((String)"org.graalvm.sdk:nativeimage"));
        allRemovedArtifactKeys.add((ArtifactKey)GACT.fromString((String)"org.graalvm.sdk:word"));
        allRemovedArtifactKeys.add((ArtifactKey)GACT.fromString((String)"org.graalvm.sdk:collections"));
        return allRemovedArtifactKeys;
    }

    private static void copyJsonConfigFiles(ApplicationArchivesBuildItem applicationArchivesBuildItem, final Path thinJarDirectory) throws IOException {
        for (Path root : applicationArchivesBuildItem.getRootArchive().getRootDirectories()) {
            Stream<Path> stream = Files.find(root, 1, IsJsonFilePredicate.INSTANCE, new FileVisitOption[0]);
            try {
                stream.forEach(new Consumer<Path>(){

                    @Override
                    public void accept(Path jsonPath) {
                        try {
                            Files.createDirectories(thinJarDirectory, new FileAttribute[0]);
                            Files.copy(jsonPath, thinJarDirectory.resolve(jsonPath.getFileName().toString()), new CopyOption[0]);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException("Unable to copy json config file from " + String.valueOf(jsonPath) + " to " + String.valueOf(thinJarDirectory), e);
                        }
                    }
                });
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
    }

    private static class IsJsonFilePredicate
    implements BiPredicate<Path, BasicFileAttributes> {
        private static final BiPredicate<Path, BasicFileAttributes> INSTANCE = new IsJsonFilePredicate();

        private IsJsonFilePredicate() {
        }

        @Override
        public boolean test(Path path, BasicFileAttributes basicFileAttributes) {
            return basicFileAttributes.isRegularFile() && path.toString().endsWith(".json");
        }
    }
}

