/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.SslNativeConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.Optional;

public class SslProcessor {
    private static final String JAVA_11_PLUS_SSL_LOGGER = "sun.security.ssl.SSLLogger";
    private static final String JAVA_8_PLUS_SSL_LOGGER = "sun.security.ssl.Debug";
    SslConfig ssl;

    @BuildStep
    SslNativeConfigBuildItem setupNativeSsl() {
        return new SslNativeConfigBuildItem(this.ssl.native_);
    }

    @BuildStep
    void runtime(BuildProducer<RuntimeReinitializedClassBuildItem> reinitialized) {
        this.registerIfExists(reinitialized, JAVA_11_PLUS_SSL_LOGGER);
        this.registerIfExists(reinitialized, JAVA_8_PLUS_SSL_LOGGER);
    }

    private void registerIfExists(BuildProducer<RuntimeReinitializedClassBuildItem> reinitialized, String className) {
        try {
            Class.forName(className);
            reinitialized.produce(new RuntimeReinitializedClassBuildItem(className));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @ConfigRoot(phase=ConfigPhase.BUILD_TIME)
    static class SslConfig {
        @ConfigItem(name="native")
        Optional<Boolean> native_;

        SslConfig() {
        }
    }
}

