/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.paths;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ManifestAttributes {
    private final String specificationTitle;
    private final String specificationVersion;
    private final String specificationVendor;
    private final String implementationTitle;
    private final String implementationVersion;
    private final String implementationVendor;
    private final boolean multiRelease;
    private final String automaticModuleName;
    private final String mainClassName;
    private final Map<String, Set<String>> addExports;
    private final Map<String, Set<String>> addOpens;
    private final boolean enableNativeAccess;

    public static ManifestAttributes of(Manifest manifest) {
        if (manifest == null) {
            return null;
        }
        return new ManifestAttributes(manifest);
    }

    private ManifestAttributes(Manifest manifest) {
        this.specificationTitle = manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_TITLE);
        this.specificationVersion = manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VERSION);
        this.specificationVendor = manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VENDOR);
        this.implementationTitle = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        this.implementationVersion = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        this.implementationVendor = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        this.multiRelease = Boolean.parseBoolean(manifest.getMainAttributes().getValue(Attributes.Name.MULTI_RELEASE));
        this.automaticModuleName = manifest.getMainAttributes().getValue("Automatic-Module-Name");
        this.mainClassName = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
        this.addExports = ManifestAttributes.parseAccess(manifest.getMainAttributes().getValue("Add-Exports"));
        this.addOpens = ManifestAttributes.parseAccess(manifest.getMainAttributes().getValue("Add-Opens"));
        this.enableNativeAccess = "ALL-UNNAMED".equals(manifest.getMainAttributes().getValue("Enable-Native-Access"));
    }

    private static Map<String, Set<String>> parseAccess(String value) {
        if (value == null || value.isEmpty()) {
            return Map.of();
        }
        HashMap<String, Set> result = new HashMap<String, Set>();
        for (String item : value.split("\\s+")) {
            int idx;
            if ((item = item.trim()).isEmpty() || (idx = item.indexOf(47)) == -1) continue;
            result.computeIfAbsent(item.substring(0, idx), ManifestAttributes::newHashSet).add(item.substring(idx + 1));
        }
        result.replaceAll((key, set) -> Set.copyOf(set));
        return Map.copyOf(result);
    }

    private static <E> HashSet<E> newHashSet(Object ignored) {
        return new HashSet();
    }

    public String getSpecificationTitle() {
        return this.specificationTitle;
    }

    public String getSpecificationVersion() {
        return this.specificationVersion;
    }

    public String getSpecificationVendor() {
        return this.specificationVendor;
    }

    public String getImplementationTitle() {
        return this.implementationTitle;
    }

    public String getImplementationVersion() {
        return this.implementationVersion;
    }

    public String getImplementationVendor() {
        return this.implementationVendor;
    }

    public boolean isMultiRelease() {
        return this.multiRelease;
    }

    public String automaticModuleName() {
        return this.automaticModuleName;
    }

    public String mainClassName() {
        return this.mainClassName;
    }

    public Map<String, Set<String>> addExports() {
        return this.addExports;
    }

    public Map<String, Set<String>> addOpens() {
        return this.addOpens;
    }

    public boolean enableNativeAccess() {
        return this.enableNativeAccess;
    }
}

