/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.dependency;

import io.quarkus.bootstrap.model.Mappable;
import io.quarkus.bootstrap.model.MappableCollectionFactory;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.maven.dependency.AbstractDependencyBuilder;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactDependency;
import io.quarkus.maven.dependency.ResolvedArtifactDependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ResolvedDependencyBuilder
extends AbstractDependencyBuilder<ResolvedDependencyBuilder, ResolvedDependency>
implements ResolvedDependency {
    PathCollection resolvedPaths;
    WorkspaceModule workspaceModule;
    private volatile ArtifactCoords coords;
    private Collection<ArtifactCoords> deps = Set.of();

    static void putInMap(ResolvedDependency dependency, Map<String, Object> map, MappableCollectionFactory factory) {
        ArtifactDependency.putInMap(dependency, map, factory);
        map.put("resolved-paths", Mappable.iterableToStringCollection(dependency.getResolvedPaths(), factory));
        Collection<ArtifactCoords> deps = dependency.getDependencies();
        if (!deps.isEmpty()) {
            map.put("dependencies", Mappable.toStringCollection(deps, ArtifactCoords::toGACTVString, factory));
        }
        if (dependency.getWorkspaceModule() != null) {
            map.put("module", dependency.getWorkspaceModule().asMap(factory));
        }
    }

    public static ResolvedDependencyBuilder newInstance() {
        return new ResolvedDependencyBuilder();
    }

    @Override
    public ResolvedDependencyBuilder fromMap(Map<String, Object> map) {
        Map moduleMap;
        super.fromMap(map);
        Collection resolvedPathsStr = (Collection)map.get("resolved-paths");
        Path[] pathArr = new Path[resolvedPathsStr.size()];
        int i = 0;
        for (String pathStr : resolvedPathsStr) {
            pathArr[i++] = Path.of(pathStr, new String[0]);
        }
        this.setResolvedPaths(PathList.of(pathArr));
        Collection depsStr = (Collection)map.get("dependencies");
        if (depsStr != null) {
            ArrayList<ArtifactCoords> deps = new ArrayList<ArtifactCoords>(depsStr.size());
            for (String depStr : depsStr) {
                deps.add(ArtifactCoords.fromString(depStr));
            }
            this.setDependencies(deps);
        }
        if ((moduleMap = (Map)map.get("module")) != null) {
            this.setWorkspaceModule(WorkspaceModule.builder().fromMap(moduleMap).build());
        }
        return this;
    }

    @Override
    public PathCollection getResolvedPaths() {
        return this.resolvedPaths;
    }

    public ResolvedDependencyBuilder setResolvedPath(Path path) {
        this.resolvedPaths = path == null ? null : PathList.of(path);
        return this;
    }

    public ResolvedDependencyBuilder setResolvedPaths(PathCollection resolvedPaths) {
        this.resolvedPaths = resolvedPaths;
        return this;
    }

    @Override
    public WorkspaceModule getWorkspaceModule() {
        return this.workspaceModule;
    }

    public ResolvedDependencyBuilder setWorkspaceModule(WorkspaceModule projectModule) {
        this.workspaceModule = projectModule;
        if (projectModule != null) {
            this.setWorkspaceModule();
        }
        return this;
    }

    public ArtifactCoords getArtifactCoords() {
        return this.coords == null ? (this.coords = ArtifactCoords.of(this.groupId, this.artifactId, this.classifier, this.type, this.version)) : this.coords;
    }

    public ResolvedDependencyBuilder addDependency(ArtifactCoords coords) {
        if (coords != null) {
            if (this.deps.isEmpty()) {
                this.deps = new HashSet<ArtifactCoords>();
            }
            this.deps.add(coords);
        }
        return this;
    }

    public ResolvedDependencyBuilder addDependencies(Collection<ArtifactCoords> deps) {
        if (!deps.isEmpty()) {
            if (this.deps.isEmpty()) {
                this.deps = new HashSet<ArtifactCoords>(deps);
            } else {
                this.deps.addAll(deps);
            }
        }
        return this;
    }

    public ResolvedDependencyBuilder setDependencies(Collection<ArtifactCoords> deps) {
        this.deps = deps;
        return this;
    }

    @Override
    public Collection<ArtifactCoords> getDependencies() {
        return this.deps;
    }

    @Override
    public ResolvedDependency build() {
        return new ResolvedArtifactDependency(this);
    }

    @Override
    public Map<String, Object> asMap(MappableCollectionFactory factory) {
        Map<String, Object> map = factory.newMap(7);
        ResolvedDependencyBuilder.putInMap(this, map, factory);
        return map;
    }
}

