/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.MemoryOrder;
import io.quarkus.gizmo2.impl.ArrayCompareAndExchange;
import io.quarkus.gizmo2.impl.ArrayCompareAndSet;
import io.quarkus.gizmo2.impl.ArrayLoadViaHandle;
import io.quarkus.gizmo2.impl.ArrayReadModifyWrite;
import io.quarkus.gizmo2.impl.ArrayStore;
import io.quarkus.gizmo2.impl.ArrayStoreViaHandle;
import io.quarkus.gizmo2.impl.AssignableImpl;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Conversions;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.Util;
import java.lang.constant.ConstantDescs;
import java.util.ListIterator;
import java.util.function.BiConsumer;

public final class ArrayDeref
extends AssignableImpl {
    private final Item item;
    private final Item index;
    private boolean bound;

    ArrayDeref(Item item, Expr index) {
        this.item = item;
        this.index = Conversions.convert(index, ConstantDescs.CD_int);
    }

    @Override
    protected void forEachDependency(ListIterator<Item> itr, BiConsumer<Item, ListIterator<Item>> op) {
        this.index.process(itr, op);
        this.item.process(itr, op);
    }

    public Item array() {
        return this.item;
    }

    public Item index() {
        return this.index;
    }

    @Override
    Item emitCompareAndExchange(BlockCreatorImpl block, Item expect, Item update, MemoryOrder order) {
        return new ArrayCompareAndExchange(this, expect, update, order);
    }

    @Override
    Item emitCompareAndSet(BlockCreatorImpl block, Item expect, Item update, boolean weak, MemoryOrder order) {
        return new ArrayCompareAndSet(this, expect, update, weak, order);
    }

    @Override
    Item emitReadModifyWrite(BlockCreatorImpl block, String op, Item newVal, MemoryOrder order) {
        return new ArrayReadModifyWrite(this, op, newVal, order);
    }

    @Override
    Item emitGet(BlockCreatorImpl block, MemoryOrder mode) {
        if (!mode.validForReads()) {
            throw new IllegalArgumentException("Invalid mode " + String.valueOf((Object)mode));
        }
        return switch (mode) {
            case MemoryOrder.AsDeclared, MemoryOrder.Plain -> this.asBound();
            default -> new ArrayLoadViaHandle(this, mode);
        };
    }

    @Override
    Item emitSet(BlockCreatorImpl block, Item value, MemoryOrder mode) {
        return switch (mode) {
            case MemoryOrder.AsDeclared, MemoryOrder.Plain -> new ArrayStore(this.item, this.index, value, this.type());
            default -> new ArrayStoreViaHandle(this, value, mode);
        };
    }

    @Override
    protected void computeType() {
        this.initType(this.item.type().componentType());
        if (this.item.hasGenericType()) {
            this.initGenericType(((GenericType.OfArray)this.item.genericType()).componentType());
        }
    }

    @Override
    protected void bind() {
        if (this.item.bound() || this.index.bound()) {
            this.bound = true;
        }
    }

    @Override
    public boolean bound() {
        return this.bound;
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block, StackMapBuilder smb) {
        cb.arrayLoad(Util.actualKindOf(this.typeKind()));
        smb.pop();
        smb.pop();
        smb.push(this.type());
        smb.wroteCode();
    }
}

