/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanDefiningAnnotation;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.BuiltinQualifier;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.BytecodeTransformer;
import io.quarkus.arc.processor.DisposerInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionPointModifier;
import io.quarkus.arc.processor.InjectionTargetInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.Methods;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.arc.processor.StereotypeInfo;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo.ClassTransformer;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.DeploymentException;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassVisitor;

public final class Beans {
    static final Logger LOGGER = Logger.getLogger(Beans.class);

    private Beans() {
    }

    static BeanInfo createClassBean(ClassInfo beanClass, BeanDeployment beanDeployment, InjectionPointModifier transformer) {
        return new ClassBeanFactory(beanClass, beanDeployment, transformer).create();
    }

    private static ScopeInfo inheritScope(ClassInfo beanClass, BeanDeployment beanDeployment) {
        DotName superClassName = beanClass.superName();
        while (!superClassName.equals((Object)DotNames.OBJECT)) {
            ClassInfo classFromIndex = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), superClassName);
            if (classFromIndex == null) {
                LOGGER.warnf("Unable to determine scope for bean %s using inheritance because its super class %s is not part of Jandex index. Dependent scope will be used instead.", (Object)beanClass, (Object)superClassName);
                return null;
            }
            for (AnnotationInstance annotation : beanDeployment.getAnnotationStore().getAnnotations((AnnotationTarget)classFromIndex)) {
                ScopeInfo scopeAnnotation = beanDeployment.getScope(annotation.name());
                if (scopeAnnotation == null) continue;
                return scopeAnnotation.declaresInherited() ? scopeAnnotation : null;
            }
            superClassName = classFromIndex.superName();
        }
        return null;
    }

    static BeanInfo createProducerMethod(Set<Type> beanTypes, MethodInfo producerMethod, BeanInfo declaringBean, BeanDeployment beanDeployment, DisposerInfo disposer, InjectionPointModifier transformer) {
        ScopeInfo scope;
        HashSet<AnnotationInstance> qualifiers = new HashSet<AnnotationInstance>();
        ArrayList<ScopeInfo> scopes = new ArrayList<ScopeInfo>();
        Integer priority = null;
        boolean isAlternative = false;
        boolean isDefaultBean = false;
        ArrayList<StereotypeInfo> stereotypes = new ArrayList<StereotypeInfo>();
        HashSet<ScopeInfo> beanDefiningAnnotationScopes = new HashSet<ScopeInfo>();
        String name = null;
        for (AnnotationInstance annotation : beanDeployment.getAnnotations((AnnotationTarget)producerMethod)) {
            BeanDefiningAnnotation bda;
            DotName annotationName = annotation.name();
            if (annotation.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            if (DotNames.NAMED.equals((Object)annotationName)) {
                AnnotationValue nameValue = annotation.value();
                if (nameValue != null) {
                    name = nameValue.asString();
                } else {
                    name = Beans.getDefaultName(producerMethod);
                    annotation = Beans.normalizedNamedQualifier(name, annotation);
                }
            }
            if ((bda = beanDeployment.getBeanDefiningAnnotation(annotationName)) != null && bda.getDefaultScope() != null) {
                beanDefiningAnnotationScopes.add(beanDeployment.getScope(bda.getDefaultScope()));
            }
            Collection<AnnotationInstance> qualifierCollection = beanDeployment.extractQualifiers(annotation);
            for (AnnotationInstance qualifierAnnotation : qualifierCollection) {
                qualifiers.add(qualifierAnnotation);
            }
            if (!qualifierCollection.isEmpty()) continue;
            if (DotNames.ALTERNATIVE.equals((Object)annotationName)) {
                isAlternative = true;
                continue;
            }
            if (DotNames.PRIORITY.equals((Object)annotationName)) {
                priority = annotation.value().asInt();
                continue;
            }
            if (DotNames.DEFAULT_BEAN.equals((Object)annotationName)) {
                isDefaultBean = true;
                continue;
            }
            ScopeInfo scopeAnnotation = beanDeployment.getScope(annotationName);
            if (scopeAnnotation != null) {
                scopes.add(scopeAnnotation);
                continue;
            }
            StereotypeInfo stereotype = beanDeployment.getStereotype(annotationName);
            if (stereotype == null) continue;
            stereotypes.add(stereotype);
        }
        if (scopes.size() > 1) {
            throw Beans.multipleScopesFound("Producer method " + producerMethod, scopes);
        }
        if (scopes.isEmpty()) {
            scope = Beans.initStereotypeScope(stereotypes, (AnnotationTarget)producerMethod, beanDeployment);
            if (scope == null) {
                scope = Beans.initBeanDefiningAnnotationScope(beanDefiningAnnotationScopes, (AnnotationTarget)producerMethod);
            }
        } else {
            scope = (ScopeInfo)scopes.get(0);
        }
        if (!isAlternative) {
            isAlternative = Beans.initStereotypeAlternative(stereotypes, beanDeployment);
        }
        if (name == null) {
            name = Beans.initStereotypeName(stereotypes, (AnnotationTarget)producerMethod, beanDeployment);
        }
        if (isAlternative) {
            if (priority == null) {
                priority = declaringBean.getPriority();
            }
            if ((priority = Beans.initAlternativePriority((AnnotationTarget)producerMethod, priority, stereotypes, beanDeployment)) == null) {
                LOGGER.debugf("Ignoring producer method %s - declared as an @Alternative but not selected by @Priority or quarkus.arc.selected-alternatives", (Object)(declaringBean.getTarget().get().asClass().name() + "#" + producerMethod.name()));
                return null;
            }
        }
        if (scope != null && !BuiltinScope.DEPENDENT.is(scope) && producerMethod.returnType().kind() == Type.Kind.PARAMETERIZED_TYPE && Types.containsTypeVariable(producerMethod.returnType())) {
            throw new DefinitionException("Producer method return type is a parameterized type with a type variable, its scope must be @Dependent: " + producerMethod);
        }
        List<Injection> injections = Injection.forBean((AnnotationTarget)producerMethod, declaringBean, beanDeployment, transformer, Injection.BeanType.PRODUCER_METHOD);
        BeanInfo bean = new BeanInfo((AnnotationTarget)producerMethod, beanDeployment, scope, beanTypes, qualifiers, injections, declaringBean, disposer, isAlternative, stereotypes, name, isDefaultBean, null, priority);
        for (Injection injection : injections) {
            injection.init(bean);
        }
        return bean;
    }

    static BeanInfo createProducerField(FieldInfo producerField, BeanInfo declaringBean, BeanDeployment beanDeployment, DisposerInfo disposer) {
        ScopeInfo scope;
        HashSet<AnnotationInstance> qualifiers = new HashSet<AnnotationInstance>();
        ArrayList<ScopeInfo> scopes = new ArrayList<ScopeInfo>();
        Set<Type> types = Types.getProducerFieldTypeClosure(producerField, beanDeployment);
        Integer priority = null;
        boolean isAlternative = false;
        boolean isDefaultBean = false;
        ArrayList<StereotypeInfo> stereotypes = new ArrayList<StereotypeInfo>();
        HashSet<ScopeInfo> beanDefiningAnnotationScopes = new HashSet<ScopeInfo>();
        String name = null;
        for (AnnotationInstance annotation : beanDeployment.getAnnotations((AnnotationTarget)producerField)) {
            BeanDefiningAnnotation bda;
            DotName annotationName = annotation.name();
            if (DotNames.NAMED.equals((Object)annotationName)) {
                AnnotationValue nameValue = annotation.value();
                if (nameValue != null) {
                    name = nameValue.asString();
                } else {
                    name = producerField.name();
                    annotation = Beans.normalizedNamedQualifier(name, annotation);
                }
            }
            if ((bda = beanDeployment.getBeanDefiningAnnotation(annotationName)) != null && bda.getDefaultScope() != null) {
                beanDefiningAnnotationScopes.add(beanDeployment.getScope(bda.getDefaultScope()));
            }
            Collection<AnnotationInstance> qualifierCollection = beanDeployment.extractQualifiers(annotation);
            for (AnnotationInstance qualifierAnnotation : qualifierCollection) {
                qualifiers.add(qualifierAnnotation);
            }
            if (!qualifierCollection.isEmpty()) continue;
            if (DotNames.ALTERNATIVE.equals((Object)annotationName)) {
                isAlternative = true;
                continue;
            }
            if (DotNames.PRIORITY.equals((Object)annotation.name())) {
                priority = annotation.value().asInt();
                continue;
            }
            ScopeInfo scopeAnnotation = beanDeployment.getScope(annotationName);
            if (scopeAnnotation != null) {
                scopes.add(scopeAnnotation);
                continue;
            }
            StereotypeInfo stereotype = beanDeployment.getStereotype(annotationName);
            if (stereotype != null) {
                stereotypes.add(stereotype);
                continue;
            }
            if (!DotNames.DEFAULT_BEAN.equals((Object)annotationName)) continue;
            isDefaultBean = true;
        }
        if (scopes.size() > 1) {
            throw Beans.multipleScopesFound("Producer field " + producerField, scopes);
        }
        if (scopes.isEmpty()) {
            scope = Beans.initStereotypeScope(stereotypes, (AnnotationTarget)producerField, beanDeployment);
            if (scope == null) {
                scope = Beans.initBeanDefiningAnnotationScope(beanDefiningAnnotationScopes, (AnnotationTarget)producerField);
            }
        } else {
            scope = (ScopeInfo)scopes.get(0);
        }
        if (!isAlternative) {
            isAlternative = Beans.initStereotypeAlternative(stereotypes, beanDeployment);
        }
        if (name == null) {
            name = Beans.initStereotypeName(stereotypes, (AnnotationTarget)producerField, beanDeployment);
        }
        if (isAlternative) {
            if (priority == null) {
                priority = declaringBean.getPriority();
            }
            if ((priority = Beans.initAlternativePriority((AnnotationTarget)producerField, priority, stereotypes, beanDeployment)) == null) {
                LOGGER.debugf("Ignoring producer field %s - declared as an @Alternative but not selected by @Priority or quarkus.arc.selected-alternatives", (Object)producerField);
                return null;
            }
        }
        if (scope != null && !BuiltinScope.DEPENDENT.is(scope) && producerField.type().kind() == Type.Kind.PARAMETERIZED_TYPE && Types.containsTypeVariable(producerField.type())) {
            throw new DefinitionException("Producer field type is a parameterized type with a type variable, its scope must be @Dependent: " + producerField);
        }
        BeanInfo bean = new BeanInfo((AnnotationTarget)producerField, beanDeployment, scope, types, qualifiers, Collections.emptyList(), declaringBean, disposer, isAlternative, stereotypes, name, isDefaultBean, null, priority);
        return bean;
    }

    private static AnnotationInstance normalizedNamedQualifier(String defaultedName, AnnotationInstance originalAnnotation) {
        return AnnotationInstance.create((DotName)DotNames.NAMED, (AnnotationTarget)originalAnnotation.target(), Collections.singletonList(AnnotationValue.createStringValue((String)"value", (String)defaultedName)));
    }

    private static DefinitionException multipleScopesFound(String baseMessage, List<ScopeInfo> scopes) {
        return new DefinitionException(baseMessage + " declares multiple scope type annotations: " + scopes.stream().map(s -> s.getDotName().toString()).collect(Collectors.joining(", ")));
    }

    static ScopeInfo initStereotypeScope(List<StereotypeInfo> stereotypes, AnnotationTarget target, BeanDeployment beanDeployment) {
        if (stereotypes.isEmpty()) {
            return null;
        }
        HashSet<ScopeInfo> stereotypeScopes = new HashSet<ScopeInfo>();
        for (StereotypeInfo stereotype : Beans.stereotypesWithTransitive(stereotypes, beanDeployment.getStereotypesMap())) {
            if (stereotype.getDefaultScope() == null) continue;
            stereotypeScopes.add(stereotype.getDefaultScope());
        }
        return BeanDeployment.getValidScope(stereotypeScopes, target);
    }

    static ScopeInfo initBeanDefiningAnnotationScope(Set<ScopeInfo> beanDefiningAnnotationScopes, AnnotationTarget target) {
        if (beanDefiningAnnotationScopes.isEmpty()) {
            return null;
        }
        return BeanDeployment.getValidScope(beanDefiningAnnotationScopes, target);
    }

    static boolean initStereotypeAlternative(List<StereotypeInfo> stereotypes, BeanDeployment beanDeployment) {
        if (stereotypes.isEmpty()) {
            return false;
        }
        for (StereotypeInfo stereotype : Beans.stereotypesWithTransitive(stereotypes, beanDeployment.getStereotypesMap())) {
            if (!stereotype.isAlternative()) continue;
            return true;
        }
        return false;
    }

    static Integer initStereotypeAlternativePriority(List<StereotypeInfo> stereotypes, AnnotationTarget target, BeanDeployment beanDeployment) {
        if (stereotypes.isEmpty()) {
            return null;
        }
        HashSet<Integer> priorities = new HashSet<Integer>();
        for (StereotypeInfo stereotype : Beans.stereotypesWithTransitive(stereotypes, beanDeployment.getStereotypesMap())) {
            if (stereotype.getAlternativePriority() == null) continue;
            priorities.add(stereotype.getAlternativePriority());
        }
        if (priorities.isEmpty()) {
            return null;
        }
        if (priorities.size() == 1) {
            return (Integer)priorities.iterator().next();
        }
        throw new DefinitionException("Bean " + target + " does not declare @Priority and inherits multiple different priorities from stereotypes");
    }

    static String initStereotypeName(List<StereotypeInfo> stereotypes, AnnotationTarget target, BeanDeployment beanDeployment) {
        if (stereotypes.isEmpty()) {
            return null;
        }
        for (StereotypeInfo stereotype : Beans.stereotypesWithTransitive(stereotypes, beanDeployment.getStereotypesMap())) {
            if (!stereotype.isNamed()) continue;
            switch (target.kind()) {
                case CLASS: {
                    return Beans.getDefaultName(target.asClass());
                }
                case FIELD: {
                    return target.asField().name();
                }
                case METHOD: {
                    return Beans.getDefaultName(target.asMethod());
                }
            }
        }
        return null;
    }

    public static List<StereotypeInfo> stereotypesWithTransitive(List<StereotypeInfo> stereotypes, Map<DotName, StereotypeInfo> allStereotypes) {
        ArrayList<StereotypeInfo> result = new ArrayList<StereotypeInfo>();
        HashSet<DotName> alreadySeen = new HashSet<DotName>();
        ArrayDeque<StereotypeInfo> workQueue = new ArrayDeque<StereotypeInfo>(stereotypes);
        while (!workQueue.isEmpty()) {
            StereotypeInfo stereotype = (StereotypeInfo)workQueue.poll();
            if (alreadySeen.contains(stereotype.getName())) continue;
            result.add(stereotype);
            alreadySeen.add(stereotype.getName());
            for (AnnotationInstance parentStereotype : stereotype.getParentStereotypes()) {
                StereotypeInfo parent = allStereotypes.get(parentStereotype.name());
                if (parent == null) continue;
                workQueue.add(parent);
            }
        }
        return result;
    }

    public static boolean matches(BeanInfo bean, InjectionPointInfo.TypeAndQualifiers typeAndQualifiers) {
        return bean.getDeployment().getBeanResolver().matches(bean, typeAndQualifiers);
    }

    public static boolean matches(BeanInfo bean, Type requiredType, Set<AnnotationInstance> requiredQualifiers) {
        return bean.getDeployment().getBeanResolver().matches(bean, requiredType, requiredQualifiers);
    }

    static void resolveInjectionPoint(BeanDeployment deployment, InjectionTargetInfo target, InjectionPointInfo injectionPoint, List<Throwable> errors) {
        if (injectionPoint.isDelegate()) {
            return;
        }
        BuiltinBean builtinBean = BuiltinBean.resolve(injectionPoint);
        if (builtinBean != null) {
            builtinBean.validate(target, injectionPoint, errors::add);
            return;
        }
        List<BeanInfo> resolved = deployment.beanResolver.resolve(injectionPoint.getTypeAndQualifiers());
        BeanInfo selected = null;
        if (resolved.isEmpty()) {
            List<BeanInfo> typeMatching = deployment.beanResolver.findTypeMatching(injectionPoint.getRequiredType());
            StringBuilder message = new StringBuilder("Unsatisfied dependency for type ");
            Beans.addStandardErroneousDependencyMessage(target, injectionPoint, message);
            if (!typeMatching.isEmpty()) {
                message.append("\n\tThe following beans match by type, but none have matching qualifiers:");
                for (BeanInfo beanInfo : typeMatching) {
                    message.append("\n\t\t- ");
                    message.append("Bean [class=");
                    message.append(beanInfo.getImplClazz());
                    message.append(", qualifiers=");
                    message.append(beanInfo.getQualifiers());
                    message.append("]");
                }
            }
            errors.add((Throwable)new UnsatisfiedResolutionException(message.toString()));
        } else if (resolved.size() > 1) {
            selected = Beans.resolveAmbiguity(resolved);
            if (selected == null) {
                StringBuilder message = new StringBuilder("Ambiguous dependencies for type ");
                Beans.addStandardErroneousDependencyMessage(target, injectionPoint, message);
                message.append("\n\t- available beans:\n\t\t- ");
                message.append(resolved.stream().map(Object::toString).collect(Collectors.joining("\n\t\t- ")));
                errors.add((Throwable)new AmbiguousResolutionException(message.toString()));
            }
        } else {
            selected = resolved.get(0);
        }
        if (selected != null) {
            injectionPoint.resolve(selected);
        }
    }

    private static void addStandardErroneousDependencyMessage(InjectionTargetInfo target, InjectionPointInfo injectionPoint, StringBuilder message) {
        message.append(injectionPoint.getType());
        message.append(" and qualifiers ");
        message.append(injectionPoint.getRequiredQualifiers());
        if (injectionPoint.isSynthetic()) {
            message.append("\n\t- synthetic injection point");
        } else {
            message.append("\n\t- java member: ");
            message.append(injectionPoint.getTargetInfo());
        }
        message.append("\n\t- declared on ");
        message.append(target);
    }

    static BeanInfo resolveAmbiguity(Collection<BeanInfo> resolved) {
        ArrayList<BeanInfo> resolvedAmbiguity = new ArrayList<BeanInfo>(resolved);
        Iterator iterator = resolvedAmbiguity.iterator();
        while (iterator.hasNext()) {
            BeanInfo beanInfo = (BeanInfo)iterator.next();
            if (!beanInfo.isDefaultBean()) continue;
            iterator.remove();
        }
        if (resolvedAmbiguity.size() == 1) {
            return (BeanInfo)resolvedAmbiguity.get(0);
        }
        BeanInfo selected = null;
        Iterator iterator2 = resolvedAmbiguity.iterator();
        while (iterator2.hasNext()) {
            BeanInfo beanInfo = (BeanInfo)iterator2.next();
            if (beanInfo.isAlternative() || beanInfo.getDeclaringBean() != null && beanInfo.getDeclaringBean().isAlternative()) continue;
            iterator2.remove();
        }
        if (resolvedAmbiguity.size() == 1) {
            selected = (BeanInfo)resolvedAmbiguity.get(0);
        } else if (resolvedAmbiguity.size() > 1) {
            resolvedAmbiguity.sort(Beans::compareAlternativeBeans);
            Integer highest = Beans.getAlternativePriority((BeanInfo)resolvedAmbiguity.get(0));
            Iterator iterator3 = resolvedAmbiguity.iterator();
            while (iterator3.hasNext()) {
                if (highest.equals(Beans.getAlternativePriority((BeanInfo)iterator3.next()))) continue;
                iterator3.remove();
            }
            if (resolvedAmbiguity.size() == 1) {
                selected = (BeanInfo)resolvedAmbiguity.get(0);
            }
        }
        return selected;
    }

    private static Integer getAlternativePriority(BeanInfo bean) {
        Integer beanPriority = bean.getAlternativePriority();
        if (beanPriority == null && bean.getDeclaringBean() != null) {
            beanPriority = bean.getDeclaringBean().getAlternativePriority();
        }
        return beanPriority;
    }

    private static int compareAlternativeBeans(BeanInfo bean1, BeanInfo bean2) {
        Integer priority1;
        Integer priority2 = bean2.getAlternativePriority();
        if (priority2 == null) {
            priority2 = bean2.getDeclaringBean().getAlternativePriority();
        }
        if ((priority1 = bean1.getAlternativePriority()) == null) {
            priority1 = bean1.getDeclaringBean().getAlternativePriority();
        }
        if (priority2 == null || priority1 == null) {
            throw new IllegalStateException(String.format("Alternative Bean priority should not be null. %s has priority %s; %s has priority %s", bean1.getBeanClass(), priority1, bean2.getBeanClass(), priority2));
        }
        return priority2.compareTo(priority1);
    }

    static boolean hasQualifiers(BeanInfo bean, Iterable<AnnotationInstance> required) {
        for (AnnotationInstance requiredQualifier : required) {
            if (Beans.hasQualifier(bean, requiredQualifier)) continue;
            return false;
        }
        return true;
    }

    static boolean hasQualifier(BeanInfo bean, AnnotationInstance required) {
        return Beans.hasQualifier(bean.getDeployment(), required, bean.getQualifiers());
    }

    static boolean hasQualifier(BeanDeployment beanDeployment, AnnotationInstance requiredQualifier, Collection<AnnotationInstance> qualifiers) {
        ClassInfo requiredClazz = beanDeployment.getQualifier(requiredQualifier.name());
        ArrayList<AnnotationValue> values = null;
        for (AnnotationInstance qualifier : qualifiers) {
            if (!requiredQualifier.name().equals((Object)qualifier.name())) continue;
            boolean matches = true;
            if (values == null) {
                values = new ArrayList<AnnotationValue>();
                Set<String> nonBindingFields = beanDeployment.getQualifierNonbindingMembers(requiredQualifier.name());
                for (AnnotationValue val : requiredQualifier.valuesWithDefaults(beanDeployment.getBeanArchiveIndex())) {
                    if (requiredClazz.method(val.name(), new Type[0]).hasAnnotation(DotNames.NONBINDING) || nonBindingFields.contains(val.name())) continue;
                    values.add(val);
                }
            }
            for (AnnotationValue value : values) {
                if (value.equals((Object)qualifier.valueWithDefault(beanDeployment.getBeanArchiveIndex(), value.name()))) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return true;
        }
        return false;
    }

    static void addImplicitQualifiers(Set<AnnotationInstance> qualifiers) {
        if (qualifiers.isEmpty() || qualifiers.size() <= 2 && qualifiers.stream().allMatch(a -> DotNames.NAMED.equals((Object)a.name()) || DotNames.ANY.equals((Object)a.name()))) {
            qualifiers.add(BuiltinQualifier.DEFAULT.getInstance());
        }
        qualifiers.add(BuiltinQualifier.ANY.getInstance());
    }

    static List<MethodInfo> getCallbacks(ClassInfo beanClass, DotName annotation, IndexView index) {
        ArrayList<MethodInfo> callbacks = new ArrayList<MethodInfo>();
        Beans.collectCallbacks(beanClass, callbacks, annotation, index, new HashSet<String>());
        Collections.reverse(callbacks);
        return callbacks;
    }

    static List<MethodInfo> getAroundInvokes(ClassInfo beanClass, BeanDeployment deployment) {
        AnnotationStore store = deployment.getAnnotationStore();
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        ArrayList<MethodInfo> allMethods = new ArrayList<MethodInfo>();
        ClassInfo aClass = beanClass;
        while (aClass != null) {
            int aroundInvokesFound = 0;
            for (MethodInfo method : aClass.methods()) {
                if (Modifier.isStatic(method.flags())) continue;
                if (store.hasAnnotation((AnnotationTarget)method, DotNames.AROUND_INVOKE)) {
                    InterceptorInfo.addInterceptorMethod(allMethods, methods, method);
                    if (++aroundInvokesFound > 1) {
                        throw new DefinitionException("Multiple @AroundInvoke interceptor methods declared on class: " + aClass);
                    }
                }
                allMethods.add(method);
            }
            DotName superTypeName = aClass.superName();
            aClass = superTypeName == null || DotNames.OBJECT.equals((Object)superTypeName) ? null : IndexClassLookupUtils.getClassByName(deployment.getBeanArchiveIndex(), superTypeName);
        }
        Collections.reverse(methods);
        return methods.isEmpty() ? List.of() : List.copyOf(methods);
    }

    static void analyzeType(Type type, BeanDeployment beanDeployment) {
        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            for (Type argument : type.asParameterizedType().arguments()) {
                Beans.fetchType(argument, beanDeployment);
            }
        } else if (type.kind() == Type.Kind.TYPE_VARIABLE) {
            for (Type bound : type.asTypeVariable().bounds()) {
                Beans.fetchType(bound, beanDeployment);
            }
        } else if (type.kind() == Type.Kind.WILDCARD_TYPE) {
            Beans.fetchType(type.asWildcardType().extendsBound(), beanDeployment);
            Beans.fetchType(type.asWildcardType().superBound(), beanDeployment);
        }
    }

    static void validateInterceptorDecorator(BeanInfo bean, List<Throwable> errors, Consumer<BytecodeTransformer> bytecodeTransformerConsumer) {
        if (bean.isClassBean() && bean.getDeployment().transformPrivateInjectedFields) {
            for (Injection injection : bean.getInjections()) {
                if (!injection.isField() || !Modifier.isPrivate(injection.getTarget().asField().flags())) continue;
                bytecodeTransformerConsumer.accept(new BytecodeTransformer(bean.getTarget().get().asClass().name().toString(), new PrivateInjectedFieldTransformFunction(injection.getTarget().asField())));
            }
        }
    }

    static void validateBean(BeanInfo bean, List<Throwable> errors, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, Set<DotName> classesReceivingNoArgsCtor, Set<BeanInfo> injectedBeans) {
        boolean failIfNotProxyable;
        boolean bl = failIfNotProxyable = bean.getDeployment().strictCompatibility ? injectedBeans.contains(bean) : true;
        if (bean.isClassBean()) {
            String classifier;
            ClassInfo beanClass = bean.getTarget().get().asClass();
            String string = classifier = bean.getScope().isNormal() ? "Normal scoped" : null;
            if (classifier == null && bean.isSubclassRequired()) {
                classifier = "Intercepted";
                failIfNotProxyable = true;
            }
            if (Modifier.isFinal(beanClass.flags()) && classifier != null) {
                if (beanClass.isRecord()) {
                    errors.add(new DeploymentException(String.format("%s bean must not be a record, because records are always final: %s", classifier, bean)));
                } else if (bean.getDeployment().transformUnproxyableClasses) {
                    bytecodeTransformerConsumer.accept(new BytecodeTransformer(beanClass.name().toString(), new FinalClassTransformFunction()));
                } else if (failIfNotProxyable) {
                    errors.add(new DeploymentException(String.format("%s bean must not be final: %s", classifier, bean)));
                } else {
                    bean.getDeployment().deferUnproxyableErrorToRuntime(bean);
                }
            }
            if (bean.getDeployment().strictCompatibility && classifier != null) {
                Beans.validateNonStaticFinalMethods(bean, beanClass, bean.getDeployment().getBeanArchiveIndex(), classifier, errors, failIfNotProxyable);
            }
            MethodInfo noArgsConstructor = beanClass.method("<init>", new Type[0]);
            if (bean.getScope().isNormal() && noArgsConstructor == null) {
                if (bean.getDeployment().transformUnproxyableClasses) {
                    ClassInfo superClass;
                    Object superName = beanClass.superName();
                    if (!(DotNames.OBJECT.equals(superName) || (superClass = bean.getDeployment().getBeanArchiveIndex().getClassByName(beanClass.superName())) != null && superClass.hasNoArgsConstructor())) {
                        superName = null;
                    }
                    if (superName != null) {
                        if (!classesReceivingNoArgsCtor.contains(beanClass.name())) {
                            String superClassName = superName.toString().replace('.', '/');
                            bytecodeTransformerConsumer.accept(new BytecodeTransformer(beanClass.name().toString(), new NoArgConstructorTransformFunction(superClassName)));
                            classesReceivingNoArgsCtor.add(beanClass.name());
                        }
                    } else if (failIfNotProxyable) {
                        errors.add(Beans.cannotAddSyntheticNoArgsConstructor(beanClass));
                    } else {
                        bean.getDeployment().deferUnproxyableErrorToRuntime(bean);
                    }
                } else if (failIfNotProxyable) {
                    errors.add(new DeploymentException(String.format("Normal scoped beans must declare a non-private constructor with no parameters: %s", bean)));
                } else {
                    bean.getDeployment().deferUnproxyableErrorToRuntime(bean);
                }
            }
            if (noArgsConstructor != null && Modifier.isPrivate(noArgsConstructor.flags()) && classifier != null) {
                if (bean.getDeployment().transformUnproxyableClasses) {
                    bytecodeTransformerConsumer.accept(new BytecodeTransformer(beanClass.name().toString(), new PrivateNoArgsConstructorTransformFunction()));
                } else if (failIfNotProxyable) {
                    errors.add(new DeploymentException(String.format("%s bean is not proxyable because it has a private no-args constructor: %s. To fix this problem, change the constructor to be package-private", classifier, bean)));
                } else {
                    bean.getDeployment().deferUnproxyableErrorToRuntime(bean);
                }
            }
            if (bean.getDeployment().transformPrivateInjectedFields) {
                for (Injection injection : bean.getInjections()) {
                    if (!injection.isField() || !Modifier.isPrivate(injection.getTarget().asField().flags())) continue;
                    bytecodeTransformerConsumer.accept(new BytecodeTransformer(beanClass.name().toString(), new PrivateInjectedFieldTransformFunction(injection.getTarget().asField())));
                }
            }
        } else if (bean.isProducer()) {
            ClassInfo returnTypeClass;
            Type type;
            String methodOrField = bean.isProducerMethod() ? "method" : "field";
            String classifier = "Producer " + methodOrField + " for a normal scoped bean";
            Type type2 = type = bean.isProducerMethod() ? bean.getTarget().get().asMethod().returnType() : bean.getTarget().get().asField().type();
            if (bean.getScope().isNormal()) {
                if (type.kind() == Type.Kind.PRIMITIVE) {
                    errors.add(new DeploymentException(String.format("%s must not have a primitive type", classifier)));
                } else if (type.kind() == Type.Kind.ARRAY) {
                    errors.add(new DeploymentException(String.format("%s must not have an array type", classifier)));
                }
            }
            if ((returnTypeClass = IndexClassLookupUtils.getClassByName(bean.getDeployment().getBeanArchiveIndex(), type)) != null && bean.getScope().isNormal() && !Modifier.isInterface(returnTypeClass.flags())) {
                MethodInfo noArgsConstructor;
                if (Modifier.isFinal(returnTypeClass.flags())) {
                    if (returnTypeClass.isRecord()) {
                        errors.add(new DeploymentException(String.format("%s must not have a type that is a record, because records are always final: %s", classifier, bean)));
                    } else if (bean.getDeployment().transformUnproxyableClasses) {
                        bytecodeTransformerConsumer.accept(new BytecodeTransformer(returnTypeClass.name().toString(), new FinalClassTransformFunction()));
                    } else if (failIfNotProxyable) {
                        errors.add(new DeploymentException(String.format("%s must not have a return type that is final: %s", classifier, bean)));
                    } else {
                        bean.getDeployment().deferUnproxyableErrorToRuntime(bean);
                    }
                }
                if (bean.getDeployment().strictCompatibility) {
                    Beans.validateNonStaticFinalMethods(bean, returnTypeClass, bean.getDeployment().getBeanArchiveIndex(), classifier, errors, failIfNotProxyable);
                }
                if ((noArgsConstructor = returnTypeClass.method("<init>", new Type[0])) == null) {
                    if (bean.getDeployment().transformUnproxyableClasses) {
                        ClassInfo superClass;
                        DotName superName = returnTypeClass.superName();
                        if (!(DotNames.OBJECT.equals((Object)superName) || (superClass = bean.getDeployment().getBeanArchiveIndex().getClassByName(returnTypeClass.superName())) != null && superClass.hasNoArgsConstructor())) {
                            superName = null;
                        }
                        if (superName != null) {
                            if (!classesReceivingNoArgsCtor.contains(returnTypeClass.name())) {
                                String superClassName = superName.toString().replace('.', '/');
                                bytecodeTransformerConsumer.accept(new BytecodeTransformer(returnTypeClass.name().toString(), new NoArgConstructorTransformFunction(superClassName)));
                                classesReceivingNoArgsCtor.add(returnTypeClass.name());
                            }
                        } else {
                            errors.add(Beans.cannotAddSyntheticNoArgsConstructor(returnTypeClass));
                        }
                    } else if (failIfNotProxyable) {
                        errors.add(new DefinitionException(String.format("Return type of a producer %s for normal scoped beans must declare a non-private constructor with no parameters: %s", methodOrField, bean)));
                    } else {
                        bean.getDeployment().deferUnproxyableErrorToRuntime(bean);
                    }
                } else if (Modifier.isPrivate(noArgsConstructor.flags())) {
                    if (bean.getDeployment().transformUnproxyableClasses) {
                        bytecodeTransformerConsumer.accept(new BytecodeTransformer(returnTypeClass.name().toString(), new PrivateNoArgsConstructorTransformFunction()));
                    } else if (failIfNotProxyable) {
                        errors.add(new DeploymentException(String.format("%s is not proxyable because it has a private no-args constructor: %s.", classifier, bean)));
                    } else {
                        bean.getDeployment().deferUnproxyableErrorToRuntime(bean);
                    }
                }
            }
        } else if (bean.isSynthetic()) {
            DotName scopeName = bean.getScope().getDotName();
            if (bean.getDeployment().getScope(scopeName) == null) {
                throw new IllegalArgumentException("A synthetic bean " + bean + " was defined with invalid scope annotation - " + scopeName + ". Please use one of the built-in scopes or a valid, registered custom scope.");
            }
            ClassInfo beanClass = IndexClassLookupUtils.getClassByName(bean.getDeployment().getBeanArchiveIndex(), bean.getBeanClass());
            MethodInfo noArgsConstructor = beanClass.method("<init>", new Type[0]);
            if (bean.getScope().isNormal() && !Modifier.isInterface(beanClass.flags()) && noArgsConstructor == null) {
                if (bean.getDeployment().transformUnproxyableClasses) {
                    ClassInfo superClass;
                    DotName superName = beanClass.superName();
                    if (!(DotNames.OBJECT.equals((Object)superName) || (superClass = bean.getDeployment().getBeanArchiveIndex().getClassByName(beanClass.superName())) != null && superClass.hasNoArgsConstructor())) {
                        superName = null;
                    }
                    if (superName != null) {
                        if (!classesReceivingNoArgsCtor.contains(beanClass.name())) {
                            String superClassName = superName.toString().replace('.', '/');
                            bytecodeTransformerConsumer.accept(new BytecodeTransformer(beanClass.name().toString(), new NoArgConstructorTransformFunction(superClassName)));
                            classesReceivingNoArgsCtor.add(beanClass.name());
                        }
                    } else {
                        errors.add(Beans.cannotAddSyntheticNoArgsConstructor(beanClass));
                    }
                } else if (failIfNotProxyable) {
                    errors.add(new DeploymentException(String.format("Normal scoped beans must declare a non-private constructor with no parameters: %s", bean)));
                } else {
                    bean.getDeployment().deferUnproxyableErrorToRuntime(bean);
                }
            }
            if (bean.getScope().isNormal() && !Modifier.isInterface(beanClass.flags()) && bean.getDeployment().strictCompatibility) {
                Beans.validateNonStaticFinalMethods(bean, beanClass, bean.getDeployment().getBeanArchiveIndex(), "Normal scoped", errors, failIfNotProxyable);
            }
        }
    }

    private static void validateNonStaticFinalMethods(BeanInfo bean, ClassInfo clazz, IndexView beanArchiveIndex, String classifier, List<Throwable> errors, boolean failIfNotProxyable) {
        while (!clazz.name().equals((Object)DotNames.OBJECT)) {
            for (MethodInfo method : clazz.methods()) {
                if (Methods.IGNORED_METHODS.contains(method.name()) || Modifier.isStatic(method.flags()) || Modifier.isPrivate(method.flags()) || method.isSynthetic() || !Modifier.isFinal(method.flags())) continue;
                if (failIfNotProxyable) {
                    errors.add(new DeploymentException(String.format("%s bean must not declare non-static final methods with public, protected or default visibility: %s", classifier, method)));
                    continue;
                }
                bean.getDeployment().deferUnproxyableErrorToRuntime(bean);
            }
            ClassInfo superClass = IndexClassLookupUtils.getClassByName(beanArchiveIndex, clazz.superName());
            if (superClass == null) break;
            clazz = superClass;
        }
    }

    private static DeploymentException cannotAddSyntheticNoArgsConstructor(ClassInfo beanClass) {
        String message = "It's not possible to automatically add a synthetic no-args constructor to an unproxyable bean class. You need to manually add a non-private no-args constructor to %s in order to fulfill the requirements for normal scoped/intercepted/decorated beans.";
        return new DeploymentException(String.format(message, beanClass));
    }

    private static void fetchType(Type type, BeanDeployment beanDeployment) {
        if (type == null) {
            return;
        }
        if (type.kind() == Type.Kind.CLASS) {
            IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), type.name());
        } else {
            Beans.analyzeType(type, beanDeployment);
        }
    }

    private static void collectCallbacks(ClassInfo clazz, List<MethodInfo> callbacks, DotName annotation, IndexView index, Set<String> knownMethods) {
        ClassInfo superClass;
        for (MethodInfo method : clazz.methods()) {
            if (method.hasAnnotation(annotation) && !knownMethods.contains(method.name())) {
                if (method.returnType().kind() == Type.Kind.VOID && method.parameterTypes().isEmpty()) {
                    callbacks.add(method);
                } else {
                    throw new DefinitionException("Invalid signature for the method `" + method + "` from class `" + method.declaringClass() + "`. Methods annotated with `" + annotation + "` must return `void` and cannot have parameters.");
                }
            }
            knownMethods.add(method.name());
        }
        if (clazz.superName() != null && (superClass = IndexClassLookupUtils.getClassByName(index, clazz.superName())) != null) {
            Beans.collectCallbacks(superClass, callbacks, annotation, index, knownMethods);
        }
    }

    private static String getPropertyName(String methodName) {
        String get = "get";
        String is = "is";
        if (methodName.startsWith("get")) {
            return Beans.decapitalize(methodName.substring("get".length()));
        }
        if (methodName.startsWith("is")) {
            return Beans.decapitalize(methodName.substring("is".length()));
        }
        return null;
    }

    private static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        StringBuilder decapitalized = new StringBuilder(name);
        decapitalized.setCharAt(0, Character.toLowerCase(decapitalized.charAt(0)));
        return decapitalized.toString();
    }

    private static String getDefaultName(ClassInfo beanClass) {
        StringBuilder defaultName = new StringBuilder();
        defaultName.append(DotNames.simpleName(beanClass));
        defaultName.setCharAt(0, Character.toLowerCase(defaultName.charAt(0)));
        return defaultName.toString();
    }

    private static String getDefaultName(MethodInfo producerMethod) {
        String propertyName = Beans.getPropertyName(producerMethod.name());
        if (propertyName != null) {
            return propertyName;
        }
        return producerMethod.name();
    }

    private static Integer initAlternativePriority(AnnotationTarget target, Integer alternativePriority, List<StereotypeInfo> stereotypes, BeanDeployment deployment) {
        Integer computedPriority;
        if (alternativePriority == null) {
            alternativePriority = Beans.initStereotypeAlternativePriority(stereotypes, target, deployment);
        }
        if ((computedPriority = deployment.computeAlternativePriority(target, stereotypes)) != null) {
            if (alternativePriority != null) {
                LOGGER.infof("Computed priority [%s] overrides the priority [%s] declared via @Priority", (Object)computedPriority, (Object)alternativePriority);
            }
            alternativePriority = computedPriority;
        }
        return alternativePriority;
    }

    private static class ClassBeanFactory {
        private final ClassInfo beanClass;
        private final BeanDeployment beanDeployment;
        private final InjectionPointModifier transformer;
        private String name;
        private Integer priority;
        private boolean isAlternative;
        private boolean isDefaultBean;

        ClassBeanFactory(ClassInfo beanClass, BeanDeployment beanDeployment, InjectionPointModifier transformer) {
            this.beanClass = beanClass;
            this.beanDeployment = beanDeployment;
            this.transformer = transformer;
            this.priority = null;
            this.isAlternative = false;
            this.isDefaultBean = false;
            this.name = null;
        }

        void processInheritedAnnotation(AnnotationInstance annotation, BeanDeployment beanDeployment, Set<AnnotationInstance> qualifiers, List<StereotypeInfo> stereotypes) {
            Collection<AnnotationInstance> qualifierCollection = beanDeployment.extractQualifiers(annotation);
            for (AnnotationInstance qualifierAnnotation : qualifierCollection) {
                if (!beanDeployment.isInheritedQualifier(qualifierAnnotation.name()) || Annotations.contains(qualifiers, qualifierAnnotation.name())) continue;
                qualifiers.add(qualifierAnnotation);
            }
            StereotypeInfo stereotype = beanDeployment.getStereotype(annotation.name());
            if (stereotype != null && stereotype.isInherited()) {
                stereotypes.add(stereotype);
            }
        }

        void processAnnotation(AnnotationInstance annotation, ClassInfo beanClass, BeanDeployment beanDeployment, Set<AnnotationInstance> qualifiers, List<StereotypeInfo> stereotypes, List<ScopeInfo> scopes, Set<ScopeInfo> beanDefiningAnnotationScopes) {
            BeanDefiningAnnotation bda;
            DotName annotationName = annotation.name();
            if (DotNames.NAMED.equals((Object)annotationName)) {
                AnnotationValue nameValue = annotation.value();
                if (nameValue != null) {
                    this.name = nameValue.asString();
                } else {
                    this.name = Beans.getDefaultName(beanClass);
                    annotation = Beans.normalizedNamedQualifier(this.name, annotation);
                }
            }
            if ((bda = beanDeployment.getBeanDefiningAnnotation(annotationName)) != null && bda.getDefaultScope() != null) {
                beanDefiningAnnotationScopes.add(beanDeployment.getScope(bda.getDefaultScope()));
            }
            Collection<AnnotationInstance> qualifierCollection = beanDeployment.extractQualifiers(annotation);
            for (AnnotationInstance qualifierAnnotation : qualifierCollection) {
                qualifiers.add(qualifierAnnotation);
            }
            if (!qualifierCollection.isEmpty()) {
                return;
            }
            if (DotNames.ALTERNATIVE.equals((Object)annotationName)) {
                this.isAlternative = true;
                return;
            }
            if (DotNames.DEFAULT_BEAN.equals((Object)annotationName)) {
                this.isDefaultBean = true;
                return;
            }
            if (DotNames.PRIORITY.equals((Object)annotationName)) {
                this.priority = annotation.value().asInt();
                return;
            }
            StereotypeInfo stereotype = beanDeployment.getStereotype(annotationName);
            if (stereotype != null) {
                stereotypes.add(stereotype);
                return;
            }
            ScopeInfo scopeAnnotation = beanDeployment.getScope(annotationName);
            if (scopeAnnotation != null && !scopes.contains(scopeAnnotation)) {
                scopes.add(scopeAnnotation);
            }
        }

        BeanInfo create() {
            ScopeInfo scope;
            HashSet<AnnotationInstance> qualifiers = new HashSet<AnnotationInstance>();
            ArrayList<ScopeInfo> scopes = new ArrayList<ScopeInfo>();
            Set<Type> types = Types.getClassBeanTypeClosure(this.beanClass, this.beanDeployment);
            ArrayList<StereotypeInfo> stereotypes = new ArrayList<StereotypeInfo>();
            Collection<AnnotationInstance> annotations = this.beanDeployment.getAnnotations((AnnotationTarget)this.beanClass);
            HashSet<ScopeInfo> beanDefiningAnnotationScopes = new HashSet<ScopeInfo>();
            for (AnnotationInstance annotation : annotations) {
                this.processAnnotation(annotation, this.beanClass, this.beanDeployment, qualifiers, stereotypes, scopes, beanDefiningAnnotationScopes);
            }
            this.processSuperClass(this.beanClass, this.beanDeployment, qualifiers, stereotypes);
            if (scopes.size() > 1) {
                throw Beans.multipleScopesFound("Bean class " + this.beanClass, scopes);
            }
            if (scopes.isEmpty()) {
                scope = Beans.inheritScope(this.beanClass, this.beanDeployment);
                if (scope == null && (scope = Beans.initStereotypeScope(stereotypes, (AnnotationTarget)this.beanClass, this.beanDeployment)) == null) {
                    scope = Beans.initBeanDefiningAnnotationScope(beanDefiningAnnotationScopes, (AnnotationTarget)this.beanClass);
                }
            } else {
                scope = (ScopeInfo)scopes.get(0);
            }
            if (scope != null && !BuiltinScope.DEPENDENT.is(scope) && !this.beanClass.typeParameters().isEmpty()) {
                throw new DefinitionException("Declaring class of a managed bean is generic, its scope must be @Dependent: " + this.beanClass);
            }
            if (!this.isAlternative) {
                this.isAlternative = Beans.initStereotypeAlternative(stereotypes, this.beanDeployment);
            }
            if (this.name == null) {
                this.name = Beans.initStereotypeName(stereotypes, (AnnotationTarget)this.beanClass, this.beanDeployment);
            }
            if (this.isAlternative) {
                this.priority = Beans.initAlternativePriority((AnnotationTarget)this.beanClass, this.priority, stereotypes, this.beanDeployment);
                if (this.priority == null) {
                    LOGGER.debugf("Ignoring bean defined via %s - declared as an @Alternative but not selected by @Priority or quarkus.arc.selected-alternatives", (Object)this.beanClass.name());
                    return null;
                }
            }
            List<Injection> injections = Injection.forBean((AnnotationTarget)this.beanClass, null, this.beanDeployment, this.transformer, Injection.BeanType.MANAGED_BEAN);
            BeanInfo bean = new BeanInfo((AnnotationTarget)this.beanClass, this.beanDeployment, scope, types, qualifiers, injections, null, null, this.isAlternative, stereotypes, this.name, this.isDefaultBean, null, this.priority);
            for (Injection injection : injections) {
                injection.init(bean);
            }
            return bean;
        }

        void processSuperClass(ClassInfo beanClass, BeanDeployment beanDeployment, Set<AnnotationInstance> qualifiers, List<StereotypeInfo> stereotypes) {
            DotName superClassName = beanClass.superName();
            while (!superClassName.equals((Object)DotNames.OBJECT)) {
                ClassInfo classFromIndex = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), superClassName);
                if (classFromIndex == null) {
                    LOGGER.warnf("Unable to get inherited qualifier of stereotype for bean %s because its super class %s is not part of Jandex index. This inheritance will not apply.", (Object)beanClass, (Object)superClassName);
                    break;
                }
                for (AnnotationInstance annotation : beanDeployment.getAnnotationStore().getAnnotations((AnnotationTarget)classFromIndex)) {
                    this.processInheritedAnnotation(annotation, beanDeployment, qualifiers, stereotypes);
                }
                superClassName = classFromIndex.superName();
            }
        }
    }

    static class PrivateInjectedFieldTransformFunction
    implements BiFunction<String, ClassVisitor, ClassVisitor> {
        private FieldInfo field;

        public PrivateInjectedFieldTransformFunction(FieldInfo field) {
            this.field = field;
        }

        @Override
        public ClassVisitor apply(String className, ClassVisitor classVisitor) {
            ClassTransformer transformer = new ClassTransformer(className);
            transformer.modifyField(FieldDescriptor.of((FieldInfo)this.field)).removeModifiers(2);
            LOGGER.debugf("Changed visibility of an injected private field to package-private. Field name: %s in class: %s", (Object)this.field.name(), (Object)className);
            return transformer.applyTo(classVisitor);
        }
    }

    static class PrivateNoArgsConstructorTransformFunction
    implements BiFunction<String, ClassVisitor, ClassVisitor> {
        PrivateNoArgsConstructorTransformFunction() {
        }

        @Override
        public ClassVisitor apply(String className, ClassVisitor classVisitor) {
            ClassTransformer transformer = new ClassTransformer(className);
            transformer.modifyMethod(MethodDescriptor.ofConstructor((String)className, (String[])new String[0])).removeModifiers(2);
            LOGGER.debugf("Changed visibility of a private no-args constructor to package-private: %s", (Object)className);
            return transformer.applyTo(classVisitor);
        }
    }

    static class NoArgConstructorTransformFunction
    implements BiFunction<String, ClassVisitor, ClassVisitor> {
        private final String superClassName;

        public NoArgConstructorTransformFunction(String superClassName) {
            this.superClassName = superClassName;
        }

        @Override
        public ClassVisitor apply(String className, ClassVisitor classVisitor) {
            ClassTransformer transformer = new ClassTransformer(className);
            MethodCreator constructor = transformer.addMethod(MethodDescriptor.ofConstructor((String)className, (String[])new String[0]));
            constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor((String)this.superClassName, (String[])new String[0]), constructor.getThis(), new ResultHandle[0]);
            constructor.returnVoid();
            LOGGER.debugf("Added a no-args constructor to bean class: %s", (Object)className);
            return transformer.applyTo(classVisitor);
        }
    }

    static class FinalClassTransformFunction
    implements BiFunction<String, ClassVisitor, ClassVisitor> {
        FinalClassTransformFunction() {
        }

        @Override
        public ClassVisitor apply(String className, ClassVisitor classVisitor) {
            ClassTransformer transformer = new ClassTransformer(className);
            transformer.removeModifiers(16);
            LOGGER.debugf("Final flag removed from bean class %s", (Object)className);
            return transformer.applyTo(classVisitor);
        }
    }
}

