/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceSpec;
import io.javaoperatorsdk.operator.api.config.informer.InformerConfiguration;
import io.javaoperatorsdk.operator.api.config.workflow.WorkflowSpec;
import io.javaoperatorsdk.operator.processing.event.rate.RateLimiter;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import io.quarkiverse.operatorsdk.runtime.QuarkusConfigurationService;
import io.quarkiverse.operatorsdk.runtime.QuarkusManagedWorkflow;
import java.time.Duration;
import java.util.Optional;

public class QuarkusControllerConfiguration<P extends HasMetadata>
implements ControllerConfiguration<P> {
    private final InformerConfiguration<P> informerConfig;
    private final String name;
    private final boolean generationAware;
    private final String associatedReconcilerClassName;
    private final Retry retry;
    private final RateLimiter<?> rateLimiter;
    private final Duration maxReconciliationInterval;
    private final String finalizer;
    private final String fieldManager;
    private final QuarkusManagedWorkflow<P> workflow;
    private final String resourceTypeName;
    private final Class<P> resourceClass;
    private QuarkusConfigurationService configurationService;

    public QuarkusControllerConfiguration(InformerConfiguration<P> informerConfig, String name, boolean generationAware, String associatedReconcilerClassName, Retry retry, RateLimiter rateLimiter, Duration maxReconciliationInterval, String finalizer, String fieldManager, QuarkusManagedWorkflow<P> workflow, String resourceTypeName, Class<P> resourceClass) {
        this.informerConfig = informerConfig;
        this.name = name;
        this.generationAware = generationAware;
        this.associatedReconcilerClassName = associatedReconcilerClassName;
        this.retry = retry;
        this.rateLimiter = rateLimiter;
        this.maxReconciliationInterval = maxReconciliationInterval;
        this.finalizer = finalizer;
        this.fieldManager = fieldManager;
        this.workflow = workflow;
        this.resourceTypeName = resourceTypeName;
        this.resourceClass = resourceClass;
    }

    protected void setParent(QuarkusConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public String getName() {
        return this.name;
    }

    public String getFinalizerName() {
        return this.finalizer;
    }

    public boolean isGenerationAware() {
        return this.generationAware;
    }

    public String getAssociatedReconcilerClassName() {
        return this.associatedReconcilerClassName;
    }

    public Retry getRetry() {
        return this.retry;
    }

    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public Optional<WorkflowSpec> getWorkflowSpec() {
        return this.workflow.getGenericSpec();
    }

    public Optional<Duration> maxReconciliationInterval() {
        return Optional.of(this.maxReconciliationInterval);
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public String fieldManager() {
        return this.fieldManager;
    }

    public <C> C getConfigurationFor(DependentResourceSpec<?, P, C> dependentResourceSpec) {
        return dependentResourceSpec.getConfiguration().orElse(null);
    }

    public String getResourceTypeName() {
        return this.resourceTypeName;
    }

    public InformerConfiguration<P> getInformerConfig() {
        return this.informerConfig;
    }

    public Class<P> getResourceClass() {
        return this.resourceClass;
    }

    public QuarkusManagedWorkflow<P> getWorkflow() {
        return this.workflow;
    }
}

