/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jdbc.datasource;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.internal.SqlCommenter;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.jdbc.datasource.JdbcTelemetryBuilder;
import io.opentelemetry.instrumentation.jdbc.datasource.OpenTelemetryDataSource;
import io.opentelemetry.instrumentation.jdbc.internal.DbRequest;
import io.opentelemetry.instrumentation.jdbc.internal.dbinfo.DbInfo;
import javax.sql.DataSource;

public final class JdbcTelemetry {
    private final Instrumenter<DataSource, DbInfo> dataSourceInstrumenter;
    private final Instrumenter<DbRequest, Void> statementInstrumenter;
    private final Instrumenter<DbRequest, Void> transactionInstrumenter;
    private final boolean captureQueryParameters;
    private final SqlCommenter sqlCommenter;

    public static JdbcTelemetry create(OpenTelemetry openTelemetry) {
        return JdbcTelemetry.builder(openTelemetry).build();
    }

    public static JdbcTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new JdbcTelemetryBuilder(openTelemetry);
    }

    JdbcTelemetry(Instrumenter<DataSource, DbInfo> dataSourceInstrumenter, Instrumenter<DbRequest, Void> statementInstrumenter, Instrumenter<DbRequest, Void> transactionInstrumenter, boolean captureQueryParameters, SqlCommenter sqlCommenter) {
        this.dataSourceInstrumenter = dataSourceInstrumenter;
        this.statementInstrumenter = statementInstrumenter;
        this.transactionInstrumenter = transactionInstrumenter;
        this.captureQueryParameters = captureQueryParameters;
        this.sqlCommenter = sqlCommenter;
    }

    public DataSource wrap(DataSource dataSource) {
        return new OpenTelemetryDataSource(dataSource, this.dataSourceInstrumenter, this.statementInstrumenter, this.transactionInstrumenter, this.captureQueryParameters, this.sqlCommenter);
    }
}

