/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.io.mzml.data;

import com.google.common.io.LittleEndianDataInputStream;
import io.github.msdk.MSDKException;
import io.github.msdk.io.mzml.data.MzMLBinaryDataInfo;
import io.github.msdk.io.mzml.util.ByteBufferInputStream;
import io.github.msdk.io.mzml.util.MSNumpress;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.zip.DataFormatException;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.IOUtils;

public class MzMLPeaksDecoder {
    public static float[] decodeToFloat(InputStream inputStream, MzMLBinaryDataInfo binaryDataInfo, float[] data) throws DataFormatException, IOException, MSDKException {
        Integer precision;
        int lengthIn = binaryDataInfo.getEncodedLength();
        int numPoints = binaryDataInfo.getArrayLength();
        InputStream is = null;
        if (inputStream instanceof ByteBufferInputStream) {
            ByteBufferInputStream mappedByteBufferInputStream = (ByteBufferInputStream)inputStream;
            mappedByteBufferInputStream.constrain(binaryDataInfo.getPosition(), lengthIn);
            is = Base64.getDecoder().wrap(mappedByteBufferInputStream);
        } else {
            is = Base64.getDecoder().wrap(inputStream);
        }
        if (lengthIn == 0) {
            return new float[0];
        }
        InflaterInputStream iis = null;
        LittleEndianDataInputStream dis = null;
        byte[] bytes = null;
        if (data == null || data.length < numPoints) {
            data = new float[numPoints];
        }
        if (binaryDataInfo.getCompressionType() != null) {
            switch (binaryDataInfo.getCompressionType()) {
                case ZLIB: 
                case NUMPRESS_LINPRED_ZLIB: 
                case NUMPRESS_POSINT_ZLIB: 
                case NUMPRESS_SHLOGF_ZLIB: {
                    iis = new InflaterInputStream(is);
                    dis = new LittleEndianDataInputStream((InputStream)iis);
                    break;
                }
                default: {
                    dis = new LittleEndianDataInputStream(is);
                }
            }
            switch (binaryDataInfo.getCompressionType()) {
                case NUMPRESS_LINPRED_ZLIB: 
                case NUMPRESS_LINPRED: {
                    bytes = IOUtils.toByteArray((InputStream)dis);
                    int numDecodedDoubles = MSNumpress.decodeLinear(bytes, bytes.length, data);
                    if (numDecodedDoubles < 0) {
                        throw new MSDKException("MSNumpress linear decoder failed");
                    }
                    return data;
                }
                case NUMPRESS_POSINT_ZLIB: 
                case NUMPRESS_POSINT: {
                    bytes = IOUtils.toByteArray((InputStream)dis);
                    int numDecodedDoubles = MSNumpress.decodePic(bytes, bytes.length, data);
                    if (numDecodedDoubles < 0) {
                        throw new MSDKException("MSNumpress positive integer decoder failed");
                    }
                    return data;
                }
                case NUMPRESS_SHLOGF_ZLIB: 
                case NUMPRESS_SHLOGF: {
                    bytes = IOUtils.toByteArray((InputStream)dis);
                    int numDecodedDoubles = MSNumpress.decodeSlof(bytes, bytes.length, data);
                    if (numDecodedDoubles < 0) {
                        throw new MSDKException("MSNumpress short logged float decoder failed");
                    }
                    return data;
                }
            }
        } else {
            dis = new LittleEndianDataInputStream(is);
        }
        switch (binaryDataInfo.getBitLength()) {
            case THIRTY_TWO_BIT_FLOAT: 
            case THIRTY_TWO_BIT_INTEGER: {
                precision = 32;
                break;
            }
            case SIXTY_FOUR_BIT_FLOAT: 
            case SIXTY_FOUR_BIT_INTEGER: {
                precision = 64;
                break;
            }
            default: {
                dis.close();
                throw new IllegalArgumentException("Precision MUST be specified and be either 32-bit or 64-bit, if MS-NUMPRESS compression was not used");
            }
        }
        try {
            switch (precision) {
                case 32: {
                    for (int i = 0; i < numPoints; ++i) {
                        data[i] = dis.readFloat();
                    }
                    break;
                }
                case 64: {
                    for (int i = 0; i < numPoints; ++i) {
                        data[i] = (float)dis.readDouble();
                    }
                    break;
                }
                default: {
                    dis.close();
                    throw new IllegalArgumentException("Precision can only be 32/64 bits, other values are not valid.");
                }
            }
        }
        catch (EOFException eof) {
            throw new MSDKException("Couldn't obtain values. Please make sure the scan/chromatogram passes the Predicate.");
        }
        finally {
            dis.close();
        }
        return data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double[] decodeToDouble(InputStream inputStream, MzMLBinaryDataInfo binaryDataInfo, double[] data) throws DataFormatException, IOException, MSDKException {
        Integer precision;
        int lengthIn = binaryDataInfo.getEncodedLength();
        int numPoints = binaryDataInfo.getArrayLength();
        InputStream is = null;
        if (inputStream instanceof ByteBufferInputStream) {
            ByteBufferInputStream mappedByteBufferInputStream = (ByteBufferInputStream)inputStream;
            mappedByteBufferInputStream.constrain(binaryDataInfo.getPosition(), lengthIn);
            is = Base64.getDecoder().wrap(mappedByteBufferInputStream);
        } else {
            is = Base64.getDecoder().wrap(inputStream);
        }
        if (lengthIn == 0) {
            return new double[0];
        }
        InflaterInputStream iis = null;
        LittleEndianDataInputStream dis = null;
        byte[] bytes = null;
        if (data == null || data.length < numPoints) {
            data = new double[numPoints];
        }
        if (binaryDataInfo.getCompressionType() != null) {
            switch (binaryDataInfo.getCompressionType()) {
                case ZLIB: 
                case NUMPRESS_LINPRED_ZLIB: 
                case NUMPRESS_POSINT_ZLIB: 
                case NUMPRESS_SHLOGF_ZLIB: {
                    iis = new InflaterInputStream(is);
                    dis = new LittleEndianDataInputStream((InputStream)iis);
                    break;
                }
                default: {
                    dis = new LittleEndianDataInputStream(is);
                }
            }
            switch (binaryDataInfo.getCompressionType()) {
                case NUMPRESS_LINPRED_ZLIB: 
                case NUMPRESS_LINPRED: {
                    bytes = IOUtils.toByteArray((InputStream)dis);
                    int numDecodedDoubles = MSNumpress.decodeLinear(bytes, bytes.length, data);
                    if (numDecodedDoubles >= 0) return data;
                    throw new MSDKException("MSNumpress linear decoder failed");
                }
                case NUMPRESS_POSINT_ZLIB: 
                case NUMPRESS_POSINT: {
                    bytes = IOUtils.toByteArray((InputStream)dis);
                    int numDecodedDoubles = MSNumpress.decodePic(bytes, bytes.length, data);
                    if (numDecodedDoubles >= 0) return data;
                    throw new MSDKException("MSNumpress positive integer decoder failed");
                }
                case NUMPRESS_SHLOGF_ZLIB: 
                case NUMPRESS_SHLOGF: {
                    bytes = IOUtils.toByteArray((InputStream)dis);
                    int numDecodedDoubles = MSNumpress.decodeSlof(bytes, bytes.length, data);
                    if (numDecodedDoubles >= 0) return data;
                    throw new MSDKException("MSNumpress short logged float decoder failed");
                }
            }
        } else {
            dis = new LittleEndianDataInputStream(is);
        }
        switch (binaryDataInfo.getBitLength()) {
            case THIRTY_TWO_BIT_FLOAT: 
            case THIRTY_TWO_BIT_INTEGER: {
                precision = 32;
                break;
            }
            case SIXTY_FOUR_BIT_FLOAT: 
            case SIXTY_FOUR_BIT_INTEGER: {
                precision = 64;
                break;
            }
            default: {
                dis.close();
                throw new IllegalArgumentException("Precision MUST be specified and be either 32-bit or 64-bit, if MS-NUMPRESS compression was not used");
            }
        }
        try {
            switch (precision) {
                case 32: {
                    int i = 0;
                    while (i < numPoints) {
                        int asInt = dis.readInt();
                        data[i] = Float.intBitsToFloat(asInt);
                        ++i;
                    }
                    return data;
                }
                case 64: {
                    int i = 0;
                    while (i < numPoints) {
                        long asLong = dis.readLong();
                        data[i] = Double.longBitsToDouble(asLong);
                        ++i;
                    }
                    return data;
                }
            }
            return data;
        }
        catch (EOFException eof) {
            throw new MSDKException("Couldn't obtain values. Please make sure the scan/chromatogram passes the Predicate.");
        }
        finally {
            dis.close();
        }
    }
}

