/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.io.mzml.data;

import io.github.msdk.datamodel.Chromatogram;
import io.github.msdk.datamodel.MsScan;
import io.github.msdk.io.mzml.MzMLFileImportMethod;
import io.github.msdk.io.mzml.data.MzMLBinaryDataInfo;
import io.github.msdk.io.mzml.data.MzMLCVParam;
import io.github.msdk.io.mzml.data.MzMLChromatogram;
import io.github.msdk.io.mzml.data.MzMLCompressionType;
import io.github.msdk.io.mzml.data.MzMLIsolationWindow;
import io.github.msdk.io.mzml.data.MzMLMsScan;
import io.github.msdk.io.mzml.data.MzMLPrecursorActivation;
import io.github.msdk.io.mzml.data.MzMLPrecursorElement;
import io.github.msdk.io.mzml.data.MzMLPrecursorSelectedIon;
import io.github.msdk.io.mzml.data.MzMLPrecursorSelectedIonList;
import io.github.msdk.io.mzml.data.MzMLProduct;
import io.github.msdk.io.mzml.data.MzMLRawDataFile;
import io.github.msdk.io.mzml.data.MzMLReferenceableParamGroup;
import io.github.msdk.io.mzml.data.MzMLScan;
import io.github.msdk.io.mzml.data.MzMLScanWindow;
import io.github.msdk.io.mzml.data.MzMLScanWindowList;
import io.github.msdk.io.mzml.util.TagTracker;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javolution.text.CharArray;
import javolution.xml.internal.stream.XMLStreamReaderImpl;
import javolution.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;

public class MzMLParser {
    private Vars vars = new Vars();
    private TagTracker tracker = new TagTracker();
    private final MzMLRawDataFile newRawFile;
    private final MzMLFileImportMethod importer;

    public MzMLParser(MzMLFileImportMethod importer) {
        this.importer = importer;
        this.newRawFile = new MzMLRawDataFile(importer.getMzMLFile(), this.vars.msFunctionsList, this.vars.spectrumList, this.vars.chromatogramsList);
    }

    public void processOpeningTag(XMLStreamReaderImpl xmlStreamReader, InputStream is, CharArray openingTagName) {
        block101: {
            block103: {
                String refValue;
                block106: {
                    block105: {
                        block104: {
                            MzMLCVParam cvParam;
                            block102: {
                                block100: {
                                    Object id;
                                    this.tracker.enter(openingTagName);
                                    if (this.tracker.inside("referenceableParamGroupList")) {
                                        if (openingTagName.contentEquals((CharSequence)"referenceableParamGroup")) {
                                            id = this.getRequiredAttribute((XMLStreamReader)xmlStreamReader, "id");
                                            this.vars.referenceableParamGroup = new MzMLReferenceableParamGroup(id.toString());
                                        } else if (openingTagName.contentEquals((CharSequence)"cvParam")) {
                                            cvParam = this.createMzMLCVParam((XMLStreamReader)xmlStreamReader);
                                            this.vars.referenceableParamGroup.addCVParam(cvParam);
                                        }
                                    }
                                    if (!this.tracker.inside("spectrumList")) break block100;
                                    if (openingTagName.contentEquals((CharSequence)"spectrum")) {
                                        id = this.getRequiredAttribute((XMLStreamReader)xmlStreamReader, "id").toString();
                                        Integer index = this.getRequiredAttribute((XMLStreamReader)xmlStreamReader, "index").toInt();
                                        this.vars.defaultArrayLength = this.getRequiredAttribute((XMLStreamReader)xmlStreamReader, "defaultArrayLength").toInt();
                                        Integer scanNumber = this.getScanNumber((String)id).orElse(index + 1);
                                        this.vars.spectrum = new MzMLMsScan(this.newRawFile, is, (String)id, scanNumber, this.vars.defaultArrayLength);
                                    } else if (openingTagName.contentEquals((CharSequence)"binaryDataArray")) {
                                        this.vars.skipBinaryDataArray = false;
                                        int encodedLength = this.getRequiredAttribute((XMLStreamReader)xmlStreamReader, "encodedLength").toInt();
                                        CharArray arrayLength = xmlStreamReader.getAttributeValue(null, (CharSequence)"arrayLength");
                                        this.vars.binaryDataInfo = arrayLength != null ? new MzMLBinaryDataInfo(encodedLength, arrayLength.toInt()) : new MzMLBinaryDataInfo(encodedLength, this.vars.defaultArrayLength);
                                    } else if (openingTagName.contentEquals((CharSequence)"scan")) {
                                        this.vars.scan = new MzMLScan();
                                    } else if (openingTagName.contentEquals((CharSequence)"scanWindowList")) {
                                        this.vars.scanWindowList = new MzMLScanWindowList();
                                    } else if (openingTagName.contentEquals((CharSequence)"scanWindow")) {
                                        this.vars.scanWindow = new MzMLScanWindow();
                                    } else if (openingTagName.contentEquals((CharSequence)"cvParam")) {
                                        if (!(this.tracker.inside("binaryDataArrayList") || this.tracker.inside("productList") || this.tracker.inside("precursorList") || this.tracker.inside("scanList") || this.vars.spectrum == null)) {
                                            cvParam = this.createMzMLCVParam((XMLStreamReader)xmlStreamReader);
                                            if (!cvParam.getAccession().equals("MS:1000285")) {
                                                this.vars.spectrum.getCVParams().addCVParam(cvParam);
                                            }
                                        } else if (this.tracker.inside("scanList")) {
                                            cvParam = this.createMzMLCVParam((XMLStreamReader)xmlStreamReader);
                                            if (!this.tracker.inside("scanWindow")) {
                                                if (!this.tracker.inside("scan")) {
                                                    this.vars.spectrum.getScanList().addCVParam(cvParam);
                                                } else {
                                                    this.vars.scan.addCVParam(cvParam);
                                                }
                                            } else {
                                                this.vars.scanWindow.addCVParam(cvParam);
                                            }
                                        } else if (this.tracker.inside("spectrum") && this.tracker.inside("binaryDataArray") && !this.vars.skipBinaryDataArray) {
                                            String accession = this.getRequiredAttribute((XMLStreamReader)xmlStreamReader, "accession").toString();
                                            if (this.vars.binaryDataInfo.isBitLengthAccession(accession)) {
                                                this.vars.binaryDataInfo.setBitLength(accession);
                                            } else if (this.vars.binaryDataInfo.isCompressionTypeAccession(accession)) {
                                                this.manageCompression(this.vars.binaryDataInfo, accession);
                                            } else if (this.vars.binaryDataInfo.isArrayTypeAccession(accession)) {
                                                this.vars.binaryDataInfo.setArrayType(accession);
                                            } else {
                                                this.vars.skipBinaryDataArray = true;
                                            }
                                        }
                                    } else if (openingTagName.contentEquals((CharSequence)"binary")) {
                                        if (this.vars.spectrum != null && !this.vars.skipBinaryDataArray) {
                                            int bomOffset = xmlStreamReader.getLocation().getBomLength();
                                            this.vars.binaryDataInfo.setPosition(xmlStreamReader.getLocation().getCharacterOffset() + bomOffset);
                                        }
                                        if (!this.vars.skipBinaryDataArray) {
                                            if ("MS:1000514".equals(this.vars.binaryDataInfo.getArrayType().getAccession())) {
                                                this.vars.spectrum.setMzBinaryDataInfo(this.vars.binaryDataInfo);
                                            }
                                            if ("MS:1000515".equals(this.vars.binaryDataInfo.getArrayType().getAccession())) {
                                                this.vars.spectrum.setIntensityBinaryDataInfo(this.vars.binaryDataInfo);
                                            }
                                        }
                                    } else if (openingTagName.contentEquals((CharSequence)"referenceableParamGroupRef")) {
                                        refValue = this.getRequiredAttribute((XMLStreamReader)xmlStreamReader, "ref").toString();
                                        for (MzMLReferenceableParamGroup ref : this.vars.referenceableParamGroupList) {
                                            if (!ref.getParamGroupName().equals(refValue)) continue;
                                            this.vars.spectrum.getCVParams().getCVParamsList().addAll(ref.getCVParamsList());
                                            break;
                                        }
                                    } else if (openingTagName.contentEquals((CharSequence)"product")) {
                                        this.vars.product = new MzMLProduct();
                                    }
                                    if (this.tracker.inside("precursorList")) {
                                        if (openingTagName.contentEquals((CharSequence)"precursor")) {
                                            CharArray spectrumRef = xmlStreamReader.getAttributeValue(null, (CharSequence)"spectrumRef");
                                            String spectrumRefString = spectrumRef == null ? null : spectrumRef.toString();
                                            this.vars.precursor = new MzMLPrecursorElement(spectrumRefString);
                                        } else if (openingTagName.contentEquals((CharSequence)"isolationWindow")) {
                                            this.vars.isolationWindow = new MzMLIsolationWindow();
                                        } else if (openingTagName.contentEquals((CharSequence)"selectedIonList")) {
                                            this.vars.selectedIonList = new MzMLPrecursorSelectedIonList();
                                        } else if (openingTagName.contentEquals((CharSequence)"activation")) {
                                            this.vars.activation = new MzMLPrecursorActivation();
                                        } else if (this.tracker.inside("isolationWindow")) {
                                            if (openingTagName.contentEquals((CharSequence)"cvParam")) {
                                                MzMLCVParam cvParam2 = this.createMzMLCVParam((XMLStreamReader)xmlStreamReader);
                                                this.vars.isolationWindow.addCVParam(cvParam2);
                                            }
                                        } else if (this.tracker.inside("selectedIonList")) {
                                            if (openingTagName.contentEquals((CharSequence)"selectedIon")) {
                                                this.vars.selectedIon = new MzMLPrecursorSelectedIon();
                                            } else if (openingTagName.contentEquals((CharSequence)"cvParam")) {
                                                MzMLCVParam cvParam3 = this.createMzMLCVParam((XMLStreamReader)xmlStreamReader);
                                                this.vars.selectedIon.addCVParam(cvParam3);
                                            }
                                        } else if (this.tracker.inside("activation") && openingTagName.contentEquals((CharSequence)"cvParam")) {
                                            MzMLCVParam cvParam4 = this.createMzMLCVParam((XMLStreamReader)xmlStreamReader);
                                            this.vars.activation.addCVParam(cvParam4);
                                        }
                                    }
                                    if (this.tracker.inside("productList")) {
                                        if (openingTagName.contentEquals((CharSequence)"isolationWindow")) {
                                            this.vars.isolationWindow = new MzMLIsolationWindow();
                                        } else if (openingTagName.contentEquals((CharSequence)"cvParam")) {
                                            MzMLCVParam cvParam5 = this.createMzMLCVParam((XMLStreamReader)xmlStreamReader);
                                            this.vars.isolationWindow.addCVParam(cvParam5);
                                        }
                                    }
                                    break block101;
                                }
                                if (!this.tracker.inside("chromatogramList")) break block101;
                                if (!openingTagName.contentEquals((CharSequence)"chromatogram")) break block102;
                                String chromatogramId = this.getRequiredAttribute((XMLStreamReader)xmlStreamReader, "id").toString();
                                Integer chromatogramNumber = this.getRequiredAttribute((XMLStreamReader)xmlStreamReader, "index").toInt() + 1;
                                this.vars.defaultArrayLength = this.getRequiredAttribute((XMLStreamReader)xmlStreamReader, "defaultArrayLength").toInt();
                                this.vars.chromatogram = new MzMLChromatogram(this.newRawFile, is, chromatogramId, chromatogramNumber, this.vars.defaultArrayLength);
                                break block103;
                            }
                            if (!openingTagName.contentEquals((CharSequence)"cvParam")) break block104;
                            if (this.tracker.inside("binaryDataArray") || this.tracker.inside("precursor") || this.tracker.inside("product") || this.vars.chromatogram == null) break block103;
                            cvParam = this.createMzMLCVParam((XMLStreamReader)xmlStreamReader);
                            this.vars.chromatogram.getCVParams().addCVParam(cvParam);
                            break block103;
                        }
                        if (!openingTagName.contentEquals((CharSequence)"binaryDataArray")) break block105;
                        this.vars.skipBinaryDataArray = false;
                        int encodedLength = this.getRequiredAttribute((XMLStreamReader)xmlStreamReader, "encodedLength").toInt();
                        CharArray arrayLength = xmlStreamReader.getAttributeValue(null, (CharSequence)"arrayLength");
                        this.vars.binaryDataInfo = arrayLength != null ? new MzMLBinaryDataInfo(encodedLength, arrayLength.toInt()) : new MzMLBinaryDataInfo(encodedLength, this.vars.defaultArrayLength);
                        break block103;
                    }
                    if (!openingTagName.contentEquals((CharSequence)"binary")) break block106;
                    if (this.vars.chromatogram != null && !this.vars.skipBinaryDataArray) {
                        int bomOffset = xmlStreamReader.getLocation().getBomLength();
                        this.vars.binaryDataInfo.setPosition(xmlStreamReader.getLocation().getCharacterOffset() + bomOffset);
                    }
                    if (this.vars.skipBinaryDataArray) break block103;
                    if ("MS:1000595".equals(this.vars.binaryDataInfo.getArrayType().getAccession())) {
                        this.vars.chromatogram.setRtBinaryDataInfo(this.vars.binaryDataInfo);
                    }
                    if ("MS:1000515".equals(this.vars.binaryDataInfo.getArrayType().getAccession())) {
                        this.vars.chromatogram.setIntensityBinaryDataInfo(this.vars.binaryDataInfo);
                    }
                    break block103;
                }
                if (openingTagName.contentEquals((CharSequence)"referenceableParamGroupRef")) {
                    refValue = xmlStreamReader.getAttributeValue(null, (CharSequence)"ref").toString();
                    for (MzMLReferenceableParamGroup ref : this.vars.referenceableParamGroupList) {
                        if (!ref.getParamGroupName().equals(refValue)) continue;
                        this.vars.chromatogram.getCVParams().getCVParamsList().addAll(ref.getCVParamsList());
                        break;
                    }
                }
            }
            if (this.tracker.inside("chromatogram") && this.tracker.inside("binaryDataArray") && openingTagName.contentEquals((CharSequence)"cvParam") && this.vars.binaryDataInfo != null && !this.vars.skipBinaryDataArray) {
                String accession = this.getRequiredAttribute((XMLStreamReader)xmlStreamReader, "accession").toString();
                if (this.vars.binaryDataInfo.isBitLengthAccession(accession)) {
                    this.vars.binaryDataInfo.setBitLength(accession);
                } else if (this.vars.binaryDataInfo.isCompressionTypeAccession(accession)) {
                    this.manageCompression(this.vars.binaryDataInfo, accession);
                } else if (this.vars.binaryDataInfo.isArrayTypeAccession(accession)) {
                    this.vars.binaryDataInfo.setArrayType(accession);
                } else {
                    this.vars.skipBinaryDataArray = true;
                }
            }
            if (openingTagName.contentEquals((CharSequence)"precursor")) {
                CharArray spectrumRef = xmlStreamReader.getAttributeValue(null, (CharSequence)"spectrumRef");
                String spectrumRefString = spectrumRef == null ? null : spectrumRef.toString();
                this.vars.precursor = new MzMLPrecursorElement(spectrumRefString);
            } else if (openingTagName.contentEquals((CharSequence)"product")) {
                this.vars.product = new MzMLProduct();
            } else if (this.tracker.inside("precursor")) {
                if (openingTagName.contentEquals((CharSequence)"isolationWindow")) {
                    this.vars.isolationWindow = new MzMLIsolationWindow();
                    this.vars.selectedIonList = new MzMLPrecursorSelectedIonList();
                } else if (openingTagName.contentEquals((CharSequence)"activation")) {
                    this.vars.activation = new MzMLPrecursorActivation();
                } else if (this.tracker.inside("isolationWindow")) {
                    if (openingTagName.contentEquals((CharSequence)"cvParam")) {
                        MzMLCVParam cvParam = this.createMzMLCVParam((XMLStreamReader)xmlStreamReader);
                        this.vars.isolationWindow.addCVParam(cvParam);
                    }
                } else if (this.tracker.inside("selectedIonList")) {
                    if (openingTagName.contentEquals((CharSequence)"selectedIon")) {
                        this.vars.selectedIon = new MzMLPrecursorSelectedIon();
                    } else if (openingTagName.contentEquals((CharSequence)"cvParam")) {
                        MzMLCVParam cvParam = this.createMzMLCVParam((XMLStreamReader)xmlStreamReader);
                        this.vars.selectedIon.addCVParam(cvParam);
                    }
                } else if (this.tracker.inside("activation") && openingTagName.contentEquals((CharSequence)"cvParam")) {
                    MzMLCVParam cvParam = this.createMzMLCVParam((XMLStreamReader)xmlStreamReader);
                    this.vars.activation.addCVParam(cvParam);
                }
            } else if (this.tracker.inside("product")) {
                if (openingTagName.contentEquals((CharSequence)"isolationWindow")) {
                    this.vars.isolationWindow = new MzMLIsolationWindow();
                } else if (this.tracker.inside("isolationWindow") && openingTagName.contentEquals((CharSequence)"cvParam")) {
                    MzMLCVParam cvParam = this.createMzMLCVParam((XMLStreamReader)xmlStreamReader);
                    this.vars.isolationWindow.addCVParam(cvParam);
                }
            }
        }
    }

    public void processClosingTag(XMLStreamReaderImpl xmlStreamReader, CharArray closingTagName) {
        this.tracker.exit(closingTagName);
        CharArray s = closingTagName;
        if (s.equals("referenceableParamGroup")) {
            this.vars.referenceableParamGroupList.add(this.vars.referenceableParamGroup);
        } else if (s.equals("isolationWindow")) {
            if (this.tracker.inside("precursor")) {
                this.vars.precursor.setIsolationWindow(this.vars.isolationWindow);
            } else if (this.tracker.inside("product")) {
                this.vars.product.setIsolationWindow(this.vars.isolationWindow);
            }
        } else if (s.equals("product")) {
            if (this.tracker.inside("spectrum")) {
                this.vars.spectrum.getProductList().addProduct(this.vars.product);
            } else if (this.tracker.inside("chromatogram")) {
                this.vars.chromatogram.setProdcut(this.vars.product);
            }
        } else if (s.equals("selectedIonList")) {
            this.vars.precursor.setSelectedIonList(this.vars.selectedIonList);
        } else if (s.equals("activation")) {
            this.vars.precursor.setActivation(this.vars.activation);
        } else if (s.equals("selectedIon")) {
            this.vars.selectedIonList.addSelectedIon(this.vars.selectedIon);
        } else if (s.equals("precursor")) {
            if (this.tracker.inside("spectrum")) {
                this.vars.spectrum.getPrecursorList().addPrecursor(this.vars.precursor);
            } else if (this.tracker.inside("chromatogram")) {
                this.vars.chromatogram.setPrecursor(this.vars.precursor);
            }
        } else if (s.equals("scanWindow")) {
            this.vars.scanWindowList.addScanWindow(this.vars.scanWindow);
        } else if (s.equals("scanWindowList")) {
            if (this.tracker.inside("spectrum")) {
                this.vars.scan.setScanWindowList(this.vars.scanWindowList);
            }
        } else if (s.equals("scan")) {
            if (this.tracker.inside("spectrum")) {
                this.vars.spectrum.getScanList().addScan(this.vars.scan);
            }
        } else if (this.tracker.inside("spectrumList")) {
            if (closingTagName.contentEquals((CharSequence)"spectrum") && this.vars.spectrum.getMzBinaryDataInfo() != null && this.vars.spectrum.getIntensityBinaryDataInfo() != null && (this.importer.getMzMLFile() != null || this.importer.getMsScanPredicate().test(this.vars.spectrum))) {
                this.vars.spectrumList.add(this.vars.spectrum);
            }
        } else if (this.tracker.inside("chromatogramList") && closingTagName.contentEquals((CharSequence)"chromatogram") && this.vars.chromatogram.getRtBinaryDataInfo() != null && this.vars.chromatogram.getIntensityBinaryDataInfo() != null && (this.importer.getMzMLFile() != null || this.importer.getChromatogramPredicate().test(this.vars.chromatogram))) {
            this.vars.chromatogramsList.add(this.vars.chromatogram);
        }
    }

    public void processCharacters(XMLStreamReaderImpl xmlStreamReader) {
        if (!this.newRawFile.getOriginalFile().isPresent() && this.tracker.current().contentEquals((CharSequence)"binary") && !this.vars.skipBinaryDataArray) {
            if (this.tracker.inside("spectrumList") && this.importer.getMsScanPredicate().test(this.vars.spectrum)) {
                this.vars.spectrum.setInputStream(IOUtils.toInputStream((CharSequence)xmlStreamReader.getText()));
                switch (this.vars.binaryDataInfo.getArrayType().getAccession()) {
                    case "MS:1000514": {
                        this.vars.spectrum.getMzValues();
                        break;
                    }
                    case "MS:1000515": {
                        this.vars.spectrum.getIntensityValues();
                    }
                }
            } else if (this.tracker.inside("chromatogramList") && this.importer.getChromatogramPredicate().test(this.vars.chromatogram)) {
                this.vars.chromatogram.setInputStream(IOUtils.toInputStream((CharSequence)xmlStreamReader.getText()));
                switch (this.vars.binaryDataInfo.getArrayType().getAccession()) {
                    case "MS:1000595": {
                        this.vars.chromatogram.getRetentionTimes();
                        break;
                    }
                    case "MS:1000515": {
                        this.vars.chromatogram.getIntensityBinaryDataInfo();
                    }
                }
            }
        }
    }

    private MzMLCVParam createMzMLCVParam(XMLStreamReader xmlStreamReader) {
        CharArray accession = xmlStreamReader.getAttributeValue(null, (CharSequence)"accession");
        CharArray value = xmlStreamReader.getAttributeValue(null, (CharSequence)"value");
        CharArray name = xmlStreamReader.getAttributeValue(null, (CharSequence)"name");
        CharArray unitAccession = xmlStreamReader.getAttributeValue(null, (CharSequence)"unitAccession");
        if (accession == null) {
            throw new IllegalStateException("Any cvParam must have an accession.");
        }
        String valueStr = value == null ? null : value.toString();
        String nameStr = name == null ? null : name.toString();
        String unitAccessionStr = unitAccession == null ? null : unitAccession.toString();
        return new MzMLCVParam(accession.toString(), valueStr, nameStr, unitAccessionStr);
    }

    public Optional<Integer> getScanNumber(String spectrumId) {
        Pattern pattern = Pattern.compile("scan=([0-9]+)");
        Matcher matcher = pattern.matcher(spectrumId);
        boolean scanNumberFound = matcher.find();
        if (scanNumberFound) {
            Integer scanNumber = Integer.parseInt(matcher.group(1));
            return Optional.ofNullable(scanNumber);
        }
        return Optional.ofNullable(null);
    }

    public CharArray getRequiredAttribute(XMLStreamReader xmlStreamReader, String attr) {
        CharArray attrValue = xmlStreamReader.getAttributeValue(null, (CharSequence)attr);
        if (attrValue == null) {
            throw new IllegalStateException("Tag " + xmlStreamReader.getLocalName() + " must provide an `" + attr + "`attribute (Line " + xmlStreamReader.getLocation().getLineNumber() + ")");
        }
        return attrValue;
    }

    public void manageCompression(MzMLBinaryDataInfo binaryInfo, String accession) {
        if (binaryInfo.getCompressionType() == MzMLCompressionType.NO_COMPRESSION) {
            binaryInfo.setCompressionType(accession);
        } else if (binaryInfo.getCompressionType(accession) == MzMLCompressionType.ZLIB) {
            switch (binaryInfo.getCompressionType()) {
                case NUMPRESS_LINPRED: {
                    binaryInfo.setCompressionType(MzMLCompressionType.NUMPRESS_LINPRED_ZLIB);
                    break;
                }
                case NUMPRESS_POSINT: {
                    binaryInfo.setCompressionType(MzMLCompressionType.NUMPRESS_POSINT_ZLIB);
                    break;
                }
                case NUMPRESS_SHLOGF: {
                    binaryInfo.setCompressionType(MzMLCompressionType.NUMPRESS_SHLOGF_ZLIB);
                    break;
                }
            }
        } else {
            switch (binaryInfo.getCompressionType(accession)) {
                case NUMPRESS_LINPRED: {
                    binaryInfo.setCompressionType(MzMLCompressionType.NUMPRESS_LINPRED_ZLIB);
                    break;
                }
                case NUMPRESS_POSINT: {
                    binaryInfo.setCompressionType(MzMLCompressionType.NUMPRESS_POSINT_ZLIB);
                    break;
                }
                case NUMPRESS_SHLOGF: {
                    binaryInfo.setCompressionType(MzMLCompressionType.NUMPRESS_SHLOGF_ZLIB);
                    break;
                }
            }
        }
    }

    public MzMLRawDataFile getMzMLRawFile() {
        return this.newRawFile;
    }

    private static class Vars {
        int defaultArrayLength = 0;
        boolean skipBinaryDataArray = false;
        MzMLMsScan spectrum = null;
        MzMLChromatogram chromatogram = null;
        MzMLBinaryDataInfo binaryDataInfo = null;
        MzMLReferenceableParamGroup referenceableParamGroup = null;
        MzMLPrecursorElement precursor = null;
        MzMLProduct product = null;
        MzMLIsolationWindow isolationWindow = null;
        MzMLPrecursorSelectedIonList selectedIonList = null;
        MzMLPrecursorSelectedIon selectedIon = null;
        MzMLPrecursorActivation activation = null;
        MzMLScan scan = null;
        MzMLScanWindowList scanWindowList = null;
        MzMLScanWindow scanWindow = null;
        ArrayList<MzMLReferenceableParamGroup> referenceableParamGroupList = new ArrayList();
        List<MsScan> spectrumList = new ArrayList<MsScan>();
        List<Chromatogram> chromatogramsList = new ArrayList<Chromatogram>();
        List<String> msFunctionsList = new ArrayList<String>();

        Vars() {
        }
    }
}

