/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.io.mzml;

import io.github.msdk.MSDKException;
import io.github.msdk.MSDKMethod;
import io.github.msdk.datamodel.Chromatogram;
import io.github.msdk.datamodel.MsScan;
import io.github.msdk.datamodel.RawDataFile;
import io.github.msdk.io.mzml.data.MzMLParser;
import io.github.msdk.io.mzml.data.MzMLRawDataFile;
import io.github.msdk.io.mzml.util.ByteBufferInputStream;
import io.github.msdk.io.mzml.util.FileMemoryMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.function.Predicate;
import javolution.text.CharArray;
import javolution.xml.internal.stream.XMLStreamReaderImpl;
import javolution.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MzMLFileImportMethod
implements MSDKMethod<RawDataFile> {
    private final File mzMLFile;
    final InputStream inputStream;
    private MzMLRawDataFile newRawFile;
    private volatile boolean canceled;
    private Float progress;
    private int lastLoggedProgress;
    private Logger logger;
    private Predicate<MsScan> msScanPredicate = s -> true;
    private Predicate<Chromatogram> chromatogramPredicate = c -> true;

    public MzMLFileImportMethod(String mzMLFilePath) {
        this(new File(mzMLFilePath), (MsScan s) -> true, (Chromatogram c) -> true);
    }

    public MzMLFileImportMethod(String mzMLFilePath, Predicate<MsScan> msScanPredicate, Predicate<Chromatogram> chromatogramPredicate) {
        this(new File(mzMLFilePath), msScanPredicate, chromatogramPredicate);
    }

    public MzMLFileImportMethod(Path mzMLFilePath) {
        this(mzMLFilePath.toFile(), (MsScan s) -> false, (Chromatogram c) -> false);
    }

    public MzMLFileImportMethod(Path mzMLFilePath, Predicate<MsScan> msScanPredicate, Predicate<Chromatogram> chromatogramPredicate) {
        this(mzMLFilePath.toFile(), msScanPredicate, chromatogramPredicate);
    }

    public MzMLFileImportMethod(File mzMLFile) {
        this(mzMLFile, null, s -> false, c -> false);
    }

    public MzMLFileImportMethod(File mzMLFile, Predicate<MsScan> msScanPredicate, Predicate<Chromatogram> chromatogramPredicate) {
        this(mzMLFile, null, msScanPredicate, chromatogramPredicate);
    }

    public MzMLFileImportMethod(InputStream inputStream) {
        this(null, inputStream, s -> true, c -> true);
    }

    public MzMLFileImportMethod(InputStream inputStream, Predicate<MsScan> msScanPredicate, Predicate<Chromatogram> chromatogramPredicate) {
        this(null, inputStream, msScanPredicate, chromatogramPredicate);
    }

    private MzMLFileImportMethod(File mzMLFile, InputStream inputStream, Predicate<MsScan> msScanPredicate, Predicate<Chromatogram> chromatogramPredicate) {
        this.mzMLFile = mzMLFile;
        this.inputStream = inputStream;
        this.canceled = false;
        this.progress = Float.valueOf(0.0f);
        this.lastLoggedProgress = 0;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.msScanPredicate = this.msScanPredicate.and(msScanPredicate);
        this.chromatogramPredicate = this.chromatogramPredicate.and(chromatogramPredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MzMLRawDataFile execute() throws MSDKException {
        try {
            InputStream is = null;
            if (this.mzMLFile != null) {
                this.logger.info("Began parsing file: " + this.mzMLFile.getAbsolutePath());
                is = FileMemoryMapper.mapToMemory(this.mzMLFile);
            } else {
                if (this.inputStream == null) throw new MSDKException("Invalid input");
                this.logger.info("Began parsing file from stream");
                is = this.inputStream;
            }
            XMLStreamReaderImpl xmlStreamReader = new XMLStreamReaderImpl();
            xmlStreamReader.setInput(is, "UTF-8");
            MzMLParser parser = new MzMLParser(this);
            this.newRawFile = parser.getMzMLRawFile();
            this.lastLoggedProgress = 0;
            try {
                int eventType;
                do {
                    if (this.canceled) {
                        MzMLRawDataFile mzMLRawDataFile = null;
                        return mzMLRawDataFile;
                    }
                    eventType = xmlStreamReader.next();
                    if (this.mzMLFile != null) {
                        this.progress = Float.valueOf((float)xmlStreamReader.getLocation().getCharacterOffset() / (float)((ByteBufferInputStream)is).length());
                    }
                    if ((int)(this.progress.floatValue() * 100.0f) >= this.lastLoggedProgress + 10) {
                        this.lastLoggedProgress = (int)(this.progress.floatValue() * 10.0f) * 10;
                        this.logger.debug("Parsing in progress... " + this.lastLoggedProgress + "% completed");
                    }
                    switch (eventType) {
                        case 1: {
                            CharArray openingTagName = xmlStreamReader.getLocalName();
                            parser.processOpeningTag(xmlStreamReader, is, openingTagName);
                            break;
                        }
                        case 2: {
                            CharArray closingTagName = xmlStreamReader.getLocalName();
                            parser.processClosingTag(xmlStreamReader, closingTagName);
                            break;
                        }
                        case 4: {
                            parser.processCharacters(xmlStreamReader);
                            break;
                        }
                    }
                } while (eventType != 8);
            }
            finally {
                if (xmlStreamReader != null) {
                    xmlStreamReader.close();
                }
            }
            this.progress = Float.valueOf(1.0f);
            this.logger.info("Parsing Complete");
        }
        catch (IOException | XMLStreamException e) {
            throw new MSDKException(e);
        }
        this.progress = Float.valueOf(1.0f);
        return this.newRawFile;
    }

    public Float getFinishedPercentage() {
        return this.progress;
    }

    public RawDataFile getResult() {
        return this.newRawFile;
    }

    public void cancel() {
        this.canceled = true;
    }

    public Predicate<MsScan> getMsScanPredicate() {
        return this.msScanPredicate;
    }

    public Predicate<Chromatogram> getChromatogramPredicate() {
        return this.chromatogramPredicate;
    }

    public File getMzMLFile() {
        return this.mzMLFile;
    }
}

