/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.io.mzml;

import io.github.msdk.MSDKException;
import io.github.msdk.MSDKMethod;
import io.github.msdk.datamodel.ActivationInfo;
import io.github.msdk.datamodel.Chromatogram;
import io.github.msdk.datamodel.IsolationInfo;
import io.github.msdk.datamodel.MsScan;
import io.github.msdk.datamodel.MsSpectrumType;
import io.github.msdk.datamodel.PolarityType;
import io.github.msdk.datamodel.RawDataFile;
import io.github.msdk.io.mzml.data.MzMLArrayType;
import io.github.msdk.io.mzml.data.MzMLBitLength;
import io.github.msdk.io.mzml.data.MzMLCV;
import io.github.msdk.io.mzml.data.MzMLCVGroup;
import io.github.msdk.io.mzml.data.MzMLCVParam;
import io.github.msdk.io.mzml.data.MzMLCompressionType;
import io.github.msdk.io.mzml.data.MzMLMsScan;
import io.github.msdk.io.mzml.data.MzMLPeaksEncoder;
import io.github.msdk.io.mzml.data.MzMLPrecursorElement;
import io.github.msdk.io.mzml.data.MzMLPrecursorSelectedIon;
import io.github.msdk.io.mzml.data.MzMLProduct;
import io.github.msdk.io.mzml.data.MzMLRawDataFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javolution.xml.internal.stream.XMLStreamWriterImpl;
import javolution.xml.stream.XMLStreamException;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MzMLFileExportMethod
implements MSDKMethod<Void> {
    private static final String dataProcessingId = "MSDK_mzml_export";
    private static final String softwareId = "MSDK";
    private static final String XML_ENCODING = "UTF-8";
    private static final String XML_VERSION = "1.0";
    private static final String MZML_NAMESPACE = "http://psi.hupo.org/ms/mzml";
    private static final String XML_SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XML_SCHEMA_LOCATION = "http://psi.hupo.org/ms/mzml http://psidev.info/files/ms/mzML/xsd/mzML1.1.0.xsd";
    private static final String DEFAULT_VERSION = "1.1.0";
    private static final String CV_REF_MS = "MS";
    private static final String PREFIX_XSI = "xsi";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nonnull
    private final RawDataFile rawDataFile;
    @Nonnull
    private final File target;
    @Nonnull
    private final MzMLCompressionType doubleArrayCompression;
    @Nonnull
    private final MzMLCompressionType floatArrayCompression;
    private boolean canceled = false;
    private long totalScans = 0L;
    private long totalChromatograms = 0L;
    private long parsedScans;
    private long parsedChromatograms;
    private long indexListOffset;

    public MzMLFileExportMethod(@Nonnull RawDataFile rawDataFile, @Nonnull File target, @Nonnull MzMLCompressionType doubleArrayCompression, MzMLCompressionType floatArrayCompression) {
        this.rawDataFile = rawDataFile;
        this.target = target;
        this.doubleArrayCompression = doubleArrayCompression;
        this.floatArrayCompression = floatArrayCompression;
    }

    public Void execute() throws MSDKException {
        this.logger.info("Started export of " + this.rawDataFile.getName() + " to " + this.target);
        List scans = this.rawDataFile.getScans();
        List chromatograms = this.rawDataFile.getChromatograms();
        this.totalScans = scans.size();
        this.totalChromatograms = chromatograms.size();
        ArrayList<Long> spectrumIndices = new ArrayList<Long>();
        ArrayList<Long> chromatogramIndices = new ArrayList<Long>();
        try {
            int i;
            FileOutputStream fos = new FileOutputStream(this.target);
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            DigestOutputStream dos = new DigestOutputStream(fos, sha1);
            dos.on(true);
            XMLStreamWriterImpl xmlStreamWriter = new XMLStreamWriterImpl();
            xmlStreamWriter.setOutput((OutputStream)dos);
            xmlStreamWriter.setDefaultNamespace((CharSequence)MZML_NAMESPACE);
            xmlStreamWriter.setPrefix((CharSequence)PREFIX_XSI, (CharSequence)XML_SCHEMA_INSTANCE);
            xmlStreamWriter.writeStartDocument((CharSequence)XML_ENCODING, (CharSequence)XML_VERSION);
            xmlStreamWriter.writeStartElement((CharSequence)"indexedmzML");
            xmlStreamWriter.writeDefaultNamespace((CharSequence)MZML_NAMESPACE);
            xmlStreamWriter.writeNamespace((CharSequence)PREFIX_XSI, (CharSequence)XML_SCHEMA_INSTANCE);
            xmlStreamWriter.writeAttribute((CharSequence)XML_SCHEMA_INSTANCE, (CharSequence)"schemeLocation", (CharSequence)XML_SCHEMA_LOCATION);
            xmlStreamWriter.writeStartElement((CharSequence)"mzML");
            xmlStreamWriter.writeDefaultNamespace((CharSequence)MZML_NAMESPACE);
            xmlStreamWriter.writeNamespace((CharSequence)PREFIX_XSI, (CharSequence)XML_SCHEMA_INSTANCE);
            xmlStreamWriter.writeAttribute((CharSequence)XML_SCHEMA_INSTANCE, (CharSequence)"schemeLocation", (CharSequence)XML_SCHEMA_LOCATION);
            xmlStreamWriter.writeAttribute((CharSequence)"id", (CharSequence)this.rawDataFile.getName());
            xmlStreamWriter.writeAttribute((CharSequence)"version", (CharSequence)DEFAULT_VERSION);
            xmlStreamWriter.writeStartElement((CharSequence)"cvList");
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement((CharSequence)"dataProcessingList");
            xmlStreamWriter.writeAttribute((CharSequence)"count", (CharSequence)"1");
            xmlStreamWriter.writeStartElement((CharSequence)"dataProcessing");
            xmlStreamWriter.writeAttribute((CharSequence)"id", (CharSequence)dataProcessingId);
            xmlStreamWriter.writeStartElement((CharSequence)"processingMethod");
            xmlStreamWriter.writeAttribute((CharSequence)"softwareRef", (CharSequence)softwareId);
            xmlStreamWriter.writeAttribute((CharSequence)"order", (CharSequence)"0");
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement((CharSequence)"run");
            xmlStreamWriter.writeAttribute((CharSequence)"id", (CharSequence)this.rawDataFile.getName());
            xmlStreamWriter.writeStartElement((CharSequence)"spectrumList");
            xmlStreamWriter.writeAttribute((CharSequence)"count", (CharSequence)String.valueOf(scans.size()));
            byte[] mzBuffer = null;
            byte[] intensityBuffer = null;
            for (MsScan scan : scans) {
                if (this.canceled) {
                    dos.close();
                    fos.close();
                    xmlStreamWriter.close();
                    this.target.delete();
                    return null;
                }
                spectrumIndices.add(xmlStreamWriter.getLocation().getCharacterOffsetInLong());
                xmlStreamWriter.writeStartElement((CharSequence)"spectrum");
                xmlStreamWriter.writeAttribute((CharSequence)"index", (CharSequence)String.valueOf(this.parsedScans));
                xmlStreamWriter.writeAttribute((CharSequence)"id", (CharSequence)("scan=" + scan.getScanNumber()));
                xmlStreamWriter.writeAttribute((CharSequence)"defaultArrayLength", (CharSequence)String.valueOf(scan.getNumberOfDataPoints()));
                Object spectrum = null;
                if (scan instanceof MzMLMsScan) {
                    spectrum = (MzMLMsScan)scan;
                }
                if (!(this.rawDataFile instanceof MzMLRawDataFile) || this.rawDataFile instanceof MzMLRawDataFile && !((MzMLMsScan)spectrum).getCVValue("MS:1000127").isPresent() && !((MzMLMsScan)spectrum).getCVValue("MS:1000128").isPresent()) {
                    if (scan.getSpectrumType() == MsSpectrumType.CENTROIDED) {
                        this.writeCVParam(xmlStreamWriter, MzMLCV.centroidCvParam);
                    } else {
                        this.writeCVParam(xmlStreamWriter, MzMLCV.profileCvParam);
                    }
                }
                if ((!(this.rawDataFile instanceof MzMLRawDataFile) || this.rawDataFile instanceof MzMLRawDataFile && !((MzMLMsScan)spectrum).getCVValue("MS:1000511").isPresent()) && scan.getMsLevel() != null) {
                    Integer msLevel = scan.getMsLevel();
                    this.writeCVParam(xmlStreamWriter, new MzMLCVParam("MS:1000511", String.valueOf(msLevel), "ms level", null));
                }
                if ((!(this.rawDataFile instanceof MzMLRawDataFile) || this.rawDataFile instanceof MzMLRawDataFile && !((MzMLMsScan)spectrum).getCVValue("MS:1000285").isPresent()) && scan.getTIC() != null) {
                    Float tic = scan.getTIC();
                    this.writeCVParam(xmlStreamWriter, new MzMLCVParam("MS:1000285", String.valueOf(tic), "total ion current", null));
                }
                if ((!(this.rawDataFile instanceof MzMLRawDataFile) || this.rawDataFile instanceof MzMLRawDataFile && !((MzMLMsScan)spectrum).getCVValue("MS:1000528").isPresent() || !((MzMLMsScan)spectrum).getCVValue("MS:1000527").isPresent()) && scan.getMzRange() != null) {
                    Double lowestMz = (Double)scan.getMzRange().lowerEndpoint();
                    Double highestMz = (Double)scan.getMzRange().upperEndpoint();
                    this.writeCVParam(xmlStreamWriter, new MzMLCVParam("MS:1000528", String.valueOf(lowestMz), "lowest observed m/z", "MS:1000040"));
                    this.writeCVParam(xmlStreamWriter, new MzMLCVParam("MS:1000527", String.valueOf(highestMz), "highest observed m/z", "MS:1000040"));
                }
                if (this.rawDataFile instanceof MzMLRawDataFile) {
                    this.writeCVGroup(xmlStreamWriter, ((MzMLMsScan)spectrum).getCVParams());
                }
                xmlStreamWriter.writeStartElement((CharSequence)"scanList");
                xmlStreamWriter.writeAttribute((CharSequence)"count", (CharSequence)"1");
                xmlStreamWriter.writeStartElement((CharSequence)"scan");
                if (scan.getScanDefinition() != null) {
                    String scanDefinition = scan.getScanDefinition();
                    this.writeCVParam(xmlStreamWriter, new MzMLCVParam("MS:1000512", scanDefinition, "filter string", null));
                }
                if (scan.getRetentionTime() != null) {
                    Float rt = scan.getRetentionTime();
                    this.writeCVParam(xmlStreamWriter, new MzMLCVParam("MS:1000016", String.valueOf(rt), "scan time", "UO:0000010"));
                }
                if (scan.getPolarity() == PolarityType.POSITIVE) {
                    this.writeCVParam(xmlStreamWriter, MzMLCV.polarityPositiveCvParam);
                } else if (scan.getPolarity() == PolarityType.NEGATIVE) {
                    this.writeCVParam(xmlStreamWriter, MzMLCV.polarityNegativeCvParam);
                }
                xmlStreamWriter.writeStartElement((CharSequence)"scanWindowList");
                xmlStreamWriter.writeAttribute((CharSequence)"count", (CharSequence)"1");
                xmlStreamWriter.writeStartElement((CharSequence)"scanWindow");
                if (scan.getScanningRange() != null) {
                    Iterator<MzMLProduct> lowerLimit = (Double)scan.getScanningRange().lowerEndpoint();
                    Double upperLimit = (Double)scan.getScanningRange().upperEndpoint();
                    this.writeCVParam(xmlStreamWriter, new MzMLCVParam("MS:1000501", String.valueOf(lowerLimit), "scan window lower limit", "MS:1000040"));
                    this.writeCVParam(xmlStreamWriter, new MzMLCVParam("MS:1000500", String.valueOf(upperLimit), "scan window upper limit", "MS:1000040"));
                }
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndElement();
                if (this.rawDataFile instanceof MzMLRawDataFile && ((MzMLMsScan)spectrum).getPrecursorList().getPrecursorElements().size() > 0) {
                    xmlStreamWriter.writeStartElement((CharSequence)"precursorList");
                    xmlStreamWriter.writeAttribute((CharSequence)"count", (CharSequence)String.valueOf(((MzMLMsScan)spectrum).getPrecursorList().getPrecursorElements().size()));
                    for (MzMLPrecursorElement precursor : ((MzMLMsScan)spectrum).getPrecursorList().getPrecursorElements()) {
                        xmlStreamWriter.writeStartElement((CharSequence)"precursor");
                        xmlStreamWriter.writeAttribute((CharSequence)"spectrumRef", (CharSequence)precursor.getSpectrumRef().orElse(""));
                        if (precursor.getSelectedIonList().isPresent()) {
                            xmlStreamWriter.writeStartElement((CharSequence)"selectedIonList");
                            xmlStreamWriter.writeAttribute((CharSequence)"count", (CharSequence)String.valueOf(precursor.getSelectedIonList().get().getSelectedIonList().size()));
                            for (MzMLPrecursorSelectedIon selectedIon : precursor.getSelectedIonList().get().getSelectedIonList()) {
                                xmlStreamWriter.writeStartElement((CharSequence)"selectedIon");
                                this.writeCVGroup(xmlStreamWriter, selectedIon);
                                xmlStreamWriter.writeEndElement();
                            }
                            xmlStreamWriter.writeEndElement();
                        }
                        xmlStreamWriter.writeEndElement();
                        if (precursor.getIsolationWindow().isPresent()) {
                            xmlStreamWriter.writeStartElement((CharSequence)"isolationWindow");
                            this.writeCVGroup(xmlStreamWriter, precursor.getIsolationWindow().get());
                            xmlStreamWriter.writeEndElement();
                        }
                        xmlStreamWriter.writeStartElement((CharSequence)"activation");
                        this.writeCVGroup(xmlStreamWriter, precursor.getActivation());
                        xmlStreamWriter.writeEndElement();
                    }
                    xmlStreamWriter.writeEndElement();
                    if (!((MzMLMsScan)spectrum).getProductList().getProducts().isEmpty()) {
                        xmlStreamWriter.writeStartElement((CharSequence)"productList");
                        xmlStreamWriter.writeAttribute((CharSequence)"count", (CharSequence)String.valueOf(((MzMLMsScan)spectrum).getProductList().getProducts().size()));
                        for (MzMLProduct product : ((MzMLMsScan)spectrum).getProductList().getProducts()) {
                            xmlStreamWriter.writeStartElement((CharSequence)"product");
                            xmlStreamWriter.writeStartElement((CharSequence)"isolationWindow");
                            if (product.getIsolationWindow().isPresent()) {
                                this.writeCVGroup(xmlStreamWriter, product.getIsolationWindow().get());
                            }
                            xmlStreamWriter.writeEndElement();
                            xmlStreamWriter.writeEndElement();
                        }
                        xmlStreamWriter.writeEndElement();
                    }
                }
                xmlStreamWriter.writeStartElement((CharSequence)"binaryDataArrayList");
                xmlStreamWriter.writeAttribute((CharSequence)"count", (CharSequence)"2");
                mzBuffer = MzMLPeaksEncoder.encodeDouble(scan.getMzValues(), this.doubleArrayCompression);
                xmlStreamWriter.writeStartElement((CharSequence)"binaryDataArray");
                xmlStreamWriter.writeAttribute((CharSequence)"encodedLength", (CharSequence)String.valueOf(mzBuffer.length));
                this.writeCVParam(xmlStreamWriter, new MzMLCVParam(MzMLBitLength.SIXTY_FOUR_BIT_FLOAT.getValue(), "", "64-bit float", null));
                this.writeCVParam(xmlStreamWriter, new MzMLCVParam(this.doubleArrayCompression.getAccession(), "", this.doubleArrayCompression.getName(), null));
                this.writeCVParam(xmlStreamWriter, new MzMLCVParam(MzMLArrayType.MZ.getAccession(), "", "m/z array", "MS:1000040"));
                xmlStreamWriter.writeStartElement((CharSequence)"binary");
                xmlStreamWriter.writeCharacters((CharSequence)new String(mzBuffer));
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndElement();
                intensityBuffer = MzMLPeaksEncoder.encodeFloat(scan.getIntensityValues(), this.floatArrayCompression);
                xmlStreamWriter.writeStartElement((CharSequence)"binaryDataArray");
                xmlStreamWriter.writeAttribute((CharSequence)"encodedLength", (CharSequence)String.valueOf(intensityBuffer.length));
                this.writeCVParam(xmlStreamWriter, new MzMLCVParam(MzMLBitLength.THIRTY_TWO_BIT_FLOAT.getValue(), "", "32-bit float", null));
                this.writeCVParam(xmlStreamWriter, new MzMLCVParam(this.floatArrayCompression.getAccession(), "", this.floatArrayCompression.getName(), null));
                this.writeCVParam(xmlStreamWriter, new MzMLCVParam(MzMLArrayType.INTENSITY.getAccession(), "", "intensity array", "MS:1000131"));
                xmlStreamWriter.writeStartElement((CharSequence)"binary");
                xmlStreamWriter.writeCharacters((CharSequence)new String(intensityBuffer));
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndElement();
                ++this.parsedScans;
            }
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement((CharSequence)"chromatogramList");
            xmlStreamWriter.writeAttribute((CharSequence)"count", (CharSequence)String.valueOf(chromatograms.size()));
            byte[] rtBuffer = null;
            byte[] intensityBuffer2 = null;
            for (Chromatogram chromatogram : chromatograms) {
                if (this.canceled) {
                    dos.close();
                    fos.close();
                    xmlStreamWriter.close();
                    this.target.delete();
                    return null;
                }
                chromatogramIndices.add(xmlStreamWriter.getLocation().getCharacterOffsetInLong());
                xmlStreamWriter.writeStartElement((CharSequence)"chromatogram");
                xmlStreamWriter.writeAttribute((CharSequence)"index", (CharSequence)String.valueOf(this.parsedChromatograms));
                xmlStreamWriter.writeAttribute((CharSequence)"id", (CharSequence)chromatogram.getChromatogramType().name());
                xmlStreamWriter.writeAttribute((CharSequence)"defaultArrayLength", (CharSequence)String.valueOf(chromatogram.getNumberOfDataPoints()));
                switch (chromatogram.getChromatogramType()) {
                    case BPC: {
                        this.writeCVParam(xmlStreamWriter, new MzMLCVParam("MS:1000628", "", "basepeak chromatogram", null));
                        break;
                    }
                    case MRM_SRM: {
                        this.writeCVParam(xmlStreamWriter, new MzMLCVParam("MS:1001473", "", "selected reaction monitoring chromatogram", null));
                        break;
                    }
                    case SIC: {
                        this.writeCVParam(xmlStreamWriter, new MzMLCVParam("MS:1000627", "", "selected ion current chromatogram", null));
                        break;
                    }
                    case TIC: {
                        this.writeCVParam(xmlStreamWriter, new MzMLCVParam("MS:1000235", "", "total ion current chromatogram", null));
                        break;
                    }
                }
                if (!chromatogram.getIsolations().isEmpty()) {
                    IsolationInfo isolationInfo = (IsolationInfo)chromatogram.getIsolations().get(0);
                    xmlStreamWriter.writeStartElement((CharSequence)"precursor");
                    if (isolationInfo.getPrecursorMz() != null) {
                        xmlStreamWriter.writeStartElement((CharSequence)"isolationWindow");
                        Double mz = isolationInfo.getPrecursorMz();
                        this.writeCVParam(xmlStreamWriter, new MzMLCVParam("MS:1000827", String.valueOf(mz), "isolation window target m/z", "MS:1000040"));
                        xmlStreamWriter.writeEndElement();
                    }
                    if (isolationInfo.getActivationInfo() != null) {
                        xmlStreamWriter.writeStartElement((CharSequence)"activation");
                        ActivationInfo activationInfo = isolationInfo.getActivationInfo();
                        switch (activationInfo.getActivationType()) {
                            case CID: {
                                this.writeCVParam(xmlStreamWriter, new MzMLCVParam("MS:1000133", "", "collision-induced dissociation", null));
                                break;
                            }
                        }
                        if (activationInfo.getActivationEnergy() != null) {
                            this.writeCVParam(xmlStreamWriter, new MzMLCVParam("MS:1000045", String.valueOf(activationInfo.getActivationEnergy()), "collision energy", null));
                        }
                        xmlStreamWriter.writeEndElement();
                    }
                    xmlStreamWriter.writeEndElement();
                }
                if (chromatogram.getMz() != null) {
                    xmlStreamWriter.writeStartElement((CharSequence)"product");
                    xmlStreamWriter.writeStartElement((CharSequence)"isolationWindow");
                    Double mz = chromatogram.getMz();
                    this.writeCVParam(xmlStreamWriter, new MzMLCVParam("MS:1000827", String.valueOf(mz), "isolation window target m/z", "MS:1000040"));
                    xmlStreamWriter.writeEndElement();
                    xmlStreamWriter.writeEndElement();
                }
                xmlStreamWriter.writeStartElement((CharSequence)"binaryDataArrayList");
                xmlStreamWriter.writeAttribute((CharSequence)"count", (CharSequence)"2");
                rtBuffer = MzMLPeaksEncoder.encodeFloat(chromatogram.getRetentionTimes(null), this.floatArrayCompression);
                xmlStreamWriter.writeStartElement((CharSequence)"binaryDataArray");
                xmlStreamWriter.writeAttribute((CharSequence)"encodedLength", (CharSequence)String.valueOf(rtBuffer.length));
                this.writeCVParam(xmlStreamWriter, new MzMLCVParam(MzMLBitLength.THIRTY_TWO_BIT_FLOAT.getValue(), "", "32-bit float", null));
                this.writeCVParam(xmlStreamWriter, new MzMLCVParam(this.floatArrayCompression.getAccession(), "", this.floatArrayCompression.getName(), null));
                this.writeCVParam(xmlStreamWriter, new MzMLCVParam(MzMLArrayType.TIME.getAccession(), "", "time array", "UO:0000031"));
                xmlStreamWriter.writeStartElement((CharSequence)"binary");
                xmlStreamWriter.writeCharacters((CharSequence)new String(rtBuffer));
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndElement();
                intensityBuffer2 = MzMLPeaksEncoder.encodeFloat(chromatogram.getIntensityValues(), this.floatArrayCompression);
                xmlStreamWriter.writeStartElement((CharSequence)"binaryDataArray");
                xmlStreamWriter.writeAttribute((CharSequence)"encodedLength", (CharSequence)String.valueOf(intensityBuffer2.length));
                this.writeCVParam(xmlStreamWriter, new MzMLCVParam(MzMLBitLength.THIRTY_TWO_BIT_FLOAT.getValue(), "", "32-bit float", null));
                this.writeCVParam(xmlStreamWriter, new MzMLCVParam(this.floatArrayCompression.getAccession(), "", this.floatArrayCompression.getName(), null));
                this.writeCVParam(xmlStreamWriter, new MzMLCVParam(MzMLArrayType.INTENSITY.getAccession(), "", "intensity array", "MS:1000131"));
                xmlStreamWriter.writeStartElement((CharSequence)"binary");
                xmlStreamWriter.writeCharacters((CharSequence)new String(intensityBuffer2));
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndElement();
                ++this.parsedChromatograms;
            }
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            this.indexListOffset = xmlStreamWriter.getLocation().getCharacterOffsetInLong();
            xmlStreamWriter.writeStartElement((CharSequence)"indexList");
            xmlStreamWriter.writeAttribute((CharSequence)"count", (CharSequence)"2");
            xmlStreamWriter.writeStartElement((CharSequence)"index");
            xmlStreamWriter.writeAttribute((CharSequence)"name", (CharSequence)"spectrum");
            for (i = 0; i < scans.size(); ++i) {
                xmlStreamWriter.writeStartElement((CharSequence)"offset");
                xmlStreamWriter.writeAttribute((CharSequence)"idRef", (CharSequence)("scan=" + ((MsScan)scans.get(i)).getScanNumber()));
                xmlStreamWriter.writeCharacters((CharSequence)String.valueOf(spectrumIndices.get(i)));
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement((CharSequence)"index");
            xmlStreamWriter.writeAttribute((CharSequence)"name", (CharSequence)"chromatogram");
            for (i = 0; i < chromatograms.size(); ++i) {
                xmlStreamWriter.writeStartElement((CharSequence)"offset");
                xmlStreamWriter.writeAttribute((CharSequence)"idRef", (CharSequence)((Chromatogram)chromatograms.get(i)).getChromatogramType().name());
                xmlStreamWriter.writeCharacters((CharSequence)String.valueOf(chromatogramIndices.get(i)));
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement((CharSequence)"indexListOffset");
            xmlStreamWriter.writeCharacters((CharSequence)String.valueOf(this.indexListOffset));
            xmlStreamWriter.writeEndElement();
            dos.on(false);
            String sha1Checksum = DigestUtils.shaHex((byte[])sha1.digest());
            xmlStreamWriter.writeStartElement((CharSequence)"fileChecksum");
            xmlStreamWriter.writeCharacters((CharSequence)sha1Checksum);
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndDocument();
            xmlStreamWriter.close();
        }
        catch (Exception e) {
            throw new MSDKException((Throwable)e);
        }
        return null;
    }

    public Float getFinishedPercentage() {
        return this.totalScans + this.totalChromatograms == 0L ? null : Float.valueOf((float)(this.parsedScans + this.parsedChromatograms) / (float)(this.totalScans + this.totalChromatograms));
    }

    public Void getResult() {
        return null;
    }

    public void cancel() {
        this.canceled = true;
    }

    private void writeCVParam(XMLStreamWriterImpl xmlStreamWriter, MzMLCVParam cvParam) throws XMLStreamException {
        xmlStreamWriter.writeStartElement((CharSequence)"cvParam");
        xmlStreamWriter.writeAttribute((CharSequence)"cvRef", (CharSequence)CV_REF_MS);
        xmlStreamWriter.writeAttribute((CharSequence)"accession", (CharSequence)cvParam.getAccession());
        Optional<String> value = cvParam.getValue();
        Optional<String> name = cvParam.getName();
        Optional<String> unitAccession = cvParam.getUnitAccession();
        if (name.isPresent()) {
            xmlStreamWriter.writeAttribute((CharSequence)"name", (CharSequence)name.get());
        }
        xmlStreamWriter.writeAttribute((CharSequence)"value", (CharSequence)value.orElse(""));
        if (unitAccession.isPresent()) {
            xmlStreamWriter.writeAttribute((CharSequence)"unitAccession", (CharSequence)unitAccession.get());
        }
        xmlStreamWriter.writeEndElement();
    }

    private void writeCVGroup(XMLStreamWriterImpl xmlStreamWriter, MzMLCVGroup cvGroup) throws XMLStreamException {
        for (MzMLCVParam cvParam : cvGroup.getCVParamsList()) {
            this.writeCVParam(xmlStreamWriter, cvParam);
        }
    }
}

