/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.http.handler.user;

import com.softwaremill.quicklens.package;
import io.gatling.recorder.http.HttpProxy;
import io.gatling.recorder.http.handler.ScalaChannelHandler;
import io.gatling.recorder.http.handler.user.UserHandler;
import io.gatling.recorder.http.model.SafeHttpRequest;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.asynchttpclient.uri.Uri;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001!3Q!\u0001\u0002\u0001\u00059\u0011q\u0002\u0013;uaV\u001bXM\u001d%b]\u0012dWM\u001d\u0006\u0003\u0007\u0011\tA!^:fe*\u0011QAB\u0001\bQ\u0006tG\r\\3s\u0015\t9\u0001\"\u0001\u0003iiR\u0004(BA\u0005\u000b\u0003!\u0011XmY8sI\u0016\u0014(BA\u0006\r\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011!D\u0001\u0003S>\u001c2\u0001A\b\u0014!\t\u0001\u0012#D\u0001\u0003\u0013\t\u0011\"AA\u0006Vg\u0016\u0014\b*\u00198eY\u0016\u0014\bC\u0001\u000b\u0016\u001b\u0005!\u0011B\u0001\f\u0005\u0005M\u00196-\u00197b\u0007\"\fgN\\3m\u0011\u0006tG\r\\3s\u0011!A\u0002A!A!\u0002\u0013Q\u0012!\u00029s_bL8\u0001\u0001\t\u00037qi\u0011AB\u0005\u0003;\u0019\u0011\u0011\u0002\u0013;uaB\u0013x\u000e_=\t\u000b}\u0001A\u0011\u0001\u0011\u0002\rqJg.\u001b;?)\t\t#\u0005\u0005\u0002\u0011\u0001!)\u0001D\ba\u00015!)A\u0005\u0001C\u0005K\u0005aqO]5uKJ+\u0017/^3tiR\u0019a\u0005\f\u001c\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u0006[\r\u0002\rAL\u0001\fkN,'o\u00115b]:,G\u000e\u0005\u00020i5\t\u0001G\u0003\u00022e\u000591\r[1o]\u0016d'BA\u001a\r\u0003\u0015qW\r\u001e;z\u0013\t)\u0004GA\u0004DQ\u0006tg.\u001a7\t\u000b]\u001a\u0003\u0019\u0001\u001d\u0002\u000fI,\u0017/^3tiB\u0011\u0011\bP\u0007\u0002u)\u00111HB\u0001\u0006[>$W\r\\\u0005\u0003{i\u0012qbU1gK\"#H\u000f\u001d*fcV,7\u000f\u001e\u0005\u0006\u007f\u0001!I\u0001Q\u0001\u001boJLG/\u001a*fcV,7\u000f^,ji\"tUm^\"iC:tW\r\u001c\u000b\u0004M\u0005\u0013\u0005\"B\u0017?\u0001\u0004q\u0003\"B\u001c?\u0001\u0004A\u0004\"\u0002#\u0001\t\u0003*\u0015\u0001\u00059s_B\fw-\u0019;f%\u0016\fX/Z:u)\r1ci\u0012\u0005\u0006[\r\u0003\rA\f\u0005\u0006o\r\u0003\r\u0001\u000f")
public class HttpUserHandler
extends UserHandler
implements ScalaChannelHandler {
    private final HttpProxy proxy;

    @Override
    public ChannelFutureListener function2ChannelFutureListener(Function1<ChannelFuture, Object> f) {
        return ScalaChannelHandler.function2ChannelFutureListener$(this, f);
    }

    @Override
    public GenericFutureListener<Future<Channel>> function2GenericFutureListener(Function1<Future<Channel>, Object> f) {
        return ScalaChannelHandler.function2GenericFutureListener$(this, f);
    }

    private void writeRequest(Channel userChannel, SafeHttpRequest request) {
        SafeHttpRequest safeHttpRequest;
        Option<Tuple2<String, Object>> option = this.proxy.outgoingProxy();
        if (None$.MODULE$.equals(option)) {
            SafeHttpRequest fresh$macro$3 = request;
            safeHttpRequest = (SafeHttpRequest)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable & scala.Serializable)(fresh$macro$1, fresh$macro$2) -> {
                String x$2 = (String)fresh$macro$2.apply((Object)fresh$macro$1.uri());
                HttpVersion x$3 = fresh$macro$1.copy$default$1();
                HttpMethod x$4 = fresh$macro$1.copy$default$2();
                HttpHeaders x$5 = fresh$macro$1.copy$default$4();
                HttpHeaders x$6 = fresh$macro$1.copy$default$5();
                byte[] x$7 = fresh$macro$1.copy$default$6();
                return fresh$macro$1.copy(x$3, x$4, x$2, x$5, x$6, x$7);
            }).using((Function1 & Serializable & scala.Serializable)uri -> Uri.create((String)uri).toRelativeUrl());
        } else {
            safeHttpRequest = request;
        }
        SafeHttpRequest remoteRequest = safeHttpRequest;
        this.writeRequestToRemote(userChannel, remoteRequest, request);
    }

    private void writeRequestWithNewChannel(Channel userChannel, SafeHttpRequest request) {
        InetSocketAddress inetSocketAddress;
        Some some;
        Tuple2 tuple2;
        this._remoteChannel_$eq((Option<Channel>)None$.MODULE$);
        boolean bl = false;
        Option<Tuple2<String, Object>> option = null;
        Option<Tuple2<String, Object>> option2 = this.proxy.outgoingProxy();
        if (option2 instanceof Some && (tuple2 = (Tuple2)(some = (Some)option2).value()) != null) {
            String host = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            inetSocketAddress = new InetSocketAddress(host, port);
        } else {
            if (None$.MODULE$.equals(option2)) {
                bl = true;
                option = option2;
                if (request.uri().startsWith("/")) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request url ", " is relative, you're probably directly hitting the proxy"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.uri()})));
                }
            }
            if (bl) {
                InetSocketAddress inetSocketAddress2;
                try {
                    inetSocketAddress2 = this.computeInetSocketAddress(Uri.create((String)request.uri()));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option3 = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option3.isEmpty()) {
                        Throwable e = (Throwable)option3.get();
                        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not build address requestURI='", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.uri()})), e);
                    }
                    throw throwable;
                }
                inetSocketAddress = inetSocketAddress2;
            } else {
                throw new MatchError(option2);
            }
        }
        InetSocketAddress inetSocketAddress3 = inetSocketAddress;
        this.proxy.remoteBootstrap().connect((SocketAddress)inetSocketAddress3).addListener(future -> {
            if (future.isSuccess()) {
                Channel remoteChannel = future.channel();
                this.setupRemoteChannel(userChannel, remoteChannel, $this.proxy.controller(), false, false);
                this.writeRequest(userChannel, request);
            } else {
                BoxedUnit boxedUnit;
                Throwable t = future.cause();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(t.getMessage(), t);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                userChannel.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND));
            }
        });
    }

    @Override
    public void propagateRequest(Channel userChannel, SafeHttpRequest request) {
        Some some;
        Channel remoteChannel;
        Option<Channel> option = this._remoteChannel();
        if (option instanceof Some && (remoteChannel = (Channel)(some = (Some)option).value()).isActive()) {
            BoxedUnit boxedUnit;
            InetSocketAddress remoteAddress = (InetSocketAddress)remoteChannel.remoteAddress();
            Uri requestUri = Uri.create((String)request.uri());
            String string = remoteAddress.getHostString();
            String string2 = requestUri.getHost();
            if ((string != null ? !string.equals(string2) : string2 != null) || remoteAddress.getPort() != this.defaultPort(requestUri)) {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("User channel {} remote peer {} is not connected to the proper host, closing it", (Object[])new Channel[]{userChannel, remoteChannel});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                remoteChannel.close();
                this.writeRequestWithNewChannel(userChannel, request);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.writeRequest(userChannel, request);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            this.writeRequestWithNewChannel(userChannel, request);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public HttpUserHandler(HttpProxy proxy) {
        this.proxy = proxy;
        super(proxy);
        ScalaChannelHandler.$init$(this);
    }
}

