/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.pool;

import io.gatling.http.client.pool.ChannelPoolKey;
import io.gatling.http.client.pool.CoalescingChannelPool;
import io.gatling.http.client.pool.IpAndPort;
import io.gatling.http.client.pool.RemoteKey;
import io.gatling.http.client.util.Assertions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChannelPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelPool.class);
    private static final AttributeKey<ChannelPoolKey> CHANNEL_POOL_KEY = AttributeKey.valueOf((String)"poolKey");
    private static final AttributeKey<Long> CHANNEL_TOUCH_TIMESTAMP = AttributeKey.valueOf((String)"idleTimestamp");
    private static final AttributeKey<Http2Connection> CHANNEL_HTTP2_CONNEXION = AttributeKey.valueOf((String)"http2Connection");
    private static final AttributeKey<Boolean> HTTP2_POOLED = AttributeKey.valueOf((String)"http2Pooled");
    private static final AttributeKey<Boolean> CHANNEL_GOAWAY = AttributeKey.valueOf((String)"goAway");
    static final int INITIAL_CLIENT_MAP_SIZE = 1000;
    static final int INITIAL_KEY_PER_CLIENT_MAP_SIZE = 2;
    static final int INITIAL_CHANNEL_QUEUE_SIZE = 2;
    private final Map<Long, Map<RemoteKey, Queue<Channel>>> channels = new HashMap<Long, Map<RemoteKey, Queue<Channel>>>(1000);
    private final CoalescingChannelPool coalescingChannelPool = new CoalescingChannelPool();

    private Queue<Channel> remoteChannels(ChannelPoolKey channelPoolKey) {
        return this.channels.computeIfAbsent(channelPoolKey.clientId, l -> new HashMap(2)).computeIfAbsent(channelPoolKey.remoteKey, remoteKey -> new ArrayDeque(2));
    }

    private static boolean isHttp1(Channel channel) {
        return channel.pipeline().get("app-http") != null;
    }

    public static boolean isHttp2(Channel channel) {
        return !ChannelPool.isHttp1(channel);
    }

    public static void registerPoolKey(Channel channel, ChannelPoolKey channelPoolKey) {
        channel.attr(CHANNEL_POOL_KEY).set((Object)channelPoolKey);
    }

    private static void touch(Channel channel) {
        channel.attr(CHANNEL_TOUCH_TIMESTAMP).set((Object)System.nanoTime());
    }

    private static boolean isLastTouchTooOld(Channel channel, long l, long l2) {
        return l - (Long)channel.attr(CHANNEL_TOUCH_TIMESTAMP).get() > l2;
    }

    public static void registerHttp2Connection(Channel channel, Http2Connection http2Connection) {
        channel.attr(CHANNEL_HTTP2_CONNEXION).set((Object)http2Connection);
    }

    private static Http2Connection getHttp2Connection(Channel channel) {
        return (Http2Connection)channel.attr(CHANNEL_HTTP2_CONNEXION).get();
    }

    private static boolean canOpenStream(Channel channel) {
        return ChannelPool.getHttp2Connection(channel).local().canOpenStream();
    }

    public static void markAsGoAway(Channel channel) {
        channel.attr(CHANNEL_GOAWAY).set((Object)Boolean.TRUE);
    }

    private static boolean isNotGoAway(Channel channel) {
        return !channel.hasAttr(CHANNEL_GOAWAY);
    }

    public Channel poll(ChannelPoolKey channelPoolKey) {
        Queue<Channel> queue = this.remoteChannels(channelPoolKey);
        Iterator iterator = queue.iterator();
        while (iterator.hasNext()) {
            Channel channel = (Channel)iterator.next();
            if (!channel.isActive()) {
                iterator.remove();
                break;
            }
            if (ChannelPool.isHttp1(channel)) {
                iterator.remove();
                LOGGER.debug("Retrieved HTTP/1 channel from pool for key {}", (Object)channelPoolKey);
                return channel;
            }
            if (!ChannelPool.isNotGoAway(channel) || !ChannelPool.canOpenStream(channel)) continue;
            LOGGER.debug("Retrieved HTTP/2 channel from pool for key {}", (Object)channelPoolKey);
            ChannelPool.touch(channel);
            return channel;
        }
        LOGGER.debug("No channel in the pool for key {}", (Object)channelPoolKey);
        return null;
    }

    public Channel pollCoalescedChannel(long l, String string, List<InetSocketAddress> list) {
        Channel channel2 = this.coalescingChannelPool.getCoalescedChannel(l, string, list, channel -> ChannelPool.isNotGoAway(channel) && ChannelPool.canOpenStream(channel));
        if (channel2 != null) {
            LOGGER.debug("Retrieved channel from coalescing pool for domain {}", (Object)string);
        }
        return channel2;
    }

    public void offerCoalescedChannel(Set<String> set, InetSocketAddress inetSocketAddress, Channel channel, ChannelPoolKey channelPoolKey) {
        IpAndPort ipAndPort = new IpAndPort(inetSocketAddress.getAddress().getAddress(), inetSocketAddress.getPort());
        LOGGER.debug("Offering channel entry {} with subjectAlternativeNames {} to coalescing pool", (Object)ipAndPort, set);
        this.coalescingChannelPool.addEntry(channelPoolKey.clientId, ipAndPort, set, channel);
    }

    public void offer(Channel channel) {
        ChannelPoolKey channelPoolKey = (ChannelPoolKey)channel.attr(CHANNEL_POOL_KEY).get();
        Assertions.assertNotNull(channelPoolKey, "Channel doesn't have a key");
        ChannelPool.touch(channel);
        LOGGER.debug("Offering channel entry {} to pool", (Object)channelPoolKey);
        if (ChannelPool.isHttp1(channel)) {
            this.remoteChannels(channelPoolKey).offer(channel);
        } else if (!channel.hasAttr(HTTP2_POOLED)) {
            channel.attr(HTTP2_POOLED).set((Object)Boolean.TRUE);
            this.remoteChannels(channelPoolKey).offer(channel);
        }
    }

    public void closeIdleChannels(long l) {
        long l2 = System.nanoTime();
        for (Map.Entry<Long, Map<RemoteKey, Queue<Channel>>> entry : this.channels.entrySet()) {
            for (Map.Entry<RemoteKey, Queue<Channel>> entry2 : entry.getValue().entrySet()) {
                Queue<Channel> queue = entry2.getValue();
                for (Channel channel : queue) {
                    boolean bl = ChannelPool.isHttp2(channel);
                    if (!ChannelPool.isLastTouchTooOld(channel, l2, l) || bl && ChannelPool.getHttp2Connection(channel).numActiveStreams() != 0) continue;
                    channel.close();
                    queue.remove(channel);
                    if (!bl) continue;
                    this.coalescingChannelPool.deleteIdleEntry(entry.getKey(), channel);
                }
            }
        }
    }

    public void flushClientIdChannelPoolPartitions(long l) {
        Map<RemoteKey, Queue<Channel>> map = this.channels.get(l);
        if (map != null) {
            map.entrySet().stream().flatMap(entry -> ((Queue)entry.getValue()).stream()).forEach(ChannelOutboundInvoker::close);
            this.channels.remove(l);
            this.coalescingChannelPool.deleteClientEntries(l);
        }
    }

    public String toString() {
        return "ChannelPool{channels=" + String.valueOf(this.channels) + ", coalescingChannelPool=" + String.valueOf(this.coalescingChannelPool) + "}";
    }
}

